<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * @return void
     */
    public function up()
    {
        // 1. افزودن فیلد آدرس به جدول companies (اگر قبلا وجود نداشت)
        if (Schema::hasTable('companies') && !Schema::hasColumn('companies', 'address')) {
            Schema::table('companies', function (Blueprint $table) {
                $table->text('address')->nullable()->after('image');
            });
        }

        // 2. افزودن ستون company_id به جدول users
        if (Schema::hasTable('users') && !Schema::hasColumn('users', 'company_id')) {
            Schema::table('users', function (Blueprint $table) {
                // فرض می‌کنیم Company Model و جدول Companies وجود دارد
                $table->foreignId('company_id')
                    ->nullable()
                    ->after('id')
                    ->constrained()
                    ->onDelete('set null');
            });
        }

        // 3. افزودن فلگ is_global به LetterForms (برای قالب‌های عمومی)
        if (Schema::hasTable('letter_forms') && !Schema::hasColumn('letter_forms', 'is_global')) {
            Schema::table('letter_forms', function (Blueprint $table) {
                $table->boolean('is_global')->default(false)->after('background');
            });
        }

        // 4. ایجاد جدول میانی company_letter_form (برای ارتباط Many-to-Many)
        Schema::create('company_letter_form', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('letter_form_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            // جلوگیری از تکرار
            $table->unique(['company_id', 'letter_form_id']);
        });
    }

    /**
     * Reverse the migrations.
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('address');
        });

        if (Schema::hasTable('users') && Schema::hasColumn('users', 'company_id')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropForeign(['company_id']);
                $table->dropColumn('company_id');
            });
        }

        if (Schema::hasTable('letter_forms') && Schema::hasColumn('letter_forms', 'is_global')) {
            Schema::table('letter_forms', function (Blueprint $table) {
                $table->dropColumn('is_global');
            });
        }

        Schema::dropIfExists('company_letter_form');
    }
};
