<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_parties', function (Blueprint $table) {
            $table->id();
            // اتصال به Project و Company
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            // ستون پویا برای نقش شرکت (مثلاً main_client, contractor)
            $table->string('party_role_type', 50);
            $table->timestamps();

            // یونیک کردن برای جلوگیری از تکرار نقش برای یک شرکت در یک پروژه
            $table->unique(['project_id', 'company_id', 'party_role_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_parties');
    }
};
