<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // .../xxxx_create_project_management_users_table.php

        Schema::create('project_management_users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('management_role', 50);
            $table->timestamps();

            // 🛑 FIX: تعریف نام کوتاه و دستی برای کلید یونیک مرکب
            $table->unique(['project_id', 'user_id', 'management_role'], 'proj_user_mgmt_unique'); // نام کمتر از 64 کاراکتر

            // 🛑 اگر از primary key نیز استفاده کرده‌اید (که در این نوع جداول رایج است):
            // $table->primary(['project_id', 'user_id', 'management_role']); // اگر این خط را دارید، از unique بالا خودداری کنید.

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_management_users');
    }
};
