<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('project_details', function (Blueprint $table) {

            // 💡 لیست ستون‌هایی که می‌خواهید حذف کنید
            $columnsToDrop = [
                'main_client_id',
                'sub_client_id',
                'contractor_id',
                'consultant_id',
                // 🛑 اگر ستون manager_id نیز قبلا حذف نشده، آن را هم اینجا قرار دهید.
                // 'manager_id',

                // 🛑 اگر ستون‌های user_id (مسئولین تماس) نیز در project_details بودند:
                // 'main_client_user_id',
                // 'contractor_user_id',
                // 'consultant_user_id',
            ];

            foreach ($columnsToDrop as $column) {
                // چک کردن وجود ستون قبل از حذف
                if (Schema::hasColumn('project_details', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('project_details', function (Blueprint $table) {
            //
        });
    }
};
