<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_wall_posts', function (Blueprint $table) {
            $table->id();

            // 💡 کلید خارجی پروژه و کاربر (با قابلیت حذف آبشاری)
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            $table->text('content'); // محتوای وضعیت/گزارش
            $table->string('type', 50)->default('status'); // نوع پست: status, report, issue

            $table->timestamps();

            // 💡 ایندکس گذاری برای کوئری‌های سریع بر اساس پروژه و زمان
            $table->index(['project_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_wall_posts');
    }
};
