<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wall_post_attachments', function (Blueprint $table) {
            $table->id();
            // 💡 اتصال به پست دیوار پروژه (ProjectWallPost)
            $table->foreignId('project_wall_post_id')->constrained()->onDelete('cascade');

            $table->string('file_path'); // آدرس ذخیره‌سازی فایل (Storage Path)
            $table->string('file_name'); // نام اصلی فایل
            $table->string('file_type', 50)->nullable(); // MIME type یا پسوند
            $table->unsignedBigInteger('file_size')->nullable(); // حجم فایل (به بایت)

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wall_post_attachments');
    }
};
