<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wall_post_comments', function (Blueprint $table) {
            $table->id();

            // اتصال به پست والد
            $table->foreignId('project_wall_post_id')->constrained('project_wall_posts')->onDelete('cascade');

            // اتصال به کاربر کامنت‌گذار
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');

            $table->text('content');

            // 💡 اگر نیاز به پاسخ به یک کامنت خاص دارید (Reply to Comment):
            $table->foreignId('parent_id')->nullable()->constrained('wall_post_comments')->onDelete('cascade');

            $table->timestamps(); // 💡 این خط، created_at و updated_at را ایجاد می‌کند.

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wall_post_comments');
    }
};
