<?php
// database/migrations/xxxx_add_execution_duration_to_project_insurances_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('project_insurances', function (Blueprint $table) {
            // 🛑 اضافه کردن ستون مدت اجرا (قابل تهی بودن)
            $table->integer('execution_duration')->nullable()->after('end_date');
        });
    }

    public function down(): void
    {
        Schema::table('project_insurances', function (Blueprint $table) {
            $table->dropColumn('execution_duration');
        });
    }
};
