<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // --- Contact Groups ---
        Schema::table('contact_groups', function (Blueprint $table) {
            if (!Schema::hasColumn('contact_groups', 'color')) {
                $table->string('color', 7)->nullable()->default('#4361EE')->after('name');
            }
            if (!Schema::hasColumn('contact_groups', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable()->after('color');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }
        });

        // --- Contacts ---
        Schema::table('contacts', function (Blueprint $table) {
            // فیلدهای اصلی که احتمالاً وجود دارند: name, phone_number, email, group_id

            if (!Schema::hasColumn('contacts', 'fax_number')) {
                $table->string('fax_number')->nullable()->after('phone_number');
            }

            if (!Schema::hasColumn('contacts', 'address')) {
                $table->text('address')->nullable()->after('email');
            }

            if (!Schema::hasColumn('contacts', 'phone_type')) {
                $table->enum('phone_type', ['mobile', 'work', 'home', 'internal', 'fax'])
                    ->default('mobile')
                    ->after('phone_number');
            }

            if (!Schema::hasColumn('contacts', 'is_public')) {
                $table->boolean('is_public')->default(false)->after('address');
            }

            if (!Schema::hasColumn('contacts', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable()->after('group_id');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }

            if (!Schema::hasColumn('contacts', 'tags')) {
                $table->string('tags')->nullable()->after('is_public');
                // یا برای پشتیبانی از تگ‌های پیشرفته‌تر: $table->json('tags')->nullable();
            }


             Schema::table('contacts', function (Blueprint $table) {
                 $table->index('tags');
                 $table->index('is_public');
                 $table->index('created_by');
             });
        });
    }

    public function down()
    {
        Schema::table('contact_groups', function (Blueprint $table) {
            $table->dropColumn(['color', 'created_by']);
        });

        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn([
                'fax_number', 'address', 'phone_type', 'is_public', 'created_by', 'tags'
            ]);
        });
    }
};
