<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * اجرای مایگریشن
     */
    public function up(): void
    {
        Schema::create('blog_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // نام دسته‌بندی (باید منحصربه‌فرد باشد)
            $table->string('slug')->unique(); // Slug برای URL (اختیاری اما توصیه می‌شود)
            $table->text('description')->nullable(); // توضیحات دسته‌بندی
            $table->timestamps();
        });
    }

    /**
     * بازگردانی مایگریشن
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_categories');
    }
};
