<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * اجرای مایگریشن
     */
    public function up(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            // افزودن فیلد category_id
            $table->foreignId('category_id')
                ->nullable() // اگر می‌خواهید پست بدون دسته‌بندی هم امکان‌پذیر باشد
                ->constrained('blog_categories') // ارجاع به جدول blog_categories
                ->after('author_id')
                ->onDelete('set null'); // در صورت حذف دسته‌بندی، مقدار این فیلد NULL می‌شود

            // افزودن فیلد media_file برای فایل‌های پیوست
            $table->string('media_file')->nullable()->after('image');
        });
    }

    /**
     * بازگردانی مایگریشن
     */
    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            // حذف کلید خارجی قبل از حذف ستون
            $table->dropForeign(['category_id']);

            // حذف ستون‌ها
            $table->dropColumn(['category_id', 'media_file']);
        });
    }
};
