<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            // ایجاد ستون کلید خارجی
            $table->foreignId('blog_category_id')->constrained()->cascadeOnDelete();
            // یا اگر از MySQL نسخه قدیمی‌تر استفاده می‌کنید:
            // $table->unsignedBigInteger('blog_category_id');
            // $table->foreign('blog_category_id')->references('id')->on('blog_categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            //
        });
    }
};
