<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            // ستون slug را به صورت منحصر به فرد (unique) و NOT NULL اضافه می‌کنیم
            // اگر قصد دارید اسلاگ را در بخش Livewire تولید کنید، NOT NULL بودن مشکلی ندارد.
            // اگر نه، باید nullable() باشد.
            $table->string('slug')->unique()->after('title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            //
        });
    }
};
