/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module font/fontcolor/fontcolorui
 */
import { IconFontColor } from 'ckeditor5/src/icons.js';
import { FontColorUIBase } from '../ui/colorui.js';
import { FONT_COLOR } from '../utils.js';
/**
 * The font color UI plugin. It introduces the `'fontColor'` dropdown.
 */
export class FontColorUI extends FontColorUIBase {
    /**
     * @inheritDoc
     */
    constructor(editor) {
        const t = editor.locale.t;
        super(editor, {
            commandName: FONT_COLOR,
            componentName: FONT_COLOR,
            icon: IconFontColor,
            dropdownLabel: t('Font Color')
        });
    }
    /**
     * @inheritDoc
     */
    static get pluginName() {
        return 'FontColorUI';
    }
}
