/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module fullscreen/fullscreen
 */
import { Plugin } from 'ckeditor5/src/core.js';
import { FullscreenEditing } from './fullscreenediting.js';
import { FullscreenUI } from './fullscreenui.js';
/**
 * The fullscreen mode feature.
 */
export class Fullscreen extends Plugin {
    /**
     * @inheritDoc
     */
    static get requires() {
        return [FullscreenEditing, FullscreenUI];
    }
    /**
     * @inheritDoc
     */
    static get pluginName() {
        return 'Fullscreen';
    }
    /**
     * @inheritDoc
     */
    static get isOfficialPlugin() {
        return true;
    }
}
