/**
 * @license Copyright (c) 2003-2025, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module ui
 */
// This import must be at the top to ensure that `globals.css` is imported first
export { View } from './view.js';
export { AriaLiveAnnouncerPoliteness, AriaLiveAnnouncer, AriaLiveAnnouncerView, AriaLiveAnnouncerRegionView } from './arialiveannouncer.js';
export { clickOutsideHandler } from './bindings/clickoutsidehandler.js';
export { CssTransitionDisablerMixin } from './bindings/csstransitiondisablermixin.js';
export { DraggableViewMixin } from './bindings/draggableviewmixin.js';
export { submitHandler } from './bindings/submithandler.js';
export { addKeyboardHandlingForGrid } from './bindings/addkeyboardhandlingforgrid.js';
export { AccessibilityHelpContentView } from './editorui/accessibilityhelp/accessibilityhelpcontentview.js';
export { AccessibilityHelp } from './editorui/accessibilityhelp/accessibilityhelp.js';
export { BodyCollection } from './editorui/bodycollection.js';
export { PoweredBy } from './editorui/poweredby.js';
export { Badge } from './badge/badge.js';
export { ButtonView } from './button/buttonview.js';
export { ButtonLabelView } from './button/buttonlabelview.js';
export { SwitchButtonView } from './button/switchbuttonview.js';
export { ListItemButtonView } from './button/listitembuttonview.js';
export { FileDialogButtonView, FileDialogListItemButtonView, FileDialogViewMixin } from './button/filedialogbuttonview.js';
export { CollapsibleView } from './collapsible/collapsibleview.js';
export { getLocalizedColorOptions, normalizeColorOptions, normalizeSingleColorDefinition } from './colorgrid/utils.js';
export { ColorGridView } from './colorgrid/colorgridview.js';
export { ColorTileView } from './colorgrid/colortileview.js';
export { ColorPickerView, SliderView, ColorPickerInputRowView } from './colorpicker/colorpickerview.js';
export { ColorSelectorView } from './colorselector/colorselectorview.js';
export { DocumentColorCollection } from './colorselector/documentcolorcollection.js';
export { ColorGridsFragmentView } from './colorselector/colorgridsfragmentview.js';
export { ColorPickerFragmentView } from './colorselector/colorpickerfragmentview.js';
export { ComponentFactory } from './componentfactory.js';
export { Dialog } from './dialog/dialog.js';
export { DialogView, DialogViewPosition } from './dialog/dialogview.js';
export { DialogActionsView } from './dialog/dialogactionsview.js';
export { DialogContentView } from './dialog/dialogcontentview.js';
export { DropdownView } from './dropdown/dropdownview.js';
export { DropdownPanelView } from './dropdown/dropdownpanelview.js';
export { DropdownButtonView } from './dropdown/button/dropdownbuttonview.js';
export { SplitButtonView } from './dropdown/button/splitbuttonview.js';
export { createDropdown, addMenuToDropdown, addToolbarToDropdown, addListToDropdown, focusChildOnDropdownOpen } from './dropdown/utils.js';
export { DropdownMenuPanelPositioningFunctions } from './dropdown/menu/utils.js';
export { DropdownMenuNestedMenuView } from './dropdown/menu/dropdownmenunestedmenuview.js';
export { DropdownMenuRootListView } from './dropdown/menu/dropdownmenurootlistview.js';
export { DropdownMenuListView } from './dropdown/menu/dropdownmenulistview.js';
export { DropdownMenuListItemView } from './dropdown/menu/dropdownmenulistitemview.js';
export { DropdownMenuListItemButtonView } from './dropdown/menu/dropdownmenulistitembuttonview.js';
export { DropdownMenuButtonView } from './dropdown/menu/dropdownmenubuttonview.js';
export { DropdownMenuNestedMenuPanelView } from './dropdown/menu/dropdownmenunestedmenupanelview.js';
export { EditorUI } from './editorui/editorui.js';
export { EditorUIView } from './editorui/editoruiview.js';
export { EvaluationBadge } from './editorui/evaluationbadge.js';
export { BoxedEditorUIView } from './editorui/boxed/boxededitoruiview.js';
export { InlineEditableUIView } from './editableui/inline/inlineeditableuiview.js';
export { EditableUIView } from './editableui/editableuiview.js';
export { FormRowView } from './formrow/formrowview.js';
export { FormHeaderView } from './formheader/formheaderview.js';
export { FocusCycler, isViewWithFocusCycler, isFocusable } from './focuscycler.js';
export { IconView } from './icon/iconview.js';
export { InputBase } from './input/inputbase.js';
export { InputView } from './input/inputview.js';
export { InputTextView } from './inputtext/inputtextview.js';
export { InputNumberView } from './inputnumber/inputnumberview.js';
export { TextareaView } from './textarea/textareaview.js';
export { IframeView } from './iframe/iframeview.js';
export { LabelView } from './label/labelview.js';
export { LabeledFieldView } from './labeledfield/labeledfieldview.js';
export { createLabeledInputNumber, createLabeledInputText, createLabeledTextarea, createLabeledDropdown } from './labeledfield/utils.js';
export { LabeledInputView } from './labeledinput/labeledinputview.js';
export { ListItemGroupView } from './list/listitemgroupview.js';
export { ListItemView } from './list/listitemview.js';
export { ListSeparatorView } from './list/listseparatorview.js';
export { ListView } from './list/listview.js';
export { filterGroupAndItemNames } from './search/filtergroupanditemnames.js';
export { Notification } from './notification/notification.js';
export { UIModel, UIModel as ViewModel // TODO: Remove after WProofReader has been adjusted.
 } from './model.js';
export { BalloonPanelView } from './panel/balloon/balloonpanelview.js';
export { ContextualBalloon } from './panel/balloon/contextualballoon.js';
export { StickyPanelView } from './panel/sticky/stickypanelview.js';
export { AutocompleteView } from './autocomplete/autocompleteview.js';
export { SearchTextView } from './search/text/searchtextview.js';
export { SearchResultsView } from './search/searchresultsview.js';
export { SearchInfoView } from './search/searchinfoview.js';
export { HighlightedTextView } from './highlightedtext/highlightedtextview.js';
export { ButtonLabelWithHighlightView } from './highlightedtext/buttonlabelwithhighlightview.js';
export { LabelWithHighlightView } from './highlightedtext/labelwithhighlightview.js';
export { TooltipManager } from './tooltipmanager.js';
export { Template } from './template.js';
export { SpinnerView } from './spinner/spinnerview.js';
export { ToolbarView, ItemsView } from './toolbar/toolbarview.js';
export { ToolbarLineBreakView } from './toolbar/toolbarlinebreakview.js';
export { ToolbarSeparatorView } from './toolbar/toolbarseparatorview.js';
export { normalizeToolbarConfig } from './toolbar/normalizetoolbarconfig.js';
export { BalloonToolbar } from './toolbar/balloon/balloontoolbar.js';
export { BlockToolbar } from './toolbar/block/blocktoolbar.js';
export { BlockButtonView } from './toolbar/block/blockbuttonview.js';
export { ViewCollection } from './viewcollection.js';
export { MenuBarView } from './menubar/menubarview.js';
export { MenuBarMenuButtonView } from './menubar/menubarmenubuttonview.js';
export { MenuBarMenuPanelView } from './menubar/menubarmenupanelview.js';
export { MenuBarMenuView } from './menubar/menubarmenuview.js';
export { MenuBarMenuListView } from './menubar/menubarmenulistview.js';
export { MenuBarMenuListItemView } from './menubar/menubarmenulistitemview.js';
export { MenuBarMenuListItemButtonView } from './menubar/menubarmenulistitembuttonview.js';
export { MenuBarMenuListItemFileDialogButtonView } from './menubar/menubarmenulistitemfiledialogbuttonview.js';
export { normalizeMenuBarConfig, DefaultMenuBarItems } from './menubar/utils.js';
// Internals
export { preventDefault as _preventUiViewDefault } from './bindings/preventdefault.js';
export { CheckIconHolderView as _CheckIconHolderView } from './button/listitembuttonview.js';
export { CollapsibleView as _CollapsibleView } from './collapsible/collapsibleview.js';
export { tryParseHexColor as _tryNormalizeHexColor } from './colorpicker/colorpickerview.js';
export { convertColor as _convertColor } from './colorpicker/utils.js';
export { convertToHex as _convertColorToHex } from './colorpicker/utils.js';
export { registerCustomElement as _registerCustomElement } from './colorpicker/utils.js';
export { DropdownRootMenuBehaviors as _DropdownRootMenuBehaviors } from './dropdown/menu/dropdownmenubehaviors.js';
export { DropdownMenuBehaviors as _DropdownMenuBehaviors } from './dropdown/menu/dropdownmenubehaviors.js';
export { MenuBarBehaviors as _MenuBarBehaviors } from './menubar/utils.js';
export { MenuBarMenuBehaviors as _MenuBarMenuBehaviors } from './menubar/utils.js';
export { MenuBarMenuViewPanelPositioningFunctions as _MenuBarMenuViewPanelPositioningFunctions } from './menubar/utils.js';
export { processMenuBarConfig as _processMenuBarConfig } from './menubar/utils.js';
export { RotatorView as _ContextualBalloonRotatorView } from './panel/balloon/contextualballoon.js';
export { SearchInfoView as _SearchInfoView } from './search/searchinfoview.js';
export { SearchTextQueryView as _SearchTextQueryView } from './search/text/searchtextqueryview.js';
export { TemplateBinding as _TemplateBinding } from './template.js';
export { TemplateToBinding as _TemplateToBinding } from './template.js';
export { TemplateIfBinding as _TemplateIfBinding } from './template.js';
export { NESTED_TOOLBAR_ICONS } from './toolbar/toolbarview.js';
import './augmentation.js';
