/**
 * Transform a hast tree to a DOM tree
 *
 * @param {HastNodes} tree
 *   Tree to transform.
 * @param {Options | null | undefined} [options]
 *   Configuration (optional).
 * @returns {Comment | Document | DocumentFragment | DocumentType | Element | Text}
 *   Equivalent DOM node.
 */
export function toDom(tree: HastNodes, options?: Options | null | undefined): Comment | Document | DocumentFragment | DocumentType | Element | Text;
/**
 * Callback called when each node is transformed.
 */
export type AfterTransform = (hastNode: HastNodes, domNode: Node) => undefined | void;
/**
 * Configuration.
 */
export type Options = {
    /**
     * Callback called when each node is transformed (optional).
     */
    afterTransform?: AfterTransform | null | undefined;
    /**
     * Document interface to use (default: `globalThis.document`).
     */
    document?: Document | null | undefined;
    /**
     * Whether to return a DOM fragment (`true`) or a whole document (`false`)
     * (default: `false`).
     */
    fragment?: boolean | null | undefined;
    /**
     * Namespace to use to create elements (optional).
     */
    namespace?: string | null | undefined;
};
/**
 * Info passed around about the current state.
 */
export type State = {
    /**
     *   Document interface to use.
     */
    doc: Document;
    /**
     *   Whether a fragment (`true`) or whole document (`false`) is built.
     */
    fragment: boolean;
    /**
     *   Explicit namespace to use.
     */
    namespace: string | undefined;
    /**
     *   Namespace.
     */
    impliedNamespace: string | undefined;
    /**
     *   Callback called after each hast node is transformed.
     */
    afterTransform: AfterTransform | undefined;
};
import type { Nodes as HastNodes } from 'hast';
//# sourceMappingURL=index.d.ts.map