/*! Editable 0.1.1
 * © 2016-2017 Karl Saunders
 */
/**
 * @summary     Editable
 * @description Allow editing of cells and rows
 * @version     0.1.1
 * @file        datatable.editable.js
 * @author      Karl Saunders
 * @contact     mobius1@gmx.com
 * @copyright   Copyright 2016-2017 Karl Saunders
 *
 * Double-click a cell to edit and hit enter to submit.
 * Right click to show context menu of editor options (Edit Cell, Edit Row, Remove Row).
 *
 * This source file is free software, available under the following license:
 *   MIT license - https://github.com/Mobius1/Vanilla-DataTables/blob/master/LICENSE
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: https://github.com/Mobius1/Vanilla-DataTables
 */
window.DataTable&&DataTable.extend("editable",function(t,e,i){var n={classes:{row:"dt-editor-row",form:"dt-editor-form",item:"dt-editor-item",menu:"dt-editor-menu",save:"dt-editor-save",block:"dt-editor-block",close:"dt-editor-close",inner:"dt-editor-inner",input:"dt-editor-input",label:"dt-editor-label",modal:"dt-editor-modal",action:"dt-editor-action",header:"dt-editor-header",wrapper:"dt-editor-wrapper",editable:"dt-editor-editable",container:"dt-editor-container",separator:"dt-editor-separator"},hiddenColumns:!1,contextMenu:!0,clickEvent:"dblclick",menuItems:[{text:"Edit Cell",action:function(t){this.editCell()}},{text:"Edit Row",action:function(t){this.editRow()}},{separator:!0},{text:"Remove Row",action:function(t){confirm("Are you sure?")&&this.removeRow()}}]},s=function(t,e,i){t.addEventListener(e,i,!1)},o=function(t,e,i){t.removeEventListener(e,i)},a=function(t,e){return t&&t!==document.body&&(e(t)?t:a(t.parentNode,e))},d=function(t,e,i){var n;return function(){var s=this,o=arguments,a=i&&!n;clearTimeout(n),n=setTimeout(function(){n=null,i||t.apply(s,o)},e),a&&t.apply(s,o)}},l=function(t,e){this.target=t,this.config=i.extend(n,e)};return l.prototype.init=function(){if(!this.initialised){var e=this,n=e.config;i.classList.add(t.wrapper,n.classes.editable),n.contextMenu&&(e.container=i.createElement("div",{id:n.classes.container}),e.wrapper=i.createElement("div",{class:n.classes.wrapper}),e.menu=i.createElement("ul",{class:n.classes.menu}),n.menuItems&&n.menuItems.length&&n.menuItems.forEach(function(t){var o=i.createElement("li",{class:t.separator?n.classes.separator:n.classes.item});if(!t.separator){var a=i.createElement("a",{class:n.classes.action,href:t.url||"#",html:t.text});o.appendChild(a),t.action&&"function"==typeof t.action&&s(a,"click",function(i){i.preventDefault(),t.action.call(e,i)})}e.menu.appendChild(o)}),e.wrapper.appendChild(e.menu),e.container.appendChild(e.wrapper),e.update()),e.data={},e.closed=!0,e.editing=!1,e.editingRow=!1,e.editingCell=!1,e.bindEvents(),setTimeout(function(){e.initialised=!0,t.emit("editable.init")},10)}},l.prototype.bindEvents=function(){this.events={context:this.context.bind(this),update:this.update.bind(this),dismiss:this.dismiss.bind(this),keydown:this.keydown.bind(this),click:this.click.bind(this)},s(this.target,this.config.clickEvent,this.events.click),s(document,"click",this.events.dismiss),s(document,"keydown",this.events.keydown),this.config.contextMenu&&(s(this.target,"contextmenu",this.events.context),this.events.reset=d(this.events.update,50),s(window,"resize",this.events.reset),s(window,"scroll",this.events.reset))},l.prototype.context=function(t){this.event=t;var e=this.target.contains(t.target);if(this.config.contextMenu&&!this.disabled&&e){t.preventDefault();var i=t.pageX,n=t.pageY;i>this.limits.x&&(i-=this.rect.width),n>this.limits.y&&(n-=this.rect.height),this.wrapper.style.top=n+"px",this.wrapper.style.left=i+"px",this.openMenu(),this.update()}},l.prototype.click=function(t){if(!this.editing){var e=a(t.target,function(t){return"TD"===t.nodeName});e&&(this.editCell(e),t.preventDefault())}},l.prototype.keydown=function(t){this.editing&&this.data&&(13===t.keyCode?this.editingCell?this.saveCell():this.editingRow&&this.saveRow():27===t.keyCode&&this.saveCell(this.data.content))},l.prototype.editCell=function(e){if("TD"===(e=e||a(this.event.target,function(t){return"TD"===t.nodeName})).nodeName&&!this.editing){var n=this;e=t.table.rows[e.parentNode.dataIndex].cells[e.dataIndex],n.data={cell:e,content:e.content,input:i.createElement("input",{type:"text",value:e.content,class:n.config.classes.input})},e.node.innerHTML="",e.node.appendChild(n.data.input),setTimeout(function(){n.data.input.focus(),n.data.input.selectionStart=n.data.input.selectionEnd=n.data.input.value.length,n.editing=!0,n.editingCell=!0,n.closeMenu()},10)}},l.prototype.saveCell=function(e,i){i=i||this.data.cell,e=e||this.data.input.value;var n=i.content;i.setContent(e.trim()),this.data={},this.editing=this.editingCell=!1,t.emit("editable.save.cell",e,n)},l.prototype.editRow=function(e){if("TR"===(e=e||a(this.event.target,function(t){return"TR"===t.nodeName})).nodeName&&!this.editing){var n=this,s=n.config,e=t.table.rows[e.dataIndex],o=["<div class='"+s.classes.inner+"'>","<div class='"+s.classes.header+"'>","<h4>Editing row</h4>","<button class='"+s.classes.close+"' type='button' data-editor-close>×</button>"," </div>","<div class='"+s.classes.block+"'>","<form class='"+s.classes.form+"'>","<div class='"+s.classes.row+"'>","<button class='"+s.classes.save+"' type='button' data-editor-save>Save</button>","</div>","</form>","</div>","</div>"].join(""),d=i.createElement("div",{class:s.classes.modal,html:o}),l=d.firstElementChild.lastElementChild.firstElementChild;[].slice.call(e.cells).forEach(function(e,n){(!e.hidden||e.hidden&&s.hiddenColumns)&&l.insertBefore(i.createElement("div",{class:s.classes.row,html:["<div class='datatable-editor-row'>","<label class='"+s.classes.label+"'>"+t.table.header.cells[n].content+"</label>","<input class='"+s.classes.input+"' value='"+e.content+"' type='text'>","</div>"].join("")}),l.lastElementChild)}),this.modal=d,this.openModal();var c=[].slice.call(l.elements);c.pop(),n.data={row:e,inputs:c},this.editing=!0,this.editingRow=!0,d.addEventListener("click",function(t){var e=t.target;e.hasAttribute("data-editor-close")?n.closeModal():e.hasAttribute("data-editor-save")&&n.saveRow()}),n.closeMenu()}},l.prototype.saveRow=function(e,i){var n=this;n.config;e=e||n.data.inputs.map(function(t){return t.value.trim()});var s=(i=i||n.data.row).cells.map(function(t){return t.content});i.cells.forEach(function(t,i){t.setContent(e[i])}),this.closeModal(),t.emit("editable.save.row",e,s)},l.prototype.openModal=function(){!this.editing&&this.modal&&document.body.appendChild(this.modal)},l.prototype.closeModal=function(){this.editing&&this.modal&&(document.body.removeChild(this.modal),this.modal=this.editing=this.editingRow=!1)},l.prototype.removeRow=function(e){e?(e instanceof Element&&"TR"===e.nodeName&&void 0!==e.dataIndex&&(e=e.dataIndex),t.rows().remove(e),this.closeMenu()):(e=a(this.event.target,function(t){return"TR"===t.nodeName}))&&void 0!==e.dataIndex&&(t.rows().remove(e.dataIndex),this.closeMenu())},l.prototype.update=function(){var t=window.scrollX||window.pageXOffset,e=window.scrollY||window.pageYOffset;this.rect=this.wrapper.getBoundingClientRect(),this.limits={x:window.innerWidth+t-this.rect.width,y:window.innerHeight+e-this.rect.height}},l.prototype.dismiss=function(t){var e=!0;this.config.contextMenu&&(e=!this.wrapper.contains(t.target),this.editing&&(e=!this.wrapper.contains(t.target)&&t.target!==this.data.input)),e&&(this.editingCell&&this.saveCell(this.data.cell.content),this.closeMenu())},l.prototype.openMenu=function(){this.config.contextMenu&&(document.body.appendChild(this.container),this.closed=!1,t.emit("editable.context.open"))},l.prototype.closeMenu=function(){this.config.contextMenu&&!this.closed&&(this.closed=!0,document.body.removeChild(this.container),t.emit("editable.context.close"))},l.prototype.destroy=function(){o(this.target,this.config.clickEvent,this.events.click),o(this.target,"contextmenu",this.events.context),o(document,"click",this.events.dismiss),o(document,"keydown",this.events.keydown),o(window,"resize",this.events.reset),o(window,"scroll",this.events.reset),document.body.contains(this.container)&&document.body.removeChild(this.container),this.initialised=!1},new l(this.table.body,e)});