@props(['data'])

@php
    $d = $data;
    $title = $d['title'] ?? 'بدون عنوان';
    $content = $d['content'] ?? '<p style="text-align: right;">محتوایی موجود نیست</p>';
    $project = $d['project'] ?? (object)['name' => 'پروژه نامشخص'];
    $background = $d['background'] ?? null;
    $priority = $d['priority'] ?? 'normal';
    $priorityLabel = $d['priorityLabel'] ?? 'عادی';
    $from_who = $d['from_who'] ?? '---';
    $from_where = $d['from_where'] ?? '---';
    $letter_date = $d['letter_date'] ?? '---';
    $ccs = $d['ccs'] ?? [];
    $signer_name = $d['signer_name'] ?? 'نام امضاکننده';
    $signature_position = $d['signature_position'] ?? 'سمت امضاکننده';

    $showWatermark = $d['show_watermark'] ?? false;
    $layoutSections = $d['layoutSections'] ?? ['header' => false, 'footer' => false, 'title' => true, 'metadata' => true, 'content' => true, 'attachments' => true, 'signature' => true];

    $bgUrl = $background?->background
        ? Illuminate\Support\Facades\Storage::disk('letter_template')->url($background->background)
        : null;

    $contentPadding = '35mm 20mm 35mm 20mm';
    $contentDivStyle = $bgUrl ? 'position: relative; z-index: 2;' : '';
@endphp

<style>
    /* همۀ استایل‌هایی که داشتی، همین‌جا بماند */
    @page {
        size: A4 portrait;
        margin: 0;
        @top-center { content: element(letter-header); }
        @bottom-center { content: element(letter-footer); }
    }

    .letter-preview {
        width: 210mm;
        min-height: 297mm;
        margin: 0 auto;
        background: white;
        box-shadow: 0 0 10px rgba(0,0,0,0.2);
        font-family: 'IRANSans', 'Vazirmatn', 'Tahoma', sans-serif;
        line-height: 1.6;
        color: #333;
        position: relative;
        padding: 0;
        direction: rtl;
        text-align: right;
    }

    .print-header { position: running(letter-header); z-index: 1000; padding: 10mm 20mm 0 20mm; }
    .print-footer { position: running(letter-footer); z-index: 1000; padding: 0 20mm 10mm 20mm; }

    .background-layer {
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background-repeat: no-repeat;
        background-size: 100% 100%;
        z-index: 1;
        pointer-events: none;
    }

    .watermark {
        position: absolute;
        top: 50%; left: 50%;
        transform: translate(-50%, -50%) rotate(-45deg);
        font-size: 80px;
        color: rgba(0,0,0,0.05);
        z-index: 2;
        pointer-events: none;
    }

    .letter-inner-content {
        padding: {{ $contentPadding }};
        box-sizing: border-box;
        width: 100%;
        min-height: 297mm;
    }

    .section-content {
        font-size: 11pt;
        text-align: justify;
        line-height: 1.8;
        margin-bottom: 30px;
        word-wrap: break-word;
        page-break-inside: auto;
    }
    .section-content * {
        max-width: 100% !important;
        box-sizing: border-box;
        word-wrap: break-word;
        page-break-inside: auto;
    }

    .section-metadata {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        font-size: 10pt;
        margin-bottom: 30px;
        border-bottom: 1px solid #eee;
        padding-bottom: 15px;
    }
    .meta-label { font-weight: 600; color: #555; margin-left: 5px; }

    .section-bottom-area {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-top: 50px;
        page-break-before: avoid;
    }
    .signature-box {
        flex-basis: 30%;
        text-align: center;
        font-size: 10pt;
    }
    .cc-box {
        flex-basis: 60%;
        text-align: right;
        font-size: 9pt;
        color: #777;
        border-top: 1px dashed #ddd;
        padding-top: 10px;
    }

    .priority-indicator {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 9pt;
        font-weight: bold;
        color: white;
        margin-right: 5px;
    }
    .priority-urgent { background: #E91E63; }
    .priority-high { background: #FF9800; }
    .priority-normal { background: #4CAF50; }
    .priority-low { background: #2196F3; }

    @media print {
        .letter-preview { box-shadow: none; margin: 0; padding: 0 !important; }
        .background-layer { display: none; }
        .letter-inner-content {
            padding: 35mm 20mm 35mm 20mm !important;
            min-height: auto;
        }
    }
</style>

<div class="letter-preview">

    @if($bgUrl)
        <div class="background-layer" style="background-image: url('{{ $bgUrl }}');"></div>
    @endif

    @if($showWatermark)
        <div class="watermark">PREVIEW</div>
    @endif

    <div class="letter-inner-content" style="{!! $contentDivStyle !!}">

{{--        <div class="print-header">--}}
{{--            @if($bgUrl)--}}
{{--                <div style="height: 30mm; background-image: url('{{ $bgUrl }}'); background-size: 100% 100%; position: absolute; top: 0; left: 0; right: 0;"></div>--}}
{{--            @else--}}
{{--                <h3 style="text-align: center; border-bottom: 1px solid #333; padding-bottom: 5px; font-size: 12pt;">--}}
{{--                    {{ $project->name }}--}}
{{--                </h3>--}}
{{--            @endif--}}
{{--        </div>--}}

        @if($layoutSections['metadata'])
            <div class="section-metadata">
                <div style="flex-basis: 55%;">
                    <div class="meta-item"><span class="meta-label">📨 از:</span> {{ $from_who }}</div>
                    <div class="meta-item"><span class="meta-label">📬 به:</span> {{ $from_where }}</div>
                </div>

                <div style="flex-basis: 40%; text-align: left;">
                    <div class="meta-item" style="font-weight: bold; color: #555;">{{ $project->name }}</div>
                    <div class="meta-item"><span class="meta-label">📅 تاریخ:</span> {{ $letter_date }}</div>
                    <div class="meta-item">
                        <span class="meta-label">🎯 اولویت:</span>
                        <span class="priority-indicator priority-{{ $priority }}">
                            {{ $priorityLabel }}
                        </span>
                    </div>
                </div>
            </div>
        @endif

        <h2 class="section-title">{{ $title }}</h2>

        <div class="section-content">
            {!! $content !!}
        </div>

        @if($layoutSections['attachments'] && !empty($d['attachments'] ?? []))
            <div class="section-attachments" style="border: 1px solid #ddd; padding: 10px; font-size: 10pt; margin-top: 20px; border-radius: 5px;">
                <strong>📎 پیوست‌ها:</strong>
                <ul style="list-style: disc; margin: 5px 0 0 20px; padding: 0; line-height: 1.5;">
                    @foreach($d['attachments'] as $attachment)
                        <li style="margin-right: 15px;">{{ $attachment['original_name'] ?? ($attachment['name'] ?? 'فایل پیوست') }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="section-bottom-area">
            @if(!empty($ccs))
                <div class="cc-box">
                    <strong>👥 رونوشت به:</strong>
                    <div style="margin-top: 5px; line-height: 1.6;">
                        @foreach($ccs as $cc)
                            <span style="display: inline-block; margin-left: 15px;">
                                {{ $cc['name'] }} @if($cc['position']) ({{ $cc['position'] }}) @endif
                            </span>
                        @endforeach
                    </div>
                </div>
            @endif

            @if($layoutSections['signature'])
                <div class="signature-box">
                    <div style="border-top: 1px solid #333; padding-top: 15px; margin-bottom: 5px;">
                        {{ $signer_name }}
                    </div>
                    <p style="margin: 0;">{{ $signature_position }}</p>
                </div>
            @endif
        </div>
    </div>

    <div class="print-footer">
        @if($layoutSections['footer'])
            <p style="font-size: 10pt; color: #777; text-align: center; border-top: 1px solid #eee;">
                این سند به صورت الکترونیکی تولید شده است. (پروژه: {{ $project->name }})
            </p>
        @endif
    </div>
</div>
