<nav role="navigation" aria-label="صفحه‌بندی" class="pagination-container">
    <ul class="pagination pagination-rounded mb-0">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li class="page-item disabled" aria-disabled="true">
                <span class="page-link"><i class="fas fa-angle-right"></i></span>
            </li>
        @else
            <li class="page-item">
                <button type="button" class="page-link" wire:click="gotoPage({{ $paginator->currentPage() - 1 }})" wire:loading.attr="disabled">
                    <i class="fas fa-angle-right"></i>
                </button>
            </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="page-item active" aria-current="page">
                            <span class="page-link">{{ $page }}</span>
                        </li>
                    @else
                        <li class="page-item">
                            <button type="button" class="page-link" wire:click="gotoPage({{ $page }})" wire:loading.attr="disabled">{{ $page }}</button>
                        </li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li class="page-item">
                <button type="button" class="page-link" wire:click="gotoPage({{ $paginator->currentPage() + 1 }})" wire:loading.attr="disabled">
                    <i class="fas fa-angle-left"></i>
                </button>
            </li>
        @else
            <li class="page-item disabled" aria-disabled="true">
                <span class="page-link"><i class="fas fa-angle-left"></i></span>
            </li>
        @endif
    </ul>
</nav>
