<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>پروتکل ۴۰۳ | دسترسی محدود</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">

    <script src="{{url('panel/dist/js/lottiefiles/lottie-player.js')}}"></script>
    <link rel="stylesheet" href="{{url('panel/dist/css/style.min.css')}}">

    <style>
        /* استفاده از فونت وزیر با اعداد فارسی پیش‌فرض */

        :root {
            --primary: #6366f1;
            --accent: #c6a667;
            --danger: #f43f5e;
            --glass: rgba(255, 255, 255, 0.75);
            --navy: #0f172a;
        }

        .night {
            --glass: rgba(10, 15, 30, 0.85);
            --navy: #f1f5f9;
            --primary: #818cf8;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'PeydaWebNoEn', sans-serif; }

        body {
            font-family: PeydaWebNoEn;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #020617;
            color: var(--navy);
            overflow: hidden;
            perspective: 1000px;
        }

        /* پس‌زمینه انتزاعی متحرک */
        .cyber-bg {
            position: absolute;
            width: 100%; height: 100%;
            background: radial-gradient(circle at center, #1e1b4b 0%, #020617 100%);
            z-index: 1;
        }

        .orb {
            position: absolute;
            width: 600px; height: 600px;
            background: radial-gradient(circle, rgba(99, 102, 241, 0.15) 0%, transparent 70%);
            filter: blur(50px);
            animation: float 20s infinite alternate;
        }

        @keyframes float {
            0% { transform: translate(-10%, -10%); }
            100% { transform: translate(10%, 10%); }
        }

        /* کارت شیشه‌ای با لبه‌های نوری */
        .lux-card {
            position: relative;
            z-index: 10;
            background: var(--glass);
            backdrop-filter: blur(40px) saturate(180%);
            -webkit-backdrop-filter: blur(40px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50px;
            padding: 90px 60px 50px;
            text-align: center;
            width: 580px;
            box-shadow: 0 50px 100px -20px rgba(0,0,0,0.5);
            transform-style: preserve-3d;
        }

        /* بخش آواتار با افکت اسکن */
        .identity-shield {
            position: absolute;
            top: -60px; left: 50%;
            transform: translateX(-50%) translateZ(50px);
        }

        .avatar-container {
            width: 120px; height: 120px;
            padding: 6px; background: linear-gradient(135deg, var(--primary), var(--accent));
            border-radius: 40px; position: relative;
            box-shadow: 0 25px 50px rgba(99, 102, 241, 0.4);
            overflow: hidden;
        }

        .avatar-img {
            width: 100%; height: 100%;
            border-radius: 34px; border: 3px solid #fff;
            object-fit: cover; background: #fff;
        }

        /* خط اسکن بیومتریک */
        .scanner-line {
            position: absolute;
            top: 0; left: 0; width: 100%; height: 4px;
            background: var(--primary);
            box-shadow: 0 0 15px var(--primary);
            animation: scan 3s infinite ease-in-out;
            z-index: 5;
        }

        @keyframes scan {
            0%, 100% { top: 5%; opacity: 0; }
            50% { top: 90%; opacity: 1; }
        }

        /* استایل عدد ۴۰۳ متالیک */
        .error-code {
            font-size: 10rem;
            font-weight: 900;
            line-height: 0.7;
            margin-bottom: 25px;
            background: linear-gradient(180deg, var(--navy) 20%, var(--primary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            filter: drop-shadow(0 20px 30px rgba(99, 102, 241, 0.3));
            letter-spacing: -8px;
        }

        .error-title { font-size: 2.2rem; font-weight: 900; margin-bottom: 12px; color: var(--navy); }
        .error-desc { opacity: 0.8; line-height: 1.8; margin-bottom: 45px; font-size: 1.05rem; }

        /* دکمه‌های پرمیوم */
        .actions { display: flex; gap: 20px; justify-content: center; margin-bottom: 40px; }

        .btn-lux {
            padding: 20px 40px; border-radius: 25px;
            font-weight: 800; text-decoration: none;
            display: flex; align-items: center; gap: 12px;
            transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            background: var(--navy); color: #fff; border: none; cursor: pointer;
        }

        .btn-lux:hover {
            transform: translateY(-10px) scale(1.05);
            box-shadow: 0 30px 60px rgba(99, 102, 241, 0.4);
            background: var(--primary);
        }

        /* فوتر هوشمند */
        .system-info {
            display: flex; justify-content: center; gap: 25px;
            font-size: 0.75rem; font-weight: 700; opacity: 0.5;
            text-transform: uppercase; letter-spacing: 1px;
        }

        .timer-bar {
            margin-top: 30px; position: relative;
            height: 4px; width: 200px; background: rgba(255,255,255,0.1);
            margin-inline: auto; border-radius: 10px; overflow: hidden;
        }

        .timer-progress {
            position: absolute; right: 0; top: 0; height: 100%;
            background: var(--danger); width: 100%;
            transition: width 1s linear;
        }

        .theme-toggle {
            position: fixed; top: 35px; left: 35px;
            width: 60px; height: 60px; border-radius: 22px;
            border: 1px solid rgba(255,255,255,0.1);
            background: var(--glass); cursor: pointer; z-index: 100;
            transition: 0.3s; font-size: 1.5rem;
        }
    </style>
</head>
<body>

<div class="cyber-bg">
    <div class="orb" style="top: 0; right: 0;"></div>
    <div class="orb" style="bottom: 0; left: 0; background: rgba(198, 166, 103, 0.1);"></div>
</div>

<button class="theme-toggle" onclick="toggleTheme()">🌓</button>

<div class="lux-card" id="tiltCard">
    <div class="identity-shield">
        <div class="avatar-container">
            <div class="scanner-line"></div>
            <img src="{{ Auth::check() && Auth::user()->image ? asset('storage/' . Auth::user()->image) : asset('panel/dist/images/profile/user-1.jpg') }}" class="avatar-img">
        </div>
    </div>

    <div class="error-code">۴۰۳</div>
    <h1 class="error-title">عدم تایید هویت دسترسی</h1>
    <p class="error-desc">درخواست شما توسط لایه امنیتی سامانه مرسا مسدود شد. سطح دسترسی شما برای مشاهده این دیتابیس کافی نیست.</p>

    <div class="actions">
        <a href="{{ url('/') }}" class="btn-lux shadow-lg">
            <i class="ti ti-shield-check fs-4"></i> میزکار امن
        </a>
        <button class="btn-lux" style="background: rgba(255,255,255,0.05); color: var(--navy);" onclick="history.back()">
            بازگشت <i class="ti ti-chevron-left fs-4"></i>
        </button>
    </div>

    <div class="system-info">
        <span>آی‌پی: {{ request()->ip() }}</span>
        <span>زمان: <span id="sysTime">--:--</span></span>
        <span>وضعیت: محدود شده</span>
    </div>

    <div class="timer-bar">
        <div class="timer-progress" id="tProg"></div>
    </div>
    <p style="font-size: 0.8rem; margin-top: 10px; opacity: 0.6;">
        بازگشت خودکار در <span id="timerSec">۱۰</span> ثانیه
    </p>
</div>

<script>
    // تبدیل اعداد به فارسی
    const toFarsi = (n) => n.toString().replace(/\d/g, x => "۰۱۲۳۴۵۶۷۸۹"[x]);

    // تایمر و نوار پیشرفت
    let sec = 10;
    const interval = setInterval(() => {
        sec--;
        document.getElementById('timerSec').innerText = toFarsi(sec);
        document.getElementById('tProg').style.width = (sec * 10) + "%";
        if (sec <= 0) {
            clearInterval(interval);
            window.location.href = "{{ url('/') }}";
        }
    }, 1000);

    // ساعت سیستمی زنده
    setInterval(() => {
        const d = new Date();
        document.getElementById('sysTime').innerText = toFarsi(d.getHours().toString().padStart(2, '0')) + ":" + toFarsi(d.getMinutes().toString().padStart(2, '0'));
    }, 1000);

    // افکت Tilt پیشرفته
    const card = document.getElementById('tiltCard');
    document.addEventListener('mousemove', (e) => {
        const xAxis = (window.innerWidth / 2 - e.pageX) / 25;
        const yAxis = (window.innerHeight / 2 - e.pageY) / 25;
        card.style.transform = `rotateY(${xAxis}deg) rotateX(${-yAxis}deg)`;
    });

    function toggleTheme() {
        document.body.classList.toggle('night');
        localStorage.setItem('theme', document.body.classList.contains('night') ? 'night' : 'day');
    }

    window.onload = () => {
        if (localStorage.getItem('theme') === 'night') document.body.classList.add('night');
    }
</script>

</body>
</html>
