@php
    // ابزارهای کوچک برای تاریخ و لینک
    $toFa = function ($dt) {
        if (!$dt) return '-';
        try {
            if (function_exists('jdate')) return jdate($dt)->format('Y/m/d');
            return \Carbon\Carbon::parse($dt)->format('Y/m/d');
        } catch (\Throwable $e) { return '-'; }
    };
    $lastTrans = function ($doc) {
        return optional($doc->transmittalDocuments)->sortByDesc(
            fn($td)=> optional($td->transmittal)->sent_at
        )->first();
    };
@endphp

    <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>MDR PDF - {{ $project->name ?? '' }}</title>
    <style>
        @page { margin: 90px 40px 70px 40px; }
        body { font-family: DejaVu Sans, sans-serif; direction: rtl; font-size: 12px; color: #222; }

        /* Header / Footer */
        header { position: fixed; top: -70px; left: 0; right: 0; height: 60px; }
        footer { position: fixed; bottom: -50px; left: 0; right: 0; height: 40px; font-size: 11px; color:#666; }

        .hdr {
            display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #ddd; padding-bottom:8px;
        }
        .hdr .title { font-size: 16px; font-weight: bold; }
        .meta { margin: 6px 0 0; font-size: 11px; color:#555; }
        .chips { margin-top: 6px; display:flex; flex-wrap:wrap; gap:6px; }
        .chip { background:#f3f4f6; border:1px solid #e5e7eb; padding:3px 8px; border-radius:6px; font-size:10px; }

        .stats { display:flex; gap:10px; margin: 10px 0 14px; }
        .stat { background:#f9fafb; border:1px solid #e5e7eb; border-radius:10px; padding:8px 10px; font-size:11px; }
        .stat b { font-size:12px; }

        h3.sec { margin:18px 0 8px; font-size:14px; color:#111; }

        table { width:100%; border-collapse: collapse; }
        th, td { border:1px solid #e5e7eb; padding:6px 8px; text-align:center; }
        thead th { background:#eef2ff; font-weight:bold; }
        tbody tr:nth-child(even) { background:#fafafa; }

        .badge { border-radius: 999px; padding:3px 8px; font-size:10px; display:inline-block; }
        .bg-success { background:#16a34a; color:#fff; }
        .bg-danger  { background:#dc2626; color:#fff; }
        .bg-warning { background:#f59e0b; color:#111; }
        .bg-secondary { background:#9ca3af; color:#fff; }

        .muted { color:#777; }
        .rtl { direction: rtl; text-align: right; }
        .page-break { page-break-after: always; }

        /* جلوگیری از شکستن ردیف‌ها وسط صفحه */
        tr { page-break-inside: avoid; }
        .group-head { background:#e5e7eb; font-weight:bold; text-align:right; }

        a { color:#0d6efd; text-decoration: none; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>

{{-- Header --}}
<header>
    <div class="hdr">
        <div class="title">گزارش MDR پروژه</div>
        <div style="font-size:13px; font-weight:bold">{{ $project->name ?? '-' }}</div>
    </div>
    <div class="meta">
        تاریخ تهیه: {{ $toFa(now()) }}
        — کد پروژه: {{ $project->code ?? '-' }}
    </div>
    <div class="chips">
        <span class="chip">جستجو: {{ $filters['search'] ?? '-' }}</span>
        <span class="chip">وضعیت: {{ $filters['status'] ?: 'همه' }}</span>
        <span class="chip">دیسپلین: {{ $filters['discipline_id'] ?: 'همه' }}</span>
        <span class="chip">وضعیت ترنسمیتال: {{ $filters['transmittal_status'] ?: 'همه' }}</span>
    </div>
    <div class="stats">
        <div class="stat">کل: <b>{{ $stats['total'] ?? 0 }}</b></div>
        <div class="stat">ارسال شده: <b>{{ $stats['sent'] ?? 0 }}</b></div>
        <div class="stat">تایید شده: <b>{{ $stats['approved'] ?? 0 }}</b></div>
        <div class="stat">رد شده: <b>{{ $stats['rejected'] ?? 0 }}</b></div>
    </div>
</header>

{{-- Footer with page numbers (dompdf) --}}
<footer>
    <div style="text-align:center;">مدیریت مدارک پروژه (MDR)</div>
    <script type="text/php">
        if (isset($pdf)) {
            $text = "صفحه {PAGE_NUM} از {PAGE_COUNT}";
            $size = 9;
            $font = $fontMetrics->get_font("DejaVu Sans", "normal");
            $pdf->page_text(520, 820, $text, $font, $size, array(0,0,0));
        }
    </script>
</footer>

<main>
    @php
        // گروه‌بندی بر اساس نام دیسپلین (یا "نامشخص")
        $grouped = $documents->groupBy(fn($d)=> optional($d->discipline)->name ?? 'نامشخص');
        $row = 1;
        $discIndex = 0;
        $discTotal = $grouped->count();
    @endphp

    @foreach($grouped as $discName => $rows)
        <h3 class="sec">دیسپلین: {{ $discName }}</h3>
        <table>
            <thead>
            <tr>
                <th>#</th>
                <th>شماره سند</th>
                <th class="rtl" style="text-align:right;">عنوان</th>
                <th>دسته‌بندی</th>
                <th>نوع</th>
                <th>نسخه</th>
                <th>وضعیت</th>
                <th>آخرین ترنسمیتال</th>
                <th>وضعیت ترنسمیتال</th>
                <th>تاریخ ارسال</th>
                <th>لینک فایل</th>
            </tr>
            </thead>
            <tbody>
            @foreach($rows as $doc)
                @php
                    $td = $lastTrans($doc);
                    $tr = $td?->transmittal;

                    $latestFile = $doc->documentFiles->first();
                    $fileUrl = $latestFile ? (Storage::disk('public')->url($latestFile->file_path)) : null;

                    $status = $doc->status ?: 'نامشخص';
                    $badgeClass =
                        $status === 'تایید شده' ? 'bg-success' :
                        ($status === 'رد شده' ? 'bg-danger' :
                        ($status === 'ارسال شده' ? 'bg-warning' : 'bg-secondary'));

                    $tStatus = $tr?->status ?: '-';
                    $tBadge =
                        $tStatus === 'تایید شده' ? 'bg-success' :
                        ($tStatus === 'رد شده' ? 'bg-danger' :
                        ($tStatus === 'ارسال شده' ? 'bg-warning' : 'bg-secondary'));

                    $sentAt = $tr?->sent_at ? $toFa($tr->sent_at) : '-';
                @endphp
                <tr>
                    <td>{{ $row++ }}</td>
                    <td>{{ $doc->document_number }}</td>
                    <td class="rtl" style="text-align:right;">{{ $doc->title }}</td>
                    <td>{{ $doc->category?->name ?? '-' }}</td>
                    <td>{{ $doc->document_type ?? '-' }}</td>
                    <td>{{ $doc->revision ?? '-' }}</td>
                    <td><span class="badge {{ $badgeClass }}">{{ $status }}</span></td>
                    <td>{{ $tr?->transmittal_number ?? '-' }}</td>
                    <td><span class="badge {{ $tBadge }}">{{ $tStatus }}</span></td>
                    <td>{{ $sentAt }}</td>
                    <td>
                        @if($fileUrl)
                            <a href="{{ $fileUrl }}">دانلود</a>
                        @else
                            <span class="muted">-</span>
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>

        @php $discIndex++; @endphp
        @if($discIndex < $discTotal)
            <div class="page-break"></div>
        @endif
    @endforeach
</main>

</body>
</html>
