<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <title>درخواست #{{ $req->id }}</title>
    <style>
        body { font-family: Tahoma, Arial, sans-serif; font-size: 12px; }
        .header { border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 20px; }
        .title { font-size: 16px; font-weight: bold; }
        .badge { padding: 2px 8px; border-radius: 4px; }
        .grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; }
        .cell { border: 1px solid #ddd; padding: 10px; }
        .label { font-weight: bold; color: #555; }
        .timeline { margin-top: 20px; }
        .step { margin-bottom: 10px; padding: 10px; border: 1px solid #eee; }
    </style>
</head>
<body>
<div class="header">
    <div class="title">درخواست #{{ $req->id }}</div>
    <div>ثبت‌کننده: {{ $req->user->name }} - {{ $fJ($req->created_at) }}</div>
</div>

<div class="grid">
    <div class="cell">
        <div class="label">نوع درخواست:</div>
        <div>{{ $req->type === 'leave' ? 'مرخصی' : 'ماموریت' }}</div>
    </div>
    <div class="cell">
        <div class="label">وضعیت:</div>
        <div>{{ $statusMap[$req->status]['label'] ?? $req->status }}</div>
    </div>
    <div class="cell">
        <div class="label">از:</div>
        <div>{{ $req->details ? $fJ($req->details->start_datetime) : '—' }}</div>
    </div>
    <div class="cell">
        <div class="label">تا:</div>
        <div>{{ $req->details ? $fJ($req->details->end_datetime) : '—' }}</div>
    </div>

    @if($req->type === 'leave')
        <div class="cell">
            <div class="label">نوع مرخصی:</div>
            <div>{{ $req->details? ($leaveMap[$req->details->leave_type] ?? $req->details->leave_type) : '—' }}</div>
        </div>
    @else
        <div class="cell">
            <div class="label">پروژه:</div>
            <div>{{ $project ? $project->name : '—' }}</div>
        </div>
        <div class="cell">
            <div class="label">شهر:</div>
            <div>{{ $req->details->mission_city ?? '—' }}</div>
        </div>
        <div class="cell">
            <div class="label">هدف:</div>
            <div>{{ $req->details->mission_purpose ?? '—' }}</div>
        </div>
    @endif
</div>

<div style="margin-top: 20px;">
    <div class="label">توضیحات:</div>
    <div>{{ $req->description ?: '—' }}</div>
</div>

<div class="timeline">
    <div class="label">زنجیره تأیید:</div>
    @foreach($req->approvals as $ap)
        <div class="step">
            <div><strong>#{{ $ap->step_order }} - {{ $ap->approver?->name ?? '—' }}</strong></div>
            <div>وضعیت: {{ $approvalLabel($ap->status) }}</div>
            @if($ap->decided_at)
                <div>تاریخ: {{ $fJ($ap->decided_at) }}</div>
            @endif
            @if(!empty($ap->comment))
                <div>یادداشت: {{ $ap->comment }}</div>
            @endif
        </div>
    @endforeach
</div>
</body>
</html>
