<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'سرامان') }}</title>

    <link rel="stylesheet" href="{{ url('panel/dist/css/style.min.css') }}">

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        /* 1. تعریف انیمیشن پس‌زمینه در CSS (چون Tailwind انیمیشن گرادینت را مستقیماً ندارد) */
        @keyframes subtleGradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* 2. تعریف کلاس Glass (با استفاده از Tailwind utility classes) */
        .glass-container {
            /* جایگزین: background: rgba(255, 255, 255, 0.95); */
            background-color: rgba(255, 255, 255, 0.95);

            /* جایگزین: box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1); */
            box-shadow: 0 15px 45px rgba(0, 0, 0, 0.15);

            /* جایگزین: backdrop-filter: blur(15px); */
            backdrop-filter: blur(18px);

            /* جایگزین: border-radius: 30px; */
            border-radius: 2rem; /* 32px */

            /* جایگزین: border: 1px solid rgba(0, 0, 0, 0.1); */
            border: 1px solid rgba(0, 0, 0, 0.08);

            /* جایگزین: transition: transform 0.3s ease; */
            transition: transform 0.4s ease-out, box-shadow 0.4s ease-out;
        }

        .glass-container:hover {
            /* جایگزین: transform: translateY(-8px); */
            transform: translateY(-10px) scale(1.005);
            box-shadow: 0 20px 55px rgba(0, 0, 0, 0.2);
        }

        /* 3. استایل‌دهی به بدنه */
        body {
            /* استفاده از Tailwind برای فونت و حداقل ارتفاع */
            font-family: 'PeydaWebNoEn', sans-serif;
            background-size: 200% 200%;
            animation: subtleGradient 10s ease infinite;
        }

        @keyframes fade-in {
            from {opacity: 0; transform: translateY(15px);}
            to {opacity: 1; transform: translateY(0);}
        }
    </style>
</head>
<body class="antialiased min-h-screen" style="background: linear-gradient(135deg, #f0f4f8 0%, #e0e7ee 100%);">

<main class="flex flex-col items-center justify-center w-full min-h-screen p-6 sm:p-8 animate-fade-in">

    <div class="mb-8 text-center">
{{--        <a href="/" class="text-3xl font-extrabold text-blue-700 hover:text-blue-800 transition-colors tracking-tight">--}}
{{--            {{ config('app.name', 'سرامان') }}--}}
{{--        </a>--}}
    </div>

    <div class="w-full max-w-4xl glass-container flex flex-col items-center p-8 sm:p-12 md:p-16">
        {{ $slot }}
    </div>

    <footer class="mt-8 text-center text-sm text-gray-500">
        © {{ date('Y') }} {{ config('app.name', 'سامانه یکپارچه هوشمند سرآمان') }}.
        <span class="block sm:inline-block sm:mr-1">
                تمامی حقوق محفوظ است.
            </span>
    </footer>
</main>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        document.querySelector('main').classList.add('animate-fade-in');
    });
</script>
</body>
</html>
