<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <title>{{ $title ?? 'Mersa - سیستم مدیریت شرکتی' }}</title>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="سیستم مدیریت یکپارچه شرکت مرسا">
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('panel/dist/css/style.min.css') }}">
{{--    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Vazirmatn:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">--}}

    @livewireStyles
    @stack('styles')

    <style>
        /* Updated CSS with Dark Mode and Modern Enhancements */
        :root {
            /* Light Mode Colors */
            --primary-blue: #2563eb;
            --primary-blue-light: #3b82f6;
            --primary-blue-dark: #1d4ed8;
            --secondary-slate: #475569;
            --accent-emerald: #059669;
            --accent-amber: #d97706;
            --danger-red: #dc2626;
            --warning-orange: #ea580c;
            --success-green: #16a34a;

            /* Neutral Palette */
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;

            /* Background & Layout */
            --body-bg: #f8fafc;
            --sidebar-bg: #ffffff;
            --sidebar-border: #e2e8f0;
            --content-bg: #ffffff;
            --card-bg: #ffffff;

            /* Text Colors */
            --text-primary: #0f172a;
            --text-secondary: #475569;
            --text-muted: #64748b;
            --text-light: #94a3b8;

            /* Dark Mode Colors */
            --dark-body-bg: #1e293b;
            --dark-sidebar-bg: #0f172a;
            --dark-content-bg: #1e293b;
            --dark-text-primary: #f8fafc;
            --dark-text-secondary: #94a3b8;

            /* Shadows & Effects */
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);

            /* Border Radius */
            --radius-sm: 0.375rem;
            --radius-md: 0.5rem;
            --radius-lg: 0.75rem;
            --radius-xl: 1rem;

            /* Transitions */
            --transition-fast: 150ms cubic-bezier(0.4, 0, 0.2, 1);
            --transition-normal: 200ms cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: 300ms cubic-bezier(0.4, 0, 0.2, 1);

            /* Spacing */
            --space-1: 0.25rem;
            --space-2: 0.5rem;
            --space-3: 0.75rem;
            --space-4: 1rem;
            --space-5: 1.25rem;
            --space-6: 1.5rem;
            --space-8: 2rem;
            --space-10: 2.5rem;
            --space-12: 3rem;
        }

        /* Dark Mode */
        @media (prefers-color-scheme: dark) {
            :root {
                --body-bg: var(--dark-body-bg);
                --sidebar-bg: var(--dark-sidebar-bg);
                --content-bg: var(--dark-content-bg);
                --text-primary: var(--dark-text-primary);
                --text-secondary: var(--dark-text-secondary);
            }
        }

        /* Rest of the CSS remains the same */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Vazirmatn', 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background-color: var(--body-bg);
            color: var(--text-primary);
            line-height: 1.6;
            font-weight: 400;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }

        ::-webkit-scrollbar-track {
            background: var(--gray-100);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--gray-300);
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--gray-400);
        }

        /* Layout Structure */
        .app-container {
            display: flex;
            min-height: 100vh;
            background-color: var(--body-bg);
        }

        /* Mobile Menu Button */
        .mobile-menu-toggle {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 1001;
            display: none;
            width: 48px;
            height: 48px;
            background: var(--content-bg);
            border: 1px solid var(--sidebar-border);
            border-radius: var(--radius-lg);
            align-items: center;
            justify-content: center;
            box-shadow: var(--shadow-md);
            cursor: pointer;
            transition: all var(--transition-normal);
        }

        .mobile-menu-toggle:hover {
            background: var(--gray-50);
            box-shadow: var(--shadow-lg);
        }

        .mobile-menu-toggle i {
            color: var(--text-secondary);
            font-size: 1.25rem;
        }

        /* Sidebar */
        .sidebar {
            width: 280px;
            background: var(--sidebar-bg);
            border-left: 1px solid var(--sidebar-border);
            display: flex;
            flex-direction: column;
            position: fixed;
            right: 0;
            top: 0;
            height: 100vh;
            z-index: 1000;
            transition: transform var(--transition-normal);
        }

        .sidebar-header {
            padding: var(--space-6) var(--space-6) var(--space-8);
            border-bottom: 1px solid var(--sidebar-border);
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--primary-blue-dark) 100%);
            position: relative;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="1" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }

        .logo-container {
            position: relative;
            z-index: 1;
            text-align: center;
        }

        .logo-container img {
            max-width: 160px;
            height: auto;
            filter: brightness(0) invert(1);
            transition: transform var(--transition-normal);
        }

        .logo-container:hover img {
            transform: scale(1.05);
        }

        .company-tagline {
            color: rgba(255, 255, 255, 0.8);
            font-size: 0.875rem;
            margin-top: var(--space-2);
            font-weight: 500;
            text-align: center;
        }

        /* Navigation */
        .sidebar-nav {
            flex: 1;
            padding: var(--space-6) 0;
            overflow-y: auto;
        }

        .nav-section {
            margin-bottom: var(--space-8);
        }

        .nav-section-title {
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--text-light);
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0 var(--space-6);
            margin-bottom: var(--space-4);
        }

        .nav-list {
            list-style: none;
        }

        .nav-item {
            margin: var(--space-1) var(--space-4);
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: var(--space-3) var(--space-4);
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: var(--radius-lg);
            font-weight: 500;
            font-size: 0.875rem;
            transition: all var(--transition-normal);
            position: relative;
        }

        .nav-link:hover {
            background: var(--gray-50);
            color: var(--primary-blue);
            transform: translateX(-2px);
        }

        .nav-link.active {
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--primary-blue-light) 100%);
            color: white;
            box-shadow: var(--shadow-md);
        }

        .nav-link.active::before {
            content: '';
            position: absolute;
            right: -1rem;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 24px;
            background: var(--primary-blue);
            border-radius: 2px;
        }

        .nav-icon {
            width: 20px;
            margin-left: var(--space-3);
            text-align: center;
            font-size: 1.125rem;
        }

        .nav-text {
            flex: 1;
        }

        .nav-badge {
            background: var(--accent-emerald);
            color: white;
            font-size: 0.75rem;
            font-weight: 600;
            padding: 0.125rem 0.5rem;
            border-radius: 9999px;
            min-width: 20px;
            text-align: center;
        }

        /* Sidebar Footer */
        .sidebar-footer {
            padding: var(--space-6);
            border-top: 1px solid var(--sidebar-border);
            background: var(--gray-50);
        }

        .user-profile {
            display: flex;
            align-items: center;
            padding: var(--space-4);
            background: white;
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-sm);
            margin-bottom: var(--space-4);
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--accent-emerald) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            margin-left: var(--space-3);
        }

        .user-info {
            flex: 1;
        }

        .user-name {
            font-weight: 600;
            color: var(--text-primary);
            font-size: 0.875rem;
        }

        .user-role {
            color: var(--text-muted);
            font-size: 0.75rem;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-right: 280px;
            min-height: 100vh;
            background: var(--body-bg);
            transition: margin-right var(--transition-normal);
        }

        .content-header {
            background: var(--content-bg);
            border-bottom: 1px solid var(--sidebar-border);
            padding: var(--space-6) var(--space-8);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .content-title {
            font-size: 1.875rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: var(--space-2);
        }

        .content-subtitle {
            color: var(--text-secondary);
            font-size: 1rem;
        }

        .content-body {
            padding: var(--space-8);
        }

        .content-container {
            background: var(--content-bg);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-sm);
            border: 1px solid var(--sidebar-border);
            padding: var(--space-8);
            min-height: calc(100vh - 200px);
        }

        /* Cards */
        .dashboard-card {
            background: var(--card-bg);
            border: 1px solid var(--sidebar-border);
            border-radius: var(--radius-lg);
            padding: var(--space-6);
            box-shadow: var(--shadow-sm);
            transition: all var(--transition-normal);
            height: 100%;
        }

        .dashboard-card:hover {
            box-shadow: var(--shadow-md);
            transform: translateY(-2px);
        }

        .card-header {
            display: flex;
            align-items: center;
            justify-content: between;
            margin-bottom: var(--space-4);
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .card-value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-blue);
            margin: var(--space-2) 0;
        }

        .card-description {
            color: var(--text-secondary);
            font-size: 0.875rem;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: var(--space-3) var(--space-6);
            font-size: 0.875rem;
            font-weight: 500;
            border-radius: var(--radius-md);
            border: none;
            cursor: pointer;
            text-decoration: none;
            transition: all var(--transition-normal);
            position: relative;
            overflow: hidden;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-blue) 0%, var(--primary-blue-light) 100%);
            color: white;
            box-shadow: var(--shadow-sm);
        }

        .btn-primary:hover {
            box-shadow: var(--shadow-md);
            transform: translateY(-1px);
        }

        .btn-danger {
            background: linear-gradient(135deg, var(--danger-red) 0%, #ef4444 100%);
            color: white;
            box-shadow: var(--shadow-sm);
        }

        .btn-danger:hover {
            box-shadow: var(--shadow-md);
            transform: translateY(-1px);
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--sidebar-border);
            color: var(--text-secondary);
        }

        .btn-outline:hover {
            background: var(--gray-50);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }

        .w-full {
            width: 100%;
        }

        /* Mobile Backdrop */
        .mobile-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all var(--transition-normal);
        }

        .mobile-backdrop.active {
            opacity: 1;
            visibility: visible;
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .main-content {
                margin-right: 0;
            }

            .sidebar {
                transform: translateX(100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .mobile-menu-toggle {
                display: flex;
            }

            .content-body {
                padding: var(--space-6);
            }

            .content-container {
                padding: var(--space-6);
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
            }

            .content-header {
                padding: var(--space-4) var(--space-6);
            }

            .content-title {
                font-size: 1.5rem;
            }

            .content-body {
                padding: var(--space-4);
            }

            .content-container {
                padding: var(--space-4);
                border-radius: var(--radius-lg);
            }

            .mobile-menu-toggle {
                top: var(--space-4);
                right: var(--space-4);
            }
        }

        /* Animations */
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .content-container {
            animation: slideIn 0.5s ease-out;
        }

        /* Focus States */
        .nav-link:focus,
        .btn:focus {
            outline: 2px solid var(--primary-blue);
            outline-offset: 2px;
        }

        /* Loading State */
        .loading {
            position: relative;
            pointer-events: none;
        }

        .loading::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
            animation: shimmer 1.5s infinite;
        }

        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        /* Utility Classes */
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        .mt-4 { margin-top: var(--space-4); }
        .mb-4 { margin-bottom: var(--space-4); }
        .p-4 { padding: var(--space-4); }
        .rounded { border-radius: var(--radius-md); }

        /* High Contrast Mode */
        @media (prefers-contrast: high) {
            :root {
                --sidebar-border: #000000;
                --text-secondary: #000000;
            }
        }

        /* Reduced Motion */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
    </style>
</head>
<body>
<div class="app-container">
    <!-- Mobile Menu Toggle -->
    <button class="mobile-menu-toggle" id="mobileMenuToggle" aria-label="باز کردن منو">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Mobile Backdrop -->
    <div class="mobile-backdrop" id="mobileBackdrop"></div>

    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <!-- Sidebar Header -->
        <div class="sidebar-header">
            <div class="logo-container">
                <img src="{{ asset('logo.png') }}" alt="شرکت مرسا">
                <div class="company-tagline">سیستم مدیریت یکپارچه</div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="sidebar-nav">
            <div class="nav-section">
                <div class="nav-section-title">داشبورد اصلی</div>
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                            <i class="fas fa-home nav-icon"></i>
                            <span class="nav-text">خانه</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <span class="nav-text">آمار و گزارشات</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="nav-section">
                <div class="nav-section-title">مدیریت پروژه</div>
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="{{ route('admin.projects') }}" class="nav-link {{ request()->routeIs('admin.projects*') ? 'active' : '' }}">
                            <i class="fas fa-briefcase nav-icon"></i>
                            <span class="nav-text">پروژه‌ها</span>
                            <span class="nav-badge">12</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a  wire:navigate href="{{ route('user.letter') }}" class="nav-link {{ request()->routeIs('user.letter*') ? 'active' : '' }}">
                            <i class="fas fa-envelope nav-icon"></i>
                            <span class="nav-text">مکاتبات</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="nav-section">
                <div class="nav-section-title">خرید و تدارکات</div>
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="{{ route('purchase.my-requests') }}" class="nav-link {{ request()->routeIs('purchase.my-requests*') ? 'active' : '' }}">
                            <i class="fas fa-shopping-cart nav-icon"></i>
                            <span class="nav-text">درخواست‌های خرید</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="nav-section">
                <div class="nav-section-title">ارتباطات</div>
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="{{ route('user.chats') }}" class="nav-link {{ request()->routeIs('user.chats*') ? 'active' : '' }}">
                            <i class="fas fa-comments nav-icon"></i>
                            <span class="nav-text">پیام‌ها</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('contact.contact_book') }}" class="nav-link {{ request()->routeIs('contact.contact_book*') ? 'active' : '' }}">
                            <i class="fas fa-address-book nav-icon"></i>
                            <span class="nav-text">دفترچه تماس</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('contact.call_reminders') }}" class="nav-link {{ request()->routeIs('contact.call_reminders*') ? 'active' : '' }}">
                            <i class="fas fa-bell nav-icon"></i>
                            <span class="nav-text">یادآوری‌ها</span>
                        </a>
                    </li>
                </ul>
            </div>

            <div class="nav-section">
                <div class="nav-section-title">محتوا</div>
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="{{ route('user.posts') }}" class="nav-link {{ request()->routeIs('user.posts*') ? 'active' : '' }}">
                            <i class="fas fa-blog nav-icon"></i>
                            <span class="nav-text">وبلاگ شرکتی</span>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Sidebar Footer -->
        <div class="sidebar-footer">
            <div class="user-profile">
                <div class="user-avatar">
                    {{ substr(auth()->user()->name ?? 'کاربر', 0, 1) }}
                </div>
                <div class="user-info">
                    <div class="user-name">{{ auth()->user()->name ?? 'کاربر سیستم' }}</div>
                    <div class="user-role">مدیر سیستم</div>
                </div>
            </div>

            <a href="{{ route('user.profile.edit') }}" class="btn btn-outline w-full mb-4">
                <i class="fas fa-user" style="margin-left: 8px;"></i>
                تنظیمات پروفایل
            </a>

            <form action="/logout" method="POST">
                @csrf
                <button type="submit" class="btn btn-danger w-full">
                    <i class="fas fa-sign-out-alt" style="margin-left: 8px;"></i>
                    خروج از سیستم
                </button>
            </form>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="main-content">
        <header class="content-header">
            <h1 class="content-title">{{ $title ?? 'داشبورد مدیریت' }}</h1>
            <p class="content-subtitle">مدیریت کامل فعالیت‌های شرکتی</p>
        </header>

        <div class="content-body">
            <div class="content-container">
                {{ $slot }}
            </div>
        </div>
    </main>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const sidebar = document.getElementById('sidebar');
        const mobileBackdrop = document.getElementById('mobileBackdrop');
        const menuIcon = mobileMenuToggle.querySelector('i');

        function toggleSidebar() {
            const isActive = sidebar.classList.contains('active');

            if (isActive) {
                closeSidebar();
            } else {
                openSidebar();
            }
        }

        function openSidebar() {
            sidebar.classList.add('active');
            mobileBackdrop.classList.add('active');
            menuIcon.className = 'fas fa-times';
            document.body.style.overflow = 'hidden';
        }

        function closeSidebar() {
            sidebar.classList.remove('active');
            mobileBackdrop.classList.remove('active');
            menuIcon.className = 'fas fa-bars';
            document.body.style.overflow = '';
        }

        mobileMenuToggle.addEventListener('click', toggleSidebar);
        mobileBackdrop.addEventListener('click', closeSidebar);
    });
</script>
</body>
</html>
