<div>
    <button type="button"
            class="btn btn-sm btn-outline-dark d-inline-flex align-items-center gap-1"
            wire:click="download"
        @disabled(!$this->hasAttachments || $this->busy)>

        <span wire:loading.remove wire:target="download">
            <i class="ti ti-folder-zip me-1"></i> دانلود همه (ZIP)
        </span>

        <span wire:loading wire:target="download">
            <i class="ti ti-loader animate-spin me-1"></i> آماده‌سازی…
        </span>
    </button>

    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('download:zip', ({ url }) => {
                window.location.href = url;
            });
            Livewire.on('toast', ({ type, message }) => {
                if (window.Swal) {
                    Swal.fire({
                        toast: true, position: 'top', icon: type,
                        title: message, timer: 2200, showConfirmButton: false
                    });
                } else {
                    alert(message);
                }
            });
        });
    </script>
</div>
