<div class="container-fluid py-4">
    <style>
        :root {
            /* MODERN CLEAN PALETTE */
            --primary: #3b82f6; /* Blue-500 */
            --primary-dark: #1e40af; /* Blue-800 */
            --accent: #10b981; /* Green for success/callouts */
            --bg-light: #f9fafb;
            --card-bg: #ffffff;
            --border-color: #e5e7eb;
            --text-dark: #1f2937;
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
        }

        /* Base styles */
        .modern-card {
            border-radius: 1rem !important;
            box-shadow: var(--shadow-md);
            border: 1px solid var(--border-color);
        }

        .modern-card .card-header {
            background-color: var(--primary);
            border-top-left-radius: 0.9rem !important;
            border-top-right-radius: 0.9rem !important;
            padding: 1.25rem;
        }

        /* Input/Form styling */
        .form-control-lg, .form-select-lg {
            border-radius: 0.65rem;
            padding: 0.75rem 1.25rem;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.25);
        }

        /* Attachment list */
        .file-preview-item {
            border-radius: 0.5rem;
            margin-bottom: 0.5rem;
            background-color: var(--bg-light);
            border: 1px solid var(--border-color);
            transition: all 0.2s;
        }
        .file-preview-item:hover {
            background-color: #eef2ff;
        }

        /* Target selection buttons */
        .target-button {
            border-radius: 9999px;
            font-weight: 600;
            transition: all 0.2s;
        }

        /* Custom user list */
        .user-list-group-item {
            transition: background-color 0.1s;
        }
        .user-list-group-item:hover {
            background-color: var(--primary-50);
        }

        /* Status bar for custom users */
        .selected-users-summary {
            background-color: #e0f7fa; /* Light cyan */
            color: #00838f;
            font-weight: 600;
            border-radius: 0.75rem;
            padding: 0.75rem 1rem;
            border: 1px solid #b2ebf2;
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">

            {{-- Flash Messages --}}
            @if(session()->has('success') || session()->has('error'))
                <div class="alert alert-{{ session()->has('success') ? 'success' : 'danger' }} d-flex align-items-center justify-content-between rounded-3 shadow-sm mb-4">
                    <div>
                        <i class="ti ti-{{ session()->has('success') ? 'check-circle' : 'alert-triangle' }} me-2"></i>
                        {{ session('success') ?? session('error') }}
                    </div>
                    <button class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="card modern-card">
                <div class="card-header text-white">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2">
                            <i class="ti ti-bell-filled fs-4"></i>
                            <h5 class="mb-0 fw-bold">ارسال اطلاعیه جدید</h5>
                        </div>
                        <span class="small opacity-75">سیستم اطلاعیه را به پنل و ایمیل مخاطبان ارسال می‌کند</span>
                    </div>
                </div>

                <div class="card-body p-4 p-md-5">
                    <form wire:submit.prevent="sendAnnouncement" enctype="multipart/form-data" novalidate>

                        {{-- Section 1: Content --}}
                        <h6 class="fw-bold mb-3 text-primary"><i class="ti ti-file-text me-2"></i> محتوا و عنوان</h6>
                        <hr class="mt-0 mb-4">

                        {{-- Title --}}
                        <div class="mb-4">
                            <label class="form-label fw-bold">عنوان <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-lg @error('title') is-invalid @enderror"
                                   wire:model.defer="title" maxlength="255" placeholder="عنوان جذاب و مختصر برای اطلاعیه...">
                            @error('title') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>

                        {{-- Content --}}
                        <div class="mb-4">
                            <label class="form-label fw-bold">متن اطلاعیه <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('content') is-invalid @enderror" rows="8"
                                      wire:model.defer="content" placeholder="شامل جزئیات، زمان، مکان و نکات مهم..."></textarea>
                            @error('content') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>

                        {{-- Files (multiple) --}}
                        <div class="mb-5">
                            <label class="form-label fw-bold d-flex align-items-center gap-2">
                                <i class="ti ti-paperclip"></i> فایل‌های پیوست (اختیاری)
                                <span class="badge text-bg-secondary fw-normal">حداکثر ۱۰ فایل، ۱۰MB</span>
                            </label>
                            <input type="file"
                                   class="form-control @error('files') is-invalid @enderror @error('files.*') is-invalid @enderror"
                                   wire:model="files" multiple
                                   accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png,.zip,.webp">

                            <div class="form-text mt-2">
                                <i class="ti ti-info-circle me-1"></i> فرمت‌های مجاز: PDF, DOC(X), XLS(X), JPG/PNG, ZIP, WEBP
                            </div>

                            <div class="small mt-2" wire:loading wire:target="files">
                                <i class="ti ti-loader animate-spin me-1"></i> **در حال بارگذاری فایل‌ها...**
                            </div>

                            @error('files') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                            @error('files.*') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror

                            @if(!empty($filePreviews))
                                <div class="mt-3">
                                    <h6 class="fw-bold mb-2">فایل‌های آماده پیوست:</h6>
                                    <div class="row g-2">
                                        @foreach($filePreviews as $i => $fp)
                                            <div class="col-12 col-md-6" wire:key="fp-{{ $i }}">
                                                <div class="file-preview-item p-3 d-flex align-items-center justify-content-between">
                                                    <div class="d-flex align-items-center gap-3 overflow-hidden">
                                                        @if($fp['is_image'])
                                                            <img src="{{ $fp['url'] }}" alt="preview" class="rounded flex-shrink-0" style="width:40px;height:40px;object-fit:cover">
                                                        @else
                                                            <i class="ti ti-file-text fs-4 text-primary flex-shrink-0"></i>
                                                        @endif
                                                        <div class="text-truncate">
                                                            <div class="fw-medium text-truncate">{{ $fp['name'] }}</div>
                                                            <small class="text-muted">{{ $fp['size_kb'] }} KB</small>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn btn-sm btn-outline-danger btn-icon-sm flex-shrink-0" wire:click="removeFile({{ $i }})" title="حذف فایل">
                                                        <i class="ti ti-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>

                        {{-- Section 2: Targeting --}}
                        <h6 class="fw-bold mb-3 text-primary"><i class="ti ti-target-arrow me-2"></i> انتخاب مخاطبین</h6>
                        <hr class="mt-0 mb-4">

                        {{-- Target type --}}
                        <div class="mb-4">
                            <label class="form-label fw-bold">ارسال به <span class="text-danger">*</span></label>
                            <div class="d-flex flex-wrap gap-3">
                                @foreach([
                                    ['all','همه کاربران سیستم', 'ti-users'],
                                    ['company','یک شرکت خاص', 'ti-building'],
                                    ['department','یک دپارتمان خاص', 'ti-sitemap'],
                                    ['custom','انتخاب دستی کاربران', 'ti-user-plus']
                                ] as [$val,$label,$icon])
                                    <button type="button"
                                            class="btn target-button {{ $target_type===$val ? 'btn-primary shadow' : 'btn-outline-secondary' }} px-4"
                                            wire:click="$set('target_type','{{ $val }}')">
                                        <i class="ti {{ $icon }} me-2"></i> {{ $label }}
                                    </button>
                                @endforeach
                            </div>
                            @error('target_type') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                        </div>

                        {{-- Filters for Company/Department --}}
                        @if($target_type === 'company' || $target_type === 'department')
                            <div class="mb-4 border border-info rounded-4 p-4 bg-light">
                                <p class="fw-bold text-info"><i class="ti ti-filter me-2"></i> فیلتر شرکت/دپارتمان</p>
                                <div class="row g-3">

                                    {{-- شرکت --}}
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">شرکت <span class="text-danger">*</span></label>
                                        <select class="form-select form-select-lg @error('company_id') is-invalid @enderror"
                                                wire:model.live.number="company_id">
                                            <option value="">انتخاب شرکت...</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('company_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                    </div>

                                    {{-- دپارتمان --}}
                                    @if($target_type === 'department')
                                        {{-- کلید پویا برای رندر دوباره کامل بلاک دپارتمان --}}
                                        <div class="col-md-6" wire:key="dep-{{ $depsVersion }}-{{ (int)$company_id }}">
                                            <label class="form-label fw-medium">دپارتمان <span class="text-danger">*</span></label>

                                            <div wire:loading.class="opacity-50" wire:target="company_id">
                                                <select class="form-select form-select-lg @error('department_id') is-invalid @enderror"
                                                        wire:model.number="department_id"
                                                    {{ $company_id ? '' : 'disabled' }}>
                                                    @if(!$company_id)
                                                        <option value="">ابتدا شرکت را انتخاب کنید</option>
                                                    @elseif(empty($departmentsOptions))
                                                        <option value="">دپارتمانی برای این شرکت یافت نشد</option>
                                                    @else
                                                        <option value="">انتخاب دپارتمان...</option>
                                                        @foreach($departmentsOptions as $dep)
                                                            <option value="{{ $dep['id'] }}">{{ $dep['name'] }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>

                                            @error('department_id') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                        </div>
                                    @endif

                                </div>
                            </div>
                        @endif

                        {{-- Custom users Selection --}}
                        @if($target_type === 'custom')
                            <div class="mb-4 border border-secondary rounded-4 p-4 bg-light">
                                <div class="d-flex flex-wrap gap-2 align-items-center justify-content-between mb-3">
                                    <div class="fw-bold text-dark"><i class="ti ti-list-check me-2"></i> انتخاب دستی کاربران</div>
                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-sm btn-outline-primary" wire:click="selectAllOnPage" wire:loading.attr="disabled">
                                            <i class="ti ti-list-details me-1"></i> انتخاب همه در این صفحه
                                        </button>
                                        <button type="button" class="btn btn-sm btn-outline-danger" wire:click="clearAllUsers" wire:loading.attr="disabled">
                                            <i class="ti ti-square-off me-1"></i> پاک کردن همه ({{ count($selected_users) }})
                                        </button>
                                    </div>
                                </div>

                                {{-- Filters and Search for Custom Users --}}
                                <div class="row g-3 mb-4">
                                    <div class="col-md-6">
                                        <input type="text" class="form-control"
                                               placeholder="جستجو با نام یا ایمیل..." wire:model.debounce.350ms="search_users">
                                    </div>
                                    <div class="col-md-6">
                                        <select class="form-select" wire:model.live.number="company_id">
                                            <option value="">فیلتر شرکت...</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    {{-- دپارتمان فیلتر --}}
                                    <div class="col-md-6" wire:key="dep-filter-{{ $depsVersion }}-{{ (int)$company_id }}">
                                        <div wire:loading.class="opacity-50" wire:target="company_id">
                                            <select class="form-select" wire:model.live.number="department_id" {{ $company_id ? '' : 'disabled' }}>
                                                @if(!$company_id)
                                                    <option value="">فیلتر دپارتمان (شرکت را انتخاب کنید)</option>
                                                @elseif(empty($departmentsOptions))
                                                    <option value="">دپارتمانی برای این شرکت یافت نشد</option>
                                                @else
                                                    <option value="">فیلتر دپارتمان...</option>
                                                    @foreach($departmentsOptions as $dep)
                                                        <option value="{{ $dep['id'] }}">{{ $dep['name'] }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <select class="form-select" wire:model.live="perPage">
                                            <option value="20">۲۰ کاربر در صفحه</option>
                                            <option value="50">۵۰ کاربر در صفحه</option>
                                        </select>
                                    </div>
                                </div>

                                @php $paginated = $users; @endphp

                                <div class="mb-3">
                                    @if(count($selected_users))
                                        <div class="selected-users-summary">
                                            <i class="ti ti-user-check me-2"></i> **{{ count($selected_users) }}** کاربر انتخاب شده است.
                                            @error('selected_users') <span class="text-danger d-block mt-1">{{ $message }}</span> @enderror
                                        </div>
                                    @else
                                        @error('selected_users') <div class="text-danger fw-bold mt-2">{{ $message }}</div> @enderror
                                    @endif
                                </div>


                                <div class="border rounded-3 overflow-hidden">
                                    <div wire:loading.flex wire:target="search_users, perPage, company_id, department_id" class="text-muted justify-content-center py-4">
                                        <i class="ti ti-loader animate-spin me-1"></i> در حال بارگذاری کاربران...
                                    </div>

                                    @if(!$paginated->count())
                                        <div class="text-center text-muted py-5 bg-white">
                                            <i class="ti ti-search-off fs-1 d-block mb-2"></i>
                                            کاربری با فیلترهای انتخابی پیدا نشد.
                                        </div>
                                    @else
                                        <div class="list-group list-group-flush">
                                            @foreach($paginated as $user)
                                                <label class="list-group-item d-flex align-items-center justify-content-between user-list-group-item" wire:key="user-{{ $user->id }}">
                                                    <div class="d-flex align-items-center gap-3">
                                                        <input class="form-check-input mt-0" type="checkbox"
                                                               wire:click="toggleUserSelection({{ $user->id }})"
                                                            @checked(in_array($user->id, $selected_users,true))>
                                                        <div>
                                                            <div class="fw-medium">{{ $user->name }}</div>
                                                            <small class="text-muted d-block">{{ $user->email }}</small>
                                                            <div class="mt-1 d-flex flex-wrap gap-2">
                                                                @if($user->company)
                                                                    <span class="badge bg-light text-secondary"><i class="ti ti-building me-1"></i>{{ $user->company->name }}</span>
                                                                @endif
                                                                @if($user->department)
                                                                    <span class="badge bg-light text-secondary"><i class="ti ti-sitemap me-1"></i>{{ $user->department->name }}</span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <span class="badge bg-secondary opacity-75 d-none d-md-inline">ID: {{ $user->id }}</span>
                                                </label>
                                            @endforeach
                                        </div>

                                        <div class="p-3 bg-white border-top">
                                            {{ $paginated->onEachSide(1)->links() }}
                                        </div>
                                    @endif
                                </div>

                            </div>
                        @endif

                        {{-- Sticky actions --}}
                        <div class="position-sticky bottom-0 bg-white pt-4 mt-4 border-top" style="z-index:100; margin-left: -2.5rem; margin-right: -2.5rem; padding-left: 2.5rem; padding-right: 2.5rem;">
                            <div class="d-flex gap-3 justify-content-end">
                                <button type="button" wire:click="$refresh" class="btn btn-outline-secondary btn-lg" wire:loading.attr="disabled">
                                    <i class="ti ti-refresh me-1"></i> ریست فرم
                                </button>
                                <button type="submit" class="btn btn-primary btn-lg px-5 shadow" wire:loading.attr="disabled">
                                    <span wire:loading.remove><i class="ti ti-send me-1"></i> **ارسال اطلاعیه**</span>
                                    <span wire:loading><i class="ti ti-loader animate-spin me-1"></i> در حال ارسال...</span>
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
        <script>
            // Script is identical to the original, ensuring the Swal confirmation works seamlessly
            async function safeConfirm({title, text}) {
                if (window.Swal) {
                    const res = await Swal.fire({
                        title: title || 'تایید',
                        text: text || 'مطمئن هستید؟',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'بله',
                        cancelButtonText: 'لغو',
                        reverseButtons: true,
                        buttonsStyling: false,
                        customClass: { confirmButton: 'btn btn-primary', cancelButton: 'btn btn-outline-secondary' }
                    });
                    return res.isConfirmed;
                }
                return window.confirm(text || 'Are you sure?');
            }

            document.addEventListener('livewire:init', () => {
                Livewire.on('confirm:send', async (data) => {
                    const ok = await safeConfirm({ title: data.title, text: data.text });
                    if (ok) Livewire.dispatch('confirmedSend');
                });
            });
        </script>
    @endpush
</div>
