<div>
    <div class="container-fluid px-3 px-md-4 py-3 py-md-4">
        @if (session('message'))
            <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
                <i class="fas fa-check-circle fs-4 me-3 text-success"></i>
                <div class="flex-grow-1">
                    <strong class="d-block">عملیات موفقیت‌آمیز</strong>
                    {{ session('message') }}
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <!-- Header -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
            <div>
                <h4 class="fw-bold m-0 text-primary">
                    <i class="fas fa-gavel me-2"></i>
                    مدیریت قوانین تأیید حضور و غیاب
                </h4>
                <p class="text-muted mb-0 mt-1 small">قوانین تأیید را بر اساس شرکت، دپارتمان و نوع درخواست تعریف کنید.</p>
            </div>
            <button class="btn btn-primary btn-lg px-4" wire:click="openCreateModal">
                <i class="fas fa-plus me-2"></i> ایجاد قانون جدید
            </button>
        </div>

        <!-- Filters -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white border-0">
                <h6 class="m-0 fw-bold"><i class="fas fa-filter me-2 text-muted"></i> فیلترها</h6>
            </div>
            <div class="card-body p-3 p-md-4">
                <div class="row g-3">
                    <div class="col-12 col-md-6 col-lg-4">
                        <label class="form-label fw-semibold small text-uppercase text-muted">جستجو در نام قانون</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0"><i class="fas fa-search text-muted"></i></span>
                            <input type="text" class="form-control border-start-0" placeholder="مثلاً: تأیید مرخصی توسط مدیر..." wire:model.live.debounce.300ms="search">
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="form-label fw-semibold small text-uppercase text-muted">نوع درخواست</label>
                        <select class="form-select" wire:model.live="filterType">
                            <option value="">همه انواع</option>
                            <option value="leave">مرخصی</option>
                            <option value="mission">ماموریت</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Rules Table -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                        <tr>
                            <th scope="col" class="fw-bold text-nowrap">نام قانون</th>
                            <th scope="col" class="fw-bold text-nowrap">شرکت</th>
                            <th scope="col" class="fw-bold text-nowrap">نوع</th>
                            <th scope="col" class="fw-bold text-nowrap">مرحله</th>
                            <th scope="col" class="fw-bold text-nowrap">تأییدکنندگان</th>
                            <th scope="col" class="fw-bold text-nowrap">وضعیت</th>
                            <th scope="col" class="fw-bold text-nowrap text-center">اقدامات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse ($rules as $rule)
                            <tr>
                                <td class="fw-semibold text-break">{{ $rule->name }}</td>
                                <td>
                                    @if($rule->company)
                                        <span class="badge bg-secondary">{{ $rule->company->name }}</span>
                                    @else
                                        <span class="text-muted">همه شرکت‌ها</span>
                                    @endif
                                </td>
                                <td>
                                    @if($rule->type === 'leave')
                                        <span class="badge bg-info">مرخصی</span>
                                        @if($rule->leave_type)
                                            <span class="badge bg-light text-dark ms-1">({{ $rule->leave_type }})</span>
                                        @endif
                                    @elseif($rule->type === 'mission')
                                        <span class="badge bg-warning">ماموریت</span>
                                        @if($rule->project)
                                            <div class="small text-muted mt-1">پروژه: {{ $rule->project->name }}</div>
                                        @endif
                                    @else
                                        <span class="badge bg-secondary">همه</span>
                                    @endif
                                </td>
                                <td class="fw-bold text-primary text-nowrap">#{{ $rule->step_order }}</td>
                                <td>
                                    @php
                                        $approvers = \App\Models\User::whereIn('id', $rule->approvers)->limit(3)->get();
                                        $count = count($rule->approvers);
                                    @endphp
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($approvers as $user)
                                            <span class="badge bg-primary bg-gradient text-white">{{ $user->name }}</span>
                                        @endforeach
                                        @if($count > 3)
                                            <span class="badge bg-secondary">+{{ $count - 3 }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $rule->is_active ? 'success' : 'danger' }} text-white">
                                        {{ $rule->is_active ? 'فعال' : 'غیرفعال' }}
                                    </span>
                                </td>
                                <td class="text-center text-nowrap">
                                    <button class="btn btn-sm btn-outline-primary me-1" wire:click="openEditModal({{ $rule->id }})" title="ویرایش">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger" wire:click="deleteRule({{ $rule->id }})" title="حذف" onclick="return confirm('⚠️ آیا از حذف این قانون اطمینان دارید؟')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-2x mb-2 opacity-50"></i>
                                        <div class="fw-semibold">هیچ قانونی یافت نشد.</div>
                                        <button class="btn btn-link mt-2" wire:click="openCreateModal">
                                            <i class="fas fa-plus me-1"></i> ایجاد قانون اول
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-top-0 pt-3">
                <div class="d-flex justify-content-center">
                    {{ $rules->links() }}
                </div>
            </div>
        </div>

        <!-- Modal: Create/Edit Rule -->
        @if($showCreateModal || $showEditModal)
            <div class="modal fade show d-block" tabindex="-1" role="dialog" style="background-color: rgba(0,0,0,0.5); z-index: 1055;">
                <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                    <div class="modal-content rounded-4 shadow-lg border-0">
                        <div class="modal-header bg-gradient-primary text-white rounded-top-4">
                            <h5 class="modal-title">
                                <i class="fas fa-gavel me-2"></i>
                                {{ $editingRuleId ? 'ویرایش قانون' : 'ایجاد قانون جدید' }}
                            </h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeModals"></button>
                        </div>
                        <div class="modal-body p-4">
                            <form>
                                <!-- Rule Name -->
                                <div class="mb-4">
                                    <label class="form-label fw-bold">نام قانون <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-lg" wire:model="name" placeholder="مثلاً: تأیید مرخصی‌های استحقاقی توسط مدیر دپارتمان">
                                    @error('name') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                                <div class="row mb-4 g-3">
                                    <!-- Request Type -->
                                    <div class="col-12 col-md-4">
                                        <label class="form-label fw-bold">نوع درخواست</label>
                                        <select class="form-select form-select-lg" wire:model="type">
                                            <option value="">همه انواع</option>
                                            <option value="leave">مرخصی</option>
                                            <option value="mission">ماموریت</option>
                                        </select>
                                    </div>

                                    <!-- Step Order -->
                                    <div class="col-12 col-md-4">
                                        <label class="form-label fw-bold">مرحله تأیید <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control form-control-lg" wire:model="step_order" min="1" placeholder="1">
                                        @error('step_order') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                    </div>

                                    <!-- Company Filter -->
                                    <div class="col-12 col-md-4">
                                        <label class="form-label fw-bold">شرکت (اختیاری)</label>
                                        <select class="form-select form-select-lg" wire:model.live="company_id">
                                            <option value="">همه شرکت‌ها</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}">{{ $company->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <!-- Conditional Fields -->
                                @if($type === 'leave')
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">نوع مرخصی</label>
                                        <select class="form-select form-select-lg" wire:model="leave_type">
                                            <option value="">همه انواع مرخصی</option>
                                            <option value="annual">استحقاقی</option>
                                            <option value="sick">استعلاجی</option>
                                            <option value="unpaid">بدون حقوق</option>
                                            <option value="overtime_comp">جبرانی</option>
                                            <option value="other">سایر</option>
                                        </select>
                                    </div>
                                @endif

                                @if($type === 'mission')
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">پروژه (اختیاری)</label>
                                        <select class="form-select form-select-lg" wire:model="project_id">
                                            <option value="">همه پروژه‌ها</option>
                                            @foreach($projects as $project)
                                                <option value="{{ $project->id }}">{{ $project->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif

                                <!-- Department Filter -->
                                <div class="mb-4">
                                    <label class="form-label fw-bold">دپارتمان (اختیاری)</label>
                                    <select class="form-select form-select-lg" wire:model.live="department_id">
                                        <option value="">همه دپارتمان‌ها</option>
                                        @foreach($filteredDepartments as $dept)
                                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Duration Filters -->
                                <div class="row mb-4 g-3">
                                    <div class="col-12 col-md-6">
                                        <label class="form-label fw-bold">حداقل مدت (ساعت - اختیاری)</label>
                                        <input type="number" class="form-control form-control-lg" wire:model="min_duration_hours" min="0" placeholder="0">
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label fw-bold">حداکثر مدت (ساعت - اختیاری)</label>
                                        <input type="number" class="form-control form-control-lg" wire:model="max_duration_hours" min="0" placeholder="24">
                                    </div>
                                </div>

                                <!-- Approvers Selection -->
                                <div class="mb-4">
                                    <label class="form-label fw-bold">تأییدکنندگان <span class="text-danger">*</span></label>
                                    <div class="mb-3">
                                        <input type="text" class="form-control form-control-lg" placeholder="جستجوی کاربر بر اساس نام یا ایمیل..." wire:model.live.debounce.300ms="userSearch">
                                        <div class="form-text text-muted">
                                            @if($company_id && $department_id)
                                                کاربران دپارتمان «{{ \App\Models\Department::find($department_id)?->name ?? '—' }}» در شرکت «{{ \App\Models\Company::find($company_id)?->name ?? '—' }}»
                                            @elseif($company_id)
                                                کاربران شرکت «{{ \App\Models\Company::find($company_id)?->name ?? '—' }}»
                                            @else
                                                تمام کاربران سیستم
                                            @endif
                                        </div>
                                    </div>

                                    <!-- User List -->
                                    <div class="border rounded-3 p-3 mb-3" style="max-height: 250px; overflow-y: auto; background: #f8f9fa;">
                                        @if(count($userOptions))
                                            <div class="list-group list-group-flush">
                                                @foreach($userOptions as $user)
                                                    <div class="list-group-item list-group-item-action d-flex align-items-center">
                                                        <input class="form-check-input me-3" type="checkbox"
                                                               id="user_{{ $user['id'] }}"
                                                               wire:click="toggleUserSelection({{ $user['id'] }})"
                                                            {{ in_array($user['id'], $selectedApprovers) ? 'checked' : '' }}>
                                                        <label class="form-check-label flex-grow-1" for="user_{{ $user['id'] }}">
                                                            <div class="d-flex align-items-center">
                                                                <div class="avatar-xs rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3">
                                                                    {{ strtoupper(mb_substr($user['name'] ?? '', 0, 1)) }}
                                                                </div>
                                                                <div class="flex-grow-1">
                                                                    <div class="fw-semibold">{{ $user['name'] ?? '—' }}</div>
                                                                    <div class="small text-muted">{{ $user['email'] ?? '—' }}</div>
                                                                    @if(isset($user['department_id']) && $user['department_id'])
                                                                        <div class="small text-muted">
                                                                            {{ \App\Models\Department::find($user['department_id'])?->name ?? '—' }}
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-center text-muted py-4">
                                                <i class="fas fa-users-slash fa-2x mb-2 opacity-50"></i>
                                                <div>کاربری یافت نشد.</div>
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Selected Approvers -->
                                    <div class="bg-light border rounded-3 p-3">
                                        <strong class="d-block mb-2">تأییدکنندگان انتخاب شده ({{ count($selectedApprovers) }} نفر):</strong>
                                        @if(count($selectedApprovers))
                                            <div class="d-flex flex-wrap gap-2">
                                                @php
                                                    $selectedUsers = \App\Models\User::whereIn('id', $selectedApprovers)->get();
                                                @endphp
                                                @foreach($selectedUsers as $user)
                                                    <span class="badge bg-primary bg-gradient text-white px-3 py-2 d-flex align-items-center">
                                                    {{ $user->name }}
                                                    <button type="button" class="btn-close btn-close-white ms-2 mb-1" wire:click="toggleUserSelection({{ $user->id }})"></button>
                                                </span>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="text-muted">هیچ کاربری انتخاب نشده است.</div>
                                        @endif
                                    </div>

                                    @error('selectedApprovers') <div class="text-danger small mt-2">{{ $message }}</div> @enderror
                                </div>

                                <!-- Active Toggle -->
                                <div class="form-check form-switch mb-4">
                                    <input class="form-check-input" type="checkbox" id="isActive" wire:model="is_active">
                                    <label class="form-check-label fw-bold" for="isActive">
                                        <i class="fas fa-toggle-{{ $is_active ? 'on text-success' : 'off text-danger' }} me-2"></i>
                                        وضعیت فعال
                                    </label>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer border-top-0 pt-0">
                            <button type="button" class="btn btn-lg btn-outline-secondary px-4" wire:click="closeModals">
                                <i class="fas fa-times me-1"></i> انصراف
                            </button>
                            <button type="button" class="btn btn-lg btn-primary px-4" wire:click="saveRule" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas fa-save me-1"></i> {{ $editingRuleId ? 'به‌روزرسانی' : 'ذخیره' }} قانون
                            </span>
                                <span wire:loading>
                                <i class="fas fa-spinner fa-spin me-1"></i> در حال {{ $editingRuleId ? 'به‌روزرسانی' : 'ذخیره' }}...
                            </span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    @push('scripts')
        <script>
            document.addEventListener('livewire:initialized', () => {
                // اسکرول به بالا هنگام باز شدن مودال
                Livewire.on('openCreateModal', () => {
                    setTimeout(() => window.scrollTo({ top: 0, behavior: 'smooth' }), 100);
                });
            });
        </script>
    @endpush

    <style>
        .avatar-xs {
            width: 2.2rem;
            height: 2.2rem;
            font-size: .875rem;
        }
        .bg-gradient-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .bg-gradient {
            background-image: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        /* موبایل فرندلی */
        @media (max-width: 768px) {
            .modal-xl {
                max-width: 95%;
            }
            .table th,
            .table td {
                font-size: 0.875rem;
                padding: 0.5rem;
            }
            .btn-lg {
                padding: 0.5rem 1rem;
                font-size: 0.875rem;
            }
            /* بهبود نمایش در موبایل */
            .d-flex.flex-wrap {
                flex-wrap: wrap !important;
            }
            .gap-3 {
                gap: 0.75rem !important;
            }
            .p-4 {
                padding: 1rem !important;
            }
            .form-control-lg {
                padding: 0.5rem 0.75rem;
                font-size: 0.875rem;
            }
            .modal-dialog {
                margin: 0.5rem;
            }
            .card {
                margin-bottom: 1rem;
            }
        }
        /* استایل‌های اضافی برای بهبود UI */
        .list-group-item {
            border: none;
            padding: 0.5rem 1rem;
        }
        .form-control-lg {
            padding: 0.5rem 1rem;
            font-size: 1rem;
        }
        .badge {
            font-weight: 500;
        }
        /* ظرافت کارت‌ها */
        .card { --bs-card-border-radius: 1rem; }
        /* تایم‌لاین مراحل */
        .timeline-dot{ width:10px; height:10px; border-radius:50%; margin-top:.45rem; }
        /* مدرن‌سازی UI */
        .badge.rounded-pill {
            border-radius: 50rem !important;
            font-weight: 600;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd8 0%, #6a4291 100%);
        }
    </style>

</div>
