<div class="container-fluid px-3 px-md-4 py-3 py-md-4">
    {{-- پیام‌ها --}}
    @if (session('ok'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
            <i class="fas fa-check-circle fs-4 me-3 text-success"></i>
            <div class="flex-grow-1">
                <strong class="d-block">عملیات موفقیت‌آمیز</strong>
                {{ session('ok') }}
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- سرآیند + اکشن --}}
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h4 class="fw-bold m-0 text-primary">
                <i class="fas fa-clipboard-list me-2"></i>
                درخواست‌های من
            </h4>
            <p class="text-muted mb-0 mt-1 small">لیست تمام درخواست‌های ثبت شده توسط شما</p>
        </div>
        <div class="d-flex gap-2">
            <button class="btn btn-outline-secondary btn-sm" wire:click="exportCsv">
                <i class="fas fa-file-export me-1"></i> خروجی CSV
            </button>
            <a href="{{ route('admin.attendence.requests.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus-circle me-1"></i> درخواست جدید
            </a>
        </div>
    </div>

    {{-- کارت‌های آمار --}}
    <div class="row g-3 mb-4">
        <div class="col-sm-6 col-lg-3">
            <div class="card shadow-sm border-0 rounded-4 h-100">
                <div class="card-body d-flex align-items-center gap-3">
                    <div class="rounded-3 p-3 bg-light text-primary">
                        <i class="fas fa-layer-group fs-4"></i>
                    </div>
                    <div>
                        <div class="fs-4 fw-bold text-primary">{{ $total }}</div>
                        <div class="text-muted small">کل درخواست‌ها</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3">
            <div class="card shadow-sm border-0 rounded-4 h-100">
                <div class="card-body d-flex align-items-center gap-3">
                    <div class="rounded-3 p-3 bg-light text-warning">
                        <i class="fas fa-hourglass-half fs-4"></i>
                    </div>
                    <div>
                        <div class="fs-4 fw-bold text-warning">{{ $pending }}</div>
                        <div class="text-muted small">در انتظار تأیید</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3">
            <div class="card shadow-sm border-0 rounded-4 h-100">
                <div class="card-body d-flex align-items-center gap-3">
                    <div class="rounded-3 p-3 bg-light text-success">
                        <i class="fas fa-check-circle fs-4"></i>
                    </div>
                    <div>
                        <div class="fs-4 fw-bold text-success">{{ $approved }}</div>
                        <div class="text-muted small">تأیید شده</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3">
            <div class="card shadow-sm border-0 rounded-4 h-100">
                <div class="card-body d-flex align-items-center gap-3">
                    <div class="rounded-3 p-3 bg-light text-danger">
                        <i class="fas fa-times-circle fs-4"></i>
                    </div>
                    <div>
                        <div class="fs-4 fw-bold text-danger">{{ $rejected }}</div>
                        <div class="text-muted small">رد شده</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- فیلترها (استیکی) --}}
    <div class="card border-0 shadow-sm rounded-4 mb-4 position-sticky top-0 z-2" style="backdrop-filter: blur(2px);">
        <div class="card-header bg-white border-0">
            <h6 class="m-0 fw-bold"><i class="fas fa-filter me-2 text-muted"></i> فیلترها</h6>
        </div>
        <div class="card-body p-3 p-md-4">
            <div class="d-flex flex-wrap gap-3 align-items-end">
                <div class="flex-grow-1" style="min-width: 240px;">
                    <label class="form-label small text-uppercase text-muted mb-1">جستجو</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" placeholder="عنوان، توضیحات، شهر/هدف یا #شماره"
                               wire:model.live.debounce.500ms="search">
                        <span class="input-group-text bg-light"><i class="fas fa-search text-muted"></i></span>
                    </div>
                    <div class="form-text text-muted small">
                        میانبر: <kbd class="bg-light text-dark">/</kbd> برای فوکوس روی جستجو
                    </div>
                </div>

                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">نوع</label>
                    <select class="form-select form-select-sm" wire:model.live="type" style="min-width: 140px;">
                        <option value="">همه‌ی انواع</option>
                        <option value="leave">مرخصی</option>
                        <option value="mission">ماموریت</option>
                    </select>
                </div>

                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">وضعیت</label>
                    <select class="form-select form-select-sm" wire:model.live="status" style="min-width: 160px;">
                        <option value="">همه‌ی وضعیت‌ها</option>
                        <option value="{{ \App\Models\LeaveMissionRequest::ST_DRAFT }}">پیش‌نویس</option>
                        <option value="{{ \App\Models\LeaveMissionRequest::ST_PENDING }}">در انتظار تایید</option>
                        <option value="{{ \App\Models\LeaveMissionRequest::ST_APPROVED }}">تایید شده</option>
                        <option value="{{ \App\Models\LeaveMissionRequest::ST_REJECTED }}">رد شده</option>
                        @if(defined('\App\Models\LeaveMissionRequest::ST_CANCELED'))
                            <option value="{{ \App\Models\LeaveMissionRequest::ST_CANCELED }}">لغو شده</option>
                        @endif
                    </select>
                </div>

                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">از تاریخ (شمسی)</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" id="fromJ" placeholder="YYYY/MM/DD HH:mm"
                               wire:model.live.debounce.400ms="from_j">
                        <span class="input-group-text bg-light"><i class="fas fa-calendar-alt text-muted"></i></span>
                    </div>
                </div>

                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">تا تاریخ (شمسی)</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" id="toJ" placeholder="YYYY/MM/DD HH:mm"
                               wire:model.live.debounce.400ms="to_j">
                        <span class="input-group-text bg-light"><i class="fas fa-calendar-check text-muted"></i></span>
                    </div>
                </div>

                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">نمایش</label>
                    <select class="form-select form-select-sm" wire:model.live="perPage">
                        <option>10</option><option>15</option><option>25</option><option>50</option>
                    </select>
                </div>

                <div class="ms-auto d-flex gap-2">
                    <div class="btn-group btn-group-sm">
                        <button class="btn btn-outline-secondary" wire:click="presetRange('today')">امروز</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('week')">این هفته</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('month')">این ماه</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('clear')" title="پاک‌سازی تاریخ">
                            <i class="fas fa-eraser"></i>
                        </button>
                    </div>
                    <button class="btn btn-outline-dark btn-sm" wire:click="resetFilters">
                        <i class="fas fa-undo me-1"></i> پاک‌سازی
                    </button>
                </div>
            </div>

            {{-- تب‌های سریع وضعیت --}}
            <div class="mt-4 d-flex flex-wrap gap-2">
                @php
                    $pill = 'btn btn-sm '.($status===''||is_null($status)?'btn-dark':'btn-outline-dark');
                @endphp
                <button class="{{ $pill }}" wire:click="$set('status','')">
                    <i class="fas fa-list-ul me-1"></i> همه
                </button>
                <button class="btn btn-sm {{ $status===\App\Models\LeaveMissionRequest::ST_DRAFT?'btn-warning':'btn-outline-warning' }}" wire:click="$set('status','{{ \App\Models\LeaveMissionRequest::ST_DRAFT }}')">
                    پیش‌نویس <span class="badge bg-light text-dark ms-1">{{ $draft }}</span>
                </button>
                <button class="btn btn-sm {{ $status===\App\Models\LeaveMissionRequest::ST_PENDING?'btn-info':'btn-outline-info' }}" wire:click="$set('status','{{ \App\Models\LeaveMissionRequest::ST_PENDING }}')">
                    در انتظار <span class="badge bg-light text-dark ms-1">{{ $pending }}</span>
                </button>
                <button class="btn btn-sm {{ $status===\App\Models\LeaveMissionRequest::ST_APPROVED?'btn-success':'btn-outline-success' }}" wire:click="$set('status','{{ \App\Models\LeaveMissionRequest::ST_APPROVED }}')">
                    تایید شده <span class="badge bg-light text-dark ms-1">{{ $approved }}</span>
                </button>
                <button class="btn btn-sm {{ $status===\App\Models\LeaveMissionRequest::ST_REJECTED?'btn-danger':'btn-outline-danger' }}" wire:click="$set('status','{{ \App\Models\LeaveMissionRequest::ST_REJECTED }}')">
                    رد شده <span class="badge bg-light text-dark ms-1">{{ $rejected }}</span>
                </button>
            </div>
        </div>
    </div>

    {{-- جدول --}}
    <div class="card border-0 shadow-sm rounded-4">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                    <tr class="text-secondary small">
                        <th style="width:36px">
                            <input class="form-check-input" type="checkbox"
                                   wire:click="toggleSelectAllOnPage({{ json_encode($pageIds) }})"
                                @checked($selectAllOnPage)>
                        </th>

                        <th class="sortable" style="width:70px" wire:click="sortBy('id')">
                            #
                            <i class="fas {{ $sortField==='id' ? ($sortDirection==='asc'?'fa-sort-up':'fa-sort-down') : 'fa-sort text-muted' }}"></i>
                        </th>

                        <th>نوع</th>

                        <th class="sortable" wire:click="sortBy('title')">
                            عنوان
                            <i class="fas {{ $sortField==='title' ? ($sortDirection==='asc'?'fa-sort-up':'fa-sort-down') : 'fa-sort text-muted' }}"></i>
                        </th>

                        <th>وضعیت</th>

                        <th class="sortable" wire:click="sortBy('start_datetime')">
                            از
                            <i class="fas {{ $sortField==='start_datetime' ? ($sortDirection==='asc'?'fa-sort-up':'fa-sort-down') : 'fa-sort text-muted' }}"></i>
                        </th>

                        <th>تا</th>

                        <th class="text-center" style="width:110px">مدت (ساعت)</th>

                        <th class="sortable" wire:click="sortBy('submitted_at')">
                            ارسال
                            <i class="fas {{ $sortField==='submitted_at' ? ($sortDirection==='asc'?'fa-sort-up':'fa-sort-down') : 'fa-sort text-muted' }}"></i>
                        </th>

                        <th class="text-end" style="width:120px"></th>
                    </tr>
                    </thead>

                    <tbody>
                    @forelse($items as $r)
                        @php
                            $typeLabel = $r->type==='leave' ? 'مرخصی' : 'ماموریت';
                            $statusMap = [
                                \App\Models\LeaveMissionRequest::ST_DRAFT    => ['label'=>'پیش‌نویس','class'=>'secondary','icon'=>'fa-pencil-alt'],
                                \App\Models\LeaveMissionRequest::ST_PENDING  => ['label'=>'در انتظار تایید','class'=>'info','icon'=>'fa-hourglass-half'],
                                \App\Models\LeaveMissionRequest::ST_APPROVED => ['label'=>'تایید شده','class'=>'success','icon'=>'fa-check'],
                                \App\Models\LeaveMissionRequest::ST_REJECTED => ['label'=>'رد شده','class'=>'danger','icon'=>'fa-times'],
                            ];
                            $st   = $statusMap[$r->status] ?? ['label'=>$r->status,'class'=>'light text-dark','icon'=>'fa-circle'];
                        @endphp
                        <tr wire:key="row-{{ $r->id }}">
                            <td>
                                <input class="form-check-input" type="checkbox"
                                       value="{{ $r->id }}"
                                       wire:model="selected"
                                    @disabled($r->status!==\App\Models\LeaveMissionRequest::ST_DRAFT)>
                            </td>

                            <td class="fw-semibold">#{{ $r->id }}</td>

                            <td>
                                    <span class="badge rounded-pill text-bg-{{ $r->type==='leave'?'info':'warning' }}">
                                        <i class="fas {{ $r->type==='leave'?'fa-umbrella-beach':'fa-briefcase' }} me-1"></i>{{ $typeLabel }}
                                    </span>
                                {{-- نشان نوع مرخصی یا شهر مأموریت --}}
                                @if($r->type==='leave' && optional($r->details)->leave_type)
                                    @php $lt=['annual'=>'استحقاقی','sick'=>'استعلاجی','unpaid'=>'بدون حقوق','overtime_comp'=>'جبرانی','other'=>'سایر']; @endphp
                                    <span class="badge rounded-pill text-bg-light ms-1">{{ $lt[$r->details->leave_type] ?? $r->details->leave_type }}</span>
                                @elseif($r->type==='mission' && optional($r->details)->mission_city)
                                    <span class="badge rounded-pill text-bg-light ms-1"><i class="fas fa-city me-1"></i>{{ $r->details->mission_city }}</span>
                                @endif
                            </td>

                            <td class="text-truncate" style="max-width:260px">
                                {{ $r->title ?: '—' }}
                                @if($r->description)
                                    <div class="small text-muted mt-1 text-truncate" style="max-width:260px">{{ $r->description }}</div>
                                @endif
                            </td>

                            <td>
                                    <span class="badge text-bg-{{ $st['class'] }}">
                                        <i class="fas {{ $st['icon'] }} me-1"></i>{{ $st['label'] }}
                                    </span>
                                @if($r->current_step)
                                    <span class="badge text-bg-light text-muted" data-bs-toggle="tooltip" title="مرحله جاری تأیید">
                                            مرحله {{ $r->current_step }}
                                        </span>
                                @endif
                            </td>

                            <td class="small text-muted">{{ optional($r->details)->start_j ?: '—' }}</td>
                            <td class="small text-muted">{{ optional($r->details)->end_j   ?: '—' }}</td>
                            <td class="text-center small">{{ optional($r->details)->duration_hours ?: '—' }}</td>

                            <td class="small text-muted">
                                @if($r->submitted_at)
                                    {{ \Morilog\Jalali\Jalalian::fromCarbon($r->submitted_at)->format('Y/m/d H:i') }}
                                @else
                                    —
                                @endif
                            </td>

                            <td class="text-end">
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.attendence.requests.show',$r) }}" class="btn btn-outline-primary" data-bs-toggle="tooltip" title="مشاهده">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    @if($r->status===\App\Models\LeaveMissionRequest::ST_DRAFT)
                                        <a href="{{ route('admin.attendence.requests.create', ['draft' => $r->id]) }}"
                                           class="btn btn-outline-secondary" data-bs-toggle="tooltip" title="ویرایش پیش‌نویس">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        {{-- Empty state --}}
                        <tr>
                            <td colspan="10" class="text-center py-5">
                                <div class="text-muted">
                                    <i class="fas fa-inbox fa-2x mb-2 opacity-50"></i>
                                    <div class="fw-semibold">درخواستی پیدا نشد.</div>
                                    <a class="btn btn-sm btn-primary mt-3" href="{{ route('admin.attendence.requests.create') }}">
                                        <i class="fas fa-plus-circle me-1"></i> ثبت درخواست جدید
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        {{-- اکشن‌های انتخاب گروهی --}}
        <div class="card-footer bg-white d-flex justify-content-between align-items-center">
            <div class="small text-muted">
                @if(count($selected))
                    <span class="fw-semibold">{{ count($selected) }}</span> مورد انتخاب شده
                @else
                    &nbsp;
                @endif
            </div>
            <div class="d-flex gap-2">
                <button class="btn btn-outline-danger btn-sm"
                        wire:click="bulkDeleteDrafts"
                        wire:loading.attr="disabled"
                    @disabled(!count($selected))>
                    <span wire:loading.remove wire:target="bulkDeleteDrafts"><i class="fas fa-trash-alt me-1"></i> حذف پیش‌نویس‌های انتخاب‌شده</span>
                    <span wire:loading wire:target="bulkDeleteDrafts"><i class="fas fa-spinner fa-spin me-1"></i> در حال حذف...</span>
                </button>
                <div class="d-none d-md-block">
                    {{ $items->onEachSide(1)->links() }}
                </div>
            </div>
        </div>

        {{-- صفحه‌بندی موبایل --}}
        <div class="card-footer bg-white d-md-none">
            {{ $items->onEachSide(0)->links() }}
        </div>
    </div>
</div>

@push('scripts')
    {{-- Persian Datepicker --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <script>
        document.addEventListener('livewire:initialized', () => {
            const bindPicker = (id) => {
                const $el = $('#'+id);
                if (!$el.length) return;
                $el.pDatepicker({
                    format: 'YYYY/MM/DD HH:mm',
                    timePicker: { enabled: true },
                    autoClose: true,
                    calendar: { persian: { locale: 'fa' } },
                    onSelect: function(){ $el.val($el.val()).trigger('input'); }
                });
            };
            bindPicker('fromJ');
            bindPicker('toJ');

            // تول‌تیپ‌ها
            const initTooltips = () => {
                document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
                    if (bootstrap.Tooltip.getInstance(el)) {
                        bootstrap.Tooltip.getInstance(el).dispose();
                    }
                    new bootstrap.Tooltip(el);
                });
            };
            initTooltips();
            Livewire.hook('morph.updated', initTooltips);

            // میان‌بر فوکوس روی سرچ با کلید /
            window.addEventListener('keydown', (e) => {
                if (e.key === '/' && !['INPUT','TEXTAREA'].includes(document.activeElement.tagName)) {
                    e.preventDefault();
                    document.querySelector('input[wire\\:model\\.live\\.debounce\\.500ms="search"]')?.focus();
                }
            });
        });
    </script>

    <style>
        th.sortable {
            cursor: pointer;
            user-select: none;
            transition: all 0.2s ease;
        }
        th.sortable:hover {
            background-color: #f8f9fa;
        }
        th.sortable i {
            margin-inline-start: .35rem;
            transition: all 0.2s ease;
        }
        .table > :not(caption) > * > * {
            padding: .65rem .75rem;
        }

        .position-sticky.top-0 {
            top: .75rem;
        }

        .card {
            --bs-card-border-radius: 1rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        .badge.rounded-pill {
            font-weight: 600;
            padding: 0.45em 0.8em;
        }

        /* موبایل فرندلی */
        @media (max-width: 768px) {
            .btn-group .btn {
                padding: 0.25rem 0.5rem;
                font-size: 0.75rem;
            }

            .table th,
            .table td {
                font-size: 0.875rem;
                padding: 0.5rem;
            }

            .form-control-sm {
                font-size: 0.875rem;
                padding: 0.25rem 0.5rem;
            }
        }
    </style>
@endpush
