<div class="container-fluid px-3 px-md-4 py-3 py-md-4">
    {{-- سربرگ چسبان --}}
    <div class="position-sticky top-0 z-3 mb-4">
        <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between bg-white border rounded-4 px-3 py-3 shadow-sm">
            <div class="d-flex flex-wrap align-items-center gap-3 mb-3 mb-md-0">
                <a href="{{ route('admin.attendence.requests.index') }}" class="btn btn-light btn-sm" data-bs-toggle="tooltip" title="بازگشت">
                    <i class="fas fa-arrow-right"></i> بازگشت
                </a>

                <div class="d-flex flex-wrap align-items-center gap-2">
                    <h5 class="fw-bold m-0 d-flex align-items-center gap-2">
                        <i class="fas fa-file-alt text-primary"></i>
                        درخواست #{{ $req->id }}
                    </h5>
                    <span class="badge rounded-pill {{ $statusMap[$req->status]['class'] ?? 'text-bg-secondary' }} py-2 px-3">
                        {{ $statusMap[$req->status]['label'] ?? $req->status }}
                    </span>
                    @if($req->details && $req->details->duration_hours)
                        <span class="badge text-bg-success py-2 px-3">
                            <i class="fas fa-hourglass-half me-1"></i> {{ $durationText($req->details->duration_hours) }}
                        </span>
                    @endif
                </div>

                {{-- تأییدکنندگان بعدی --}}
                <div class="d-none d-lg-flex align-items-center gap-2 ms-2">
                    <span class="small text-muted">تأییدکنندگان بعدی:</span>
                    @if($upcomingApprovers->count())
                        @foreach($upcomingApprovers as $ap)
                            <span class="badge rounded-pill text-bg-light py-2 px-3" data-bs-toggle="tooltip"
                                  title="قدم {{ $ap->step_order }} - {{ $approvalLabel($ap->status) }}">
                                {{ $ap->approver?->name ?? '—' }}
                            </span>
                        @endforeach
                    @else
                        <span class="small text-muted">—</span>
                    @endif
                </div>
            </div>

            <div class="d-flex flex-wrap align-items-center gap-2">
                <button class="btn btn-outline-secondary btn-sm" id="printBtn" title="پرینت" data-bs-toggle="tooltip">
                    <i class="fas fa-print"></i>
                </button>
                <button class="btn btn-outline-secondary btn-sm" id="copyLinkBtn" title="کپی لینک" data-bs-toggle="tooltip">
                    <i class="fas fa-link"></i>
                </button>
                <button class="btn btn-outline-secondary btn-sm" wire:click="downloadIcs" title="افزودن به تقویم (ICS)" data-bs-toggle="tooltip">
                    <i class="fas fa-calendar-plus"></i>
                </button>
                <button class="btn btn-outline-primary btn-sm" wire:click="downloadPdf" title="دانلود PDF" data-bs-toggle="tooltip" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="downloadPdf"><i class="fas fa-file-pdf"></i></span>
                    <span wire:loading wire:target="downloadPdf"><i class="fas fa-spinner fa-spin"></i></span>
                </button>
                @if($canWithdraw)
                    <button class="btn btn-outline-dark btn-sm" wire:click="withdraw" title="لغو درخواست" data-bs-toggle="tooltip" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="withdraw"><i class="fas fa-ban"></i> لغو</span>
                        <span wire:loading wire:target="withdraw"><i class="fas fa-spinner fa-spin"></i></span>
                    </button>
                @endif
                <div class="small text-muted">
                    <div>ثبت‌کننده: <strong>{{ $req->user->name }}</strong></div>
                    <div>{{ $fJ($req->created_at) }}</div>
                </div>
            </div>
        </div>

        {{-- نوار پیشرفت زنجیره تأیید --}}
        <div class="progress mt-3" role="progressbar" aria-valuenow="{{ $progress }}" aria-valuemin="0" aria-valuemax="100" style="height: 8px; border-radius: 4px;">
            <div class="progress-bar bg-gradient" style="width: {{ $progress }}%"></div>
        </div>
        <div class="d-flex justify-content-between small text-muted mt-2">
            <span>تکمیل: {{ $stepsDone }} / {{ $stepsTotal }}</span>
            <span>%{{ $progress }}</span>
        </div>
    </div>

    {{-- پیام‌ها --}}
    @if (session('ok'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
            <i class="fas fa-check-circle fs-4 me-3 text-success"></i>
            <div class="flex-grow-1">
                <strong class="d-block">عملیات موفقیت‌آمیز</strong>
                {{ session('ok') }}
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if (session('err'))
        <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
            <i class="fas fa-exclamation-triangle fs-4 me-3 text-danger"></i>
            <div class="flex-grow-1">
                <strong class="d-block">خطا!</strong>
                {{ session('err') }}
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        {{-- جزئیات --}}
        <div class="col-12 col-lg-8">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-white border-0 d-flex align-items-center justify-content-between py-3 px-4">
                    <div class="d-flex align-items-center gap-3">
                        <span class="badge text-bg-{{ $req->type === 'leave' ? 'info' : 'warning' }} py-2 px-3">
                            {{ $req->type === 'leave' ? 'مرخصی' : 'ماموریت' }}
                        </span>
                        @if($req->title)
                            <span class="fw-semibold fs-5">{{ $req->title }}</span>
                        @endif
                        @if($req->details && $req->details->is_full_day)
                            <span class="badge text-bg-light py-2 px-3">تمام‌روز</span>
                        @endif
                    </div>
                </div>

                <div class="card-body p-4">
                    <div class="row gy-4">
                        <div class="col-md-6">
                            <div class="border rounded-3 p-4 h-100 bg-light">
                                <div class="text-muted small mb-2 fw-semibold">از</div>
                                <div class="fw-bold fs-5">{{ $req->details ? $fJ($req->details->start_datetime) : '—' }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="border rounded-3 p-4 h-100 bg-light">
                                <div class="text-muted small mb-2 fw-semibold">تا</div>
                                <div class="fw-bold fs-5">{{ $req->details ? $fJ($req->details->end_datetime) : '—' }}</div>
                            </div>
                        </div>

                        @if($req->type === 'leave')
                            <div class="col-12">
                                <div class="border rounded-3 p-4 bg-light">
                                    <div class="text-muted small mb-2 fw-semibold">نوع مرخصی</div>
                                    @php $leaveMap=['annual'=>'استحقاقی','sick'=>'استعلاجی','unpaid'=>'بدون حقوق','overtime_comp'=>'جبرانی','other'=>'سایر']; @endphp
                                    <div class="fw-bold fs-5">
                                        {{ $req->details? ($leaveMap[$req->details->leave_type] ?? $req->details->leave_type) : '—' }}
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-md-4">
                                <div class="border rounded-3 p-4 h-100 bg-light">
                                    <div class="text-muted small mb-2 fw-semibold">پروژه</div>
                                    <div class="fw-bold fs-5">
                                        @if(isset($project) && $project)
                                            {{ $project->name }}@if($project->code) — {{ $project->code }} @endif
                                        @else — @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="border rounded-3 p-4 h-100 bg-light">
                                    <div class="text-muted small mb-2 fw-semibold">شهر</div>
                                    <div class="fw-bold fs-5">{{ $req->details->mission_city ?? '—' }}</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="border rounded-3 p-4 h-100 bg-light">
                                    <div class="text-muted small mb-2 fw-semibold">هدف/موضوع</div>
                                    <div class="fw-bold fs-5">{{ $req->details->mission_purpose ?? '—' }}</div>
                                </div>
                            </div>
                        @endif

                        <div class="col-12">
                            <div class="border rounded-3 p-4 bg-light">
                                <div class="text-muted small mb-2 fw-semibold">توضیحات</div>
                                <div class="fs-5">{{ $req->description ?: '—' }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- اکشن‌ها برای تأییدکننده فعلی --}}
                @if($req->status === \App\Models\LeaveMissionRequest::ST_PENDING && $amCurrentApprover)
                    <div class="card-footer bg-white d-flex flex-wrap justify-content-between align-items-center gap-3 p-4">
                        <div class="small text-muted">
                            <i class="fas fa-keyboard me-1"></i> میانبرها:
                            <kbd class="bg-light text-dark">A</kbd> تأیید،
                            <kbd class="bg-light text-dark">R</kbd> رد،
                            <kbd class="bg-light text-dark">P</kbd> پرینت
                        </div>
                        <div class="d-flex gap-3">
                            <button id="kb-approve" type="button" class="btn btn-success btn-lg px-4 py-2"
                                    wire:click="openDecisionModal('approve')">
                                <i class="fas fa-check me-2"></i> تأیید با یادداشت
                            </button>
                            <button id="kb-reject" type="button" class="btn btn-outline-danger btn-lg px-4 py-2"
                                    wire:click="openDecisionModal('reject')">
                                <i class="fas fa-times me-2"></i> رد با دلیل
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        {{-- تایم‌لاین تأیید --}}
        <div class="col-12 col-lg-4">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-white border-0 d-flex align-items-center justify-content-between py-3 px-4">
                    <h6 class="m-0 fw-bold"><i class="fas fa-route me-2 text-primary"></i> زنجیرهٔ تأیید</h6>
                    <span class="badge text-bg-light py-2 px-3">قدم جاری: {{ $req->current_step ?: '—' }}</span>
                </div>
                <div class="card-body p-0">
                    @if($req->approvals->count())
                        <ul class="list-group list-group-flush">
                            @foreach($req->approvals as $ap)
                                @php
                                    $icon = [
                                        \App\Models\ApprovalStep::ST_PENDING  => 'text-warning fa-clock',
                                        \App\Models\ApprovalStep::ST_APPROVED => 'text-success fa-check-circle',
                                        \App\Models\ApprovalStep::ST_REJECTED => 'text-danger fa-times-circle',
                                        \App\Models\ApprovalStep::ST_SKIPPED  => 'text-muted fa-forward'
                                    ][$ap->status] ?? 'fa-circle';
                                @endphp
                                <li class="list-group-item p-4">
                                    <div class="d-flex align-items-start gap-3">
                                        <div class="pt-1">
                                            <div class="rounded-circle bg-light d-flex align-items-center justify-content-center" style="width: 36px; height: 36px;">
                                                <i class="fas {{ $icon }} fs-5"></i>
                                            </div>
                                        </div>
                                        <div class="flex-fill">
                                            <div class="fw-semibold d-flex flex-wrap align-items-center gap-2 mb-2">
                                                <span class="badge text-bg-light py-2 px-3">#{{ $ap->step_order }}</span>
                                                <span class="fs-5">{{ $ap->approver?->name ?? '—' }}</span>
                                                <span class="badge rounded-pill {{ $approvalBadge($ap->status) }} py-2 px-3">
                                                    {{ $approvalLabel($ap->status) }}
                                                </span>
                                                @if($req->status===\App\Models\LeaveMissionRequest::ST_PENDING && $ap->is_current && $amCurrentApprover)
                                                    <span class="badge text-bg-primary py-2 px-3">شما</span>
                                                @endif
                                            </div>
                                            <div class="small text-muted mb-2">{{ $ap->role_hint ?? '' }}</div>
                                            @if($ap->decided_at)
                                                <div class="small mt-2 text-muted">در {{ $fJ($ap->decided_at) }}</div>
                                            @endif
                                            @if(!empty($ap->comment))
                                                <div class="mt-3 bg-light border rounded p-3">
                                                    <div class="d-flex align-items-center gap-2 mb-2">
                                                        <i class="fas fa-quote-right text-muted"></i>
                                                        <span class="fw-semibold">یادداشت:</span>
                                                    </div>
                                                    <div class="small">{{ $ap->comment }}</div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="alert alert-warning small mb-0 m-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            هیچ تأییدکننده‌ای برای این درخواست تعریف نشده است.
                        </div>
                    @endif
                </div>
                <div class="card-footer bg-white small text-muted py-3 px-4">
                    <i class="fas fa-paper-plane me-2"></i>
                    {{ $req->submitted_at ? 'ارسال: '.$fJ($req->submitted_at) : 'هنوز ارسال نشده' }}
                </div>
            </div>
        </div>
    </div>

    {{-- مدال تصمیم (یادداشت) --}}
    @if($showDecisionModal)
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,.35);">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0 rounded-4 shadow-lg">
                    <div class="modal-header {{ $decisionAction==='approve' ? 'bg-success' : 'bg-danger' }} text-white rounded-top-4">
                        <h5 class="modal-title">
                            <i class="fas {{ $decisionAction==='approve' ? 'fa-check-circle' : 'fa-times-circle' }} me-2"></i>
                            {{ $decisionAction==='approve' ? 'تأیید درخواست' : 'رد درخواست' }}
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="$set('showDecisionModal', false)"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="mb-4">
                            <label class="form-label fw-bold">یادداشت / دلیل (اختیاری)</label>
                            <textarea class="form-control form-control-lg" rows="5" wire:model.defer="decisionNote"
                                      placeholder="{{ $decisionAction==='approve' ? 'مثلاً: مورد تأیید است.' : 'دلیل رد را بنویسید...' }}"></textarea>
                            <div class="form-text text-muted">
                                این یادداشت در سابقه درخواست ثبت و برای درخواست‌دهنده قابل مشاهده خواهد بود.
                            </div>
                        </div>

                        <div class="alert alert-{{ $decisionAction==='approve' ? 'success' : 'danger' }} border-0 small">
                            <i class="fas {{ $decisionAction==='approve' ? 'fa-info-circle' : 'fa-exclamation-triangle' }} me-2"></i>
                            {{ $decisionAction==='approve' ? 'درخواست پس از تأیید به مرحله بعدی ارسال می‌شود.' : 'درخواست پس از رد به طور کامل لغو می‌شود.' }}
                        </div>
                    </div>
                    <div class="modal-footer border-0 p-4">
                        <button class="btn btn-lg btn-outline-secondary px-4 py-2" wire:click="$set('showDecisionModal', false)">
                            <i class="fas fa-times me-2"></i> انصراف
                        </button>
                        <button class="btn btn-lg {{ $decisionAction==='approve' ? 'btn-success' : 'btn-danger' }} px-4 py-2"
                                wire:click="submitDecision" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas {{ $decisionAction==='approve' ? 'fa-check' : 'fa-times' }} me-2"></i>
                                {{ $decisionAction==='approve' ? 'تأیید نهایی' : 'رد نهایی' }}
                            </span>
                            <span wire:loading>
                                <i class="fas fa-spinner fa-spin me-2"></i> در حال پردازش...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('scripts')
    <script>
        document.addEventListener('livewire:initialized', () => {
            // ابزارک‌ها
            const initTooltips = () => {
                document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
                    if (bootstrap.Tooltip.getInstance(el)) {
                        bootstrap.Tooltip.getInstance(el).dispose();
                    }
                    new bootstrap.Tooltip(el);
                });
            };
            initTooltips();
            Livewire.hook('morph.updated', initTooltips);

            // پرینت
            document.getElementById('printBtn')?.addEventListener('click', () => window.print());

            // کپی لینک
            const copyBtn = document.getElementById('copyLinkBtn');
            if (copyBtn) copyBtn.addEventListener('click', async () => {
                try {
                    await navigator.clipboard.writeText(window.location.href);
                    const t = document.createElement('div');
                    t.className = 'toast align-items-center text-bg-success border-0 show position-fixed bottom-0 end-0 m-3';
                    t.innerHTML = '<div class="d-flex"><div class="toast-body fs-5 fw-bold">لینک با موفقیت کپی شد!</div><button type="button" class="btn-close btn-close-white me-2 m-auto" onclick="this.closest(\\' . 'toast\\').remove()"></button></div>';
                    document.body.appendChild(t);
                    setTimeout(()=> t.remove(), 2200);
                } catch {}
            });

            // میانبرها: A=approve, R=reject, P=print
            window.addEventListener('keydown', (e) => {
                if (['INPUT','TEXTAREA'].includes(e.target.tagName)) return;
                const k = e.key.toLowerCase();
                if (k === 'p') window.print();
                if (k === 'a') document.getElementById('kb-approve')?.click();
                if (k === 'r') document.getElementById('kb-reject')?.click();
            });
        });
    </script>

    <style>
        /* نمای چاپ تمیز */
        @media print {
            header, nav, .position-sticky, .btn, .modal, .alert, [class*="toast"], [class*="pagination"] { display: none !important; }
            .card { box-shadow: none !important; border: 1px solid #ddd !important; }
            .container-fluid { padding: 0 !important; }
            body { background: #fff !important; }
        }

        /* گرادیانت برای نوار پیشرفت */
        .bg-gradient {
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
        }

        /* استایل‌های مدرن */
        .badge.rounded-pill {
            border-radius: 50rem !important;
            font-weight: 600;
        }

        .list-group-item {
            border: none;
            transition: all 0.2s ease;
        }

        .list-group-item:hover {
            background-color: #f8f9fa;
        }

        /* موبایل فرندلی */
        @media (max-width: 768px) {
            .btn-lg {
                padding: 0.5rem 1rem !important;
                font-size: 0.875rem !important;
            }

            .fs-5 {
                font-size: 1rem !important;
            }

            .p-4 {
                padding: 1rem !important;
            }

            .gap-3 {
                gap: 0.75rem !important;
            }

            .modal-lg {
                max-width: 95% !important;
            }

            .position-sticky {
                position: relative !important;
                top: 0 !important;
            }
        }
    </style>
@endpush
