<div class="container-fluid py-4">
    <h2 class="fw-bold mb-4 d-flex align-items-center gap-2">
        <i class="ti ti-folders text-primary"></i>
        مدیریت دسته‌بندی‌های وبلاگ
    </h2>

    {{-- Flash Messages --}}
    @if(session()->has('success') || session()->has('error'))
        <div class="alert alert-{{ session()->has('success') ? 'success' : 'danger' }} rounded-3 shadow-sm mb-4" role="alert">
            {{ session('success') ?? session('error') }}
        </div>
    @endif

    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-white p-4 d-flex justify-content-between align-items-center">

            {{-- Search Input --}}
            <div class="col-md-5">
                <input wire:model.live.debounce.300ms="search" type="text" class="form-control" placeholder="جستجوی دسته‌بندی بر اساس نام یا اسلاگ...">
            </div>

            {{-- Create Button --}}
            <button type="button" class="btn btn-primary btn-lg rounded-3"
                    data-bs-toggle="modal" data-bs-target="#upsertCategoryModal">
                <i class="ti ti-plus me-1"></i> ایجاد دسته‌بندی جدید
            </button>
        </div>

        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                    <tr>
                        <th scope="col" wire:click="sortBy('id')" class="cursor-pointer">
                            شناسه
                            @if ($sortField == 'id') <i class="ti ti-arrow-{{ $sortAsc ? 'up' : 'down' }}"></i> @endif
                        </th>
                        <th scope="col" wire:click="sortBy('name')" class="cursor-pointer">
                            نام دسته‌بندی
                            @if ($sortField == 'name') <i class="ti ti-arrow-{{ $sortAsc ? 'up' : 'down' }}"></i> @endif
                        </th>
                        <th scope="col" wire:click="sortBy('slug')" class="cursor-pointer">
                            اسلاگ (Slug)
                            @if ($sortField == 'slug') <i class="ti ti-arrow-{{ $sortAsc ? 'up' : 'down' }}"></i> @endif
                        </th>
                        <th scope="col">تعداد پست‌ها</th>
                        <th scope="col">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse ($categories as $category)
                        <tr>
                            <td>{{ $category->id }}</td>
                            <td><span class="fw-bold text-dark">{{ $category->name }}</span></td>
                            <td><span class="text-muted">{{ $category->slug }}</span></td>
                            <td><span class="badge bg-primary-subtle text-primary">{{ $category->posts_count ?? $category->posts()->count() }}</span></td>
                            <td>
                                <button type="button" class="btn btn-sm btn-outline-info"
                                        wire:click="$dispatch('edit-category', { categoryId: {{ $category->id }} })"
                                        data-bs-toggle="modal" data-bs-target="#upsertCategoryModal"
                                        title="ویرایش">
                                    <i class="ti ti-edit"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger"
                                        wire:click="confirmDelete({{ $category->id }})"
                                        title="حذف">
                                    <i class="ti ti-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-4 text-muted">
                                <i class="ti ti-alert-triangle fs-4 d-block mb-1"></i>
                                هیچ دسته‌بندی‌ای یافت نشد.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card-footer bg-white">
            {{ $categories->links() }}
        </div>
    </div>

    {{-- Include Upsert Modal Component --}}
    @livewire('admin.category.upsert')

    {{-- Confirmation Modal (Bootstrap Modal) --}}
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" wire:ignore.self>
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title"><i class="ti ti-alert-triangle me-1"></i> هشدار حذف</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>آیا مطمئن هستید که می‌خواهید این دسته‌بندی را حذف کنید؟</p>
                    <p class="text-danger small fw-bold">⚠️ این عملیات قابل بازگشت نیست.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="button" class="btn btn-danger" wire:click="deleteCategory">
                        <span wire:loading.remove wire:target="deleteCategory">حذف کن</span>
                        <span wire:loading wire:target="deleteCategory"><i class="ti ti-loader animate-spin"></i> در حال حذف...</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    {{-- JavaScript to show modal using Alpine/Livewire hooks --}}
    @script
    <script>
        // For Delete Confirmation Modal
        Livewire.hook('element.updated', ({ component, el }) => {
            if (component.name === 'admin.category.index' && el.id === 'deleteConfirmationModal') {
                if (component.get('showDeleteModal')) {
                    new bootstrap.Modal(document.getElementById('deleteConfirmationModal')).show();
                } else {
                    bootstrap.Modal.getInstance(document.getElementById('deleteConfirmationModal'))?.hide();
                }
            }
        });
        // Handle closing the Upsert modal after creation/update
        Livewire.on('category-saved', () => {
            const modalElement = document.getElementById('upsertCategoryModal');
            const modal = bootstrap.Modal.getInstance(modalElement);
            if (modal) {
                modal.hide();
            }
        });
    </script>
    @endscript
</div>
