{{-- Bootstrap Modal for Upsert (Create/Edit) --}}
<div class="modal fade" id="upsertCategoryModal" tabindex="-1" aria-labelledby="upsertCategoryModalLabel" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content rounded-4 shadow-lg">

            {{-- Header based on state (Create or Edit) --}}
            <div class="modal-header bg-primary text-white p-4">
                <h5 class="modal-title fw-bold d-flex align-items-center gap-2" id="upsertCategoryModalLabel">
                    <i class="ti ti-tag fs-4"></i>
                    @if ($categoryId)
                        ویرایش دسته‌بندی: {{ $name }}
                    @else
                        ایجاد دسته‌بندی جدید
                    @endif
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" wire:click="resetForm"></button>
            </div>

            <form wire:submit.prevent="save">
                <div class="modal-body p-4">

                    {{-- Category Name --}}
                    <div class="mb-4">
                        <label for="name" class="form-label fw-bold">نام دسته‌بندی <span class="text-danger">*</span></label>
                        <input type="text" id="name" class="form-control form-control-lg @error('name') is-invalid @enderror"
                               wire:model.live="name" placeholder="مثال: آموزش برنامه‌نویسی">
                        @error('name') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                    </div>

                    {{-- Slug --}}
                    <div class="mb-3">
                        <label for="slug" class="form-label fw-bold">اسلاگ (URL Friendly) <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="ti ti-link"></i></span>
                            <input type="text" id="slug" class="form-control @error('slug') is-invalid @enderror"
                                   wire:model="slug" dir="ltr" placeholder="slug-name-example">
                        </div>
                        <small class="text-muted d-block mt-1">اسلاگ به صورت خودکار از نام تولید می‌شود.</small>
                        @error('slug') <div class="text-danger mt-1">{{ $message }}</div> @enderror
                    </div>

                </div>

                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-secondary rounded-3" data-bs-dismiss="modal" wire:click="resetForm">
                        انصراف
                    </button>

                    <button type="submit" class="btn btn-success btn-lg rounded-3" wire:loading.attr="disabled" wire:target="save">
                        <span wire:loading.remove wire:target="save">
                            <i class="ti ti-device-floppy me-1"></i>
                            {{ $categoryId ? 'ذخیره تغییرات' : 'ایجاد دسته‌بندی' }}
                        </span>
                        <span wire:loading wire:target="save">
                            <i class="ti ti-loader animate-spin me-1"></i> در حال ذخیره...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
