<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="sendMessage">
        <div>
            <label for="chat_id">انتخاب چت:</label>
            <select id="chat_id" wire:model="chat_id">
                <option value="">انتخاب چت</option>
                @foreach($chats as $chat)
                    <option value="{{ $chat->id }}">{{ $chat->name }}</option>
                @endforeach
            </select>
            @error('chat_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="message">پیام:</label>
            <textarea id="message" wire:model="message" placeholder="پیام"></textarea>
            @error('message') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="file">فایل:</label>
            <input type="file" id="file" wire:model="file">
            @error('file') <span class="error">{{ $message }}</span> @enderror
        </div>

        <button type="submit">ارسال</button>
    </form>

    <h3>چت‌ها:</h3>
    @foreach($chats as $chat)
        <div>
            <h4>{{ $chat->name }}</h4>
            <ul>
                @foreach($chat->messages as $message)
                    <li>{{ $message->user->name }}: {{ $message->message }}
                        @if($message->file_path)
                            <a href="{{ Storage::url($message->file_path) }}">دانلود فایل</a>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    @endforeach
</div>
