<div class="contact-book-wrapper"
     x-data="{
         isSidebarOpen: window.innerWidth > 992,
         viewMode: @entangle('viewMode'),
         toastQueue: [],
         addToast(message, type = 'info') {
             const id = Date.now();
             this.toastQueue.push({ id, message, type });
             setTimeout(() => this.removeToast(id), 5000);
         },
         removeToast(id) {
             this.toastQueue = this.toastQueue.filter(t => t.id !== id);
         }
     }"
     x-init="$wire.on('toast', ({ message, type }) => addToast(message, type))"
     dir="rtl"
     style="
        /* رنگ‌های جدید مینیمال */
        --action-color: #4f46e5; /* Indigo */
        --action-color-light: #eef2ff;
        --danger-color: #ef4444;
        --success-color: #10b981;
        --border-color: #e5e7eb;
        --card-bg: #FFFFFF;
        --header-height: 70px; /* ارتفاع نوار بالایی */
        --sidebar-top-offset: calc(var(--header-height) + 15px);
    ">

    {{-- 🎯 Toast --}}
    {{-- (فرض می‌کنیم اینجا منطق نمایش Toast وجود دارد) --}}

    {{-- 🏷️ هدر اصلی و عملیات (ثابت نیست، در فضای محتواست) --}}
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4 pt-3">
        <h1 class="h3 fw-bold text-dark d-flex align-items-center">
            <i class="ti ti-address-book me-2 fs-3 text-primary"></i>
            دفترچه تماس هوشمند
        </h1>
        <div class="d-flex flex-wrap gap-2">
            <button class="btn btn-outline-secondary d-flex align-items-center rounded-3 border-0" @click="isSidebarOpen = !isSidebarOpen">
                <i class="ti ti-filter me-1"></i> فیلتر
            </button>
            <div class="btn-group rounded-3 overflow-hidden">
                <button class="btn btn-outline-secondary d-flex align-items-center" wire:click="openImportModal">
                    <i class="ti ti-upload me-1"></i> وارد کردن
                </button>
                <button class="btn btn-outline-secondary d-flex align-items-center" wire:click="openExportModal">
                    <i class="ti ti-download me-1"></i> خروجی
                </button>
            </div>
            <button class="btn btn-primary d-flex align-items-center rounded-3 shadow-sm" wire:click="addContact">
                <i class="ti ti-user-plus me-1"></i> مخاطب جدید
            </button>
        </div>
    </div>

    <div class="row g-4">
        {{-- 📋 Sidebar — فیلترها و گروه‌ها --}}
        <div class="col-lg-3" x-show="isSidebarOpen" x-transition.opacity.duration.300ms>
            <div class="card rounded-3 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-body p-4">
                    {{-- 🔍 جستجو --}}
                    <div class="mb-4">
                        <div class="input-group rounded-3 overflow-hidden border border-primary-subtle bg-white">
                            <span class="input-group-text bg-white border-0 pe-3">
                                <i class="ti ti-search text-primary"></i>
                            </span>
                            <input type="text" wire:model.live.debounce.300ms="search"
                                   class="form-control border-0 bg-transparent py-2"
                                   placeholder="نام، تلفن، آدرس یا برچسب...">
                        </div>
                    </div>

                    {{-- 📅 فیلتر تاریخ شمسی --}}
                    <div class="mb-4 border-top pt-3">
                        <label class="form-label fw-bold text-dark d-block mb-2"><i class="ti ti-calendar-event me-1 text-muted"></i> تاریخ ایجاد</label>
                        {{-- 💡 تاریخ شروع --}}
                        <div class="input-group rounded-3 overflow-hidden border">
                            <span class="input-group-text bg-light border-0 px-3">از</span>
                            <input type="text"
                                   x-data="{
                                       init() {
                                           flatpickr($el, { allowInput: true, dateFormat: 'Y/m/d', locale: 'fa',
                                               onChange: function(selectedDates, dateStr) { @this.set('dateRange', [dateStr, @this.dateRange[1] || '']); }
                                           });
                                       }
                                   }"
                                   class="form-control border-0 bg-transparent"
                                   placeholder="تاریخ شروع"
                                   value="{{ $dateRange[0] ?? '' }}">
                        </div>
                        {{-- 💡 تاریخ پایان --}}
                        <div class="input-group rounded-3 overflow-hidden border mt-2">
                            <span class="input-group-text bg-light border-0 px-3">تا</span>
                            <input type="text"
                                   x-data="{
                                       init() {
                                           flatpickr($el, { allowInput: true, dateFormat: 'Y/m/d', locale: 'fa',
                                               onChange: function(selectedDates, dateStr) { @this.set('dateRange', [@this.dateRange[0] || '', dateStr]); }
                                           });
                                       }
                                   }"
                                   class="form-control border-0 bg-transparent"
                                   placeholder="تاریخ پایان"
                                   value="{{ $dateRange[1] ?? '' }}">
                        </div>
                    </div>

                    {{-- 📂 گروه‌ها --}}
                    <h6 class="fw-bold text-dark mt-4 mb-3 border-top pt-3"><i class="ti ti-folder me-1 text-muted"></i> گروه‌های مخاطبین</h6>
                    <div class="list-group list-group-flush mb-4 custom-group-list">
                        {{-- آیتم همه مخاطبین --}}
                        <button type="button"
                                class="list-group-item list-group-item-action rounded-3 mb-2 p-3 border-0 active-group-btn @if(!$selectedGroup) bg-primary-subtle text-primary fw-bold active-group-shadow @else bg-white text-dark @endif"
                                wire:click="$set('selectedGroup', null)">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-medium">همه مخاطبین</span>
                                <span class="badge bg-primary text-white">{{ number_format($totalContacts) }}</span>
                            </div>
                        </button>
                        {{-- لیست گروه‌ها --}}
                        @foreach($contactGroups as $group)
                            <div class="list-group-item list-group-item-action rounded-3 mb-2 p-3 d-flex align-items-center justify-content-between gap-2 border-0 active-group-btn {{ $selectedGroup == $group->id ? 'bg-primary-subtle text-primary fw-bold active-group-shadow' : 'bg-white text-dark' }}"
                                 style="border-left: 4px solid {{ $group->color ?? '#ddd' }} !important;">

                                {{-- اطلاعات گروه --}}
                                <button type="button" class="flex-grow-1 btn btn-link text-decoration-none text-dark p-0 text-start"
                                        wire:click="$set('selectedGroup', {{ $group->id }})">
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="flex-shrink-0" style="display:inline-block;width:10px;height:10px;background:{{ $group->color ?? '#ddd' }};border-radius:50%;"></span>
                                        <span class="flex-grow-1 fw-medium {{ $selectedGroup == $group->id ? 'text-primary' : 'text-dark' }}">{{ $group->name }}</span>
                                        <span class="badge {{ $selectedGroup == $group->id ? 'bg-primary' : 'bg-secondary' }} text-white ms-auto me-2">{{ $group->contacts_count }}</span>
                                    </div>
                                </button>

                                {{-- عملیات گروه (فقط برای گروه‌های ایجاد شده توسط کاربر فعلی) --}}
                                @if($group->created_by === auth()->id())
                                    <div class="btn-group btn-group-sm flex-shrink-0 me-1">
                                        <button class="btn btn-sm btn-outline-secondary p-1 rounded-circle border-0 text-muted hover-icon-primary" title="ویرایش"
                                                wire:click="openEditGroupModal({{ $group->id }})">
                                            <i class="ti ti-edit fs-6"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger p-1 rounded-circle border-0 text-muted hover-icon-danger" title="حذف"
                                                wire:click="openDeleteGroupModal({{ $group->id }})">
                                            <i class="ti ti-trash fs-6"></i>
                                        </button>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    </div>

                    <button class="btn btn-outline-primary w-100 rounded-3 mt-3" wire:click="openAddGroupModal">
                        <i class="ti ti-folder-plus me-1"></i> ایجاد گروه جدید
                    </button>
                </div>
            </div>
        </div>

        {{-- 📱 Main Content --}}
        <div class="col-lg-9">
            {{-- ✅ نوار عملیات دسته‌جمعی (Bulk Action Bar) --}}
            <div x-show="$wire.selectedContacts.length > 0" x-transition.opacity.duration.300ms
                 class="alert bg-white border border-secondary-subtle text-dark rounded-3 shadow-sm p-3 mb-4 sticky-top d-flex justify-content-between align-items-center animated-bulk-bar"
                 style="top: 20px; z-index: 10;">

                <div class="d-flex align-items-center">
                    <span class="fw-bold me-2 fs-5 text-primary" x-text="$wire.selectedContacts.length">0</span>
                    <span class="text-muted">مخاطب انتخاب شده</span>
                </div>

                <div class="d-flex gap-2">
                    <button class="btn btn-sm btn-danger d-flex align-items-center rounded-3 shadow-sm"
                            wire:click="bulkDelete"
                            wire:confirm="آیا مطمئن هستید که می‌خواهید {{ count($selectedContacts) }} مخاطب را حذف کنید؟">
                        <i class="ti ti-trash me-1"></i> حذف دسته‌جمعی ({{ count($selectedContacts) }})
                    </button>

                    <button class="btn btn-sm btn-outline-secondary rounded-3" wire:click="clearSelection">
                        انصراف
                    </button>
                </div>
            </div>

            <div class="card rounded-3 shadow-sm">
                <div class="card-body p-4">
                    {{-- 📊 Header Info + Sort/View --}}
                    <div class="d-flex flex-wrap justify-content-between align-items-center mb-4 pb-3 border-bottom">
                        <div>
                            <h5 class="fw-bold text-dark mb-1">
                                <span class="text-primary">{{ number_format($totalContacts) }}</span>
                                <span class="text-muted mx-1">مخاطب پیدا شد.</span>
                            </h5>
                            @if($selectedGroup)
                                <small class="text-muted d-flex align-items-center">
                                    <i class="ti ti-tag me-1 text-primary"></i>
                                    نمایش در گروه «{{ $contactGroups->firstWhere('id', $selectedGroup)?->name ?? '—' }}»
                                </small>
                            @endif
                        </div>
                        <div class="d-flex gap-2 align-items-center flex-wrap">
                            <span class="text-muted small d-none d-sm-block">نمایش:</span>
                            <button class="btn btn-sm rounded-3 p-2 border {{ $viewMode === 'grid' ? 'btn-primary shadow-sm' : 'btn-outline-secondary' }}" title="نمای کارتی"
                                    wire:click="$set('viewMode', 'grid')">
                                <i class="ti ti-layout-grid fs-5"></i>
                            </button>
                            <button class="btn btn-sm rounded-3 p-2 border {{ $viewMode === 'list' ? 'btn-primary shadow-sm' : 'btn-outline-secondary' }}" title="نمای لیستی"
                                    wire:click="$set('viewMode', 'list')">
                                <i class="ti ti-list fs-5"></i>
                            </button>

                            <span class="text-muted small d-none d-sm-block me-2">مرتب‌سازی:</span>
                            <select wire:model.live="sortBy" class="form-select form-select-sm rounded-3 shadow-sm" style="width: auto; min-width: 150px;">
                                <option value="name_asc">نام (الف→ی)</option>
                                <option value="name_desc">نام (ی→الف)</option>
                                <option value="created_at_desc">جدیدترین</option>
                                <option value="created_at_asc">قدیمی‌ترین</option>
                            </select>
                            <select wire:model.live="perPage" class="form-select form-select-sm rounded-3 shadow-sm" style="width: auto; min-width: 80px;">
                                <option value="12">12</option>
                                <option value="24">24</option>
                                <option value="48">48</option>
                            </select>
                        </div>
                    </div>

                    {{-- 🎨 نمایش اصلی --}}
                    @if($viewMode === 'grid')
                        {{-- Grid View (کارت‌های مدرن) --}}
                        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                            @forelse($contacts->items() as $contact)
                                <div class="col" wire:key="c-{{ $contact->id }}">
                                    <div class="card h-100 border rounded-3 shadow-sm hover-lift grid-contact-card"
                                         style="border-left: 5px solid {{ $contact->group?->color ?? '#ddd' }};">
                                        <div class="card-body p-4">
                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                <div class="d-flex align-items-center gap-3">
                                                    <div class="form-check pt-1">
                                                        <input type="checkbox" class="form-check-input" wire:model="selectedContacts" value="{{ $contact->id }}">
                                                    </div>
                                                    <div class="flex-shrink-0">
                                                        <div class="rounded-circle d-flex align-items-center justify-content-center fw-bolder text-white"
                                                             style="width:56px;height:56px;font-size: 1.2rem; background-color:{{ $contact->avatar_color }};">
                                                            {{ $contact->initials }}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-icon btn-light rounded-circle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-end shadow-sm">
                                                        <li><a class="dropdown-item" href="{{ $contact->call_link }}"><i class="ti ti-phone-call me-2 text-success"></i> تماس</a></li>
                                                        <li><a class="dropdown-item" href="#" wire:click="openEditModal({{ $contact->id }})"><i class="ti ti-edit me-2"></i> ویرایش</a></li>
                                                        <li><hr class="dropdown-divider"></li>
                                                        <li><a class="dropdown-item text-danger" href="#" wire:click="openDeleteModal({{ $contact->id }})"><i class="ti ti-trash me-2"></i> حذف</a></li>
                                                    </ul>
                                                </div>
                                            </div>

                                            <h5 class="fw-bold mb-1 text-truncate">{{ $contact->display_name }}</h5>
                                            <div class="d-flex gap-2 flex-wrap mb-3">
                                                @if($contact->group)
                                                    <span class="badge rounded-pill border" style="background-color:{{ $contact->group->color }}1A; color:{{ $contact->group->color }}; border-color:{{ $contact->group->color }}50;">
                                                        {{ $contact->group->name }}
                                                    </span>
                                                @endif
                                                @if($contact->is_public)
                                                    <span class="badge rounded-pill bg-success-subtle text-success border border-success-subtle">عمومی</span>
                                                @endif
                                                <span class="badge rounded-pill bg-light text-muted border border-light-subtle">
                                                    <i class="ti ti-calendar-event me-1"></i> {{ $contact->jalali_created_at }}
                                                </span>
                                            </div>

                                            <div class="small text-dark pt-3 border-top">
                                                <div class="d-flex align-items-center mb-2">
                                                    <i class="ti ti-phone me-2 text-primary fs-5"></i>
                                                    <a href="{{ $contact->call_link }}" class="text-dark text-decoration-none fw-medium">{{ $contact->phone_number }}</a>
                                                    <span class="text-muted ms-2 badge bg-light rounded-pill">{{ $contact->phone_type_label }}</span>
                                                </div>
                                                @if($contact->email)
                                                    <div class="d-flex align-items-center mb-2"><i class="ti ti-mail me-2 text-info fs-5"></i> {{ $contact->email }}</div>
                                                @endif
                                                @if($contact->fax_number)
                                                    <div class="d-flex align-items-center mb-2"><i class="ti ti-printer me-2 text-secondary fs-5"></i> فکس: {{ $contact->fax_number }}</div>
                                                @endif
                                                @if($contact->address)
                                                    <div class="d-flex align-items-center mb-2 text-truncate"><i class="ti ti-map-pin me-2 text-muted fs-5"></i> {{ Str::limit($contact->address, 30) }}</div>
                                                @endif
                                                @if($hasTagsColumn && $contact->tags)
                                                    <div class="mt-2 pt-2 border-top tags-container">
                                                        @foreach(is_array($contact->tags) ? $contact->tags : explode(',', $contact->tags) as $tag)
                                                            <span class="badge bg-light text-dark border me-1 my-1 rounded-pill">{{ trim($tag) }}</span>
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 text-center py-5">
                                    <i class="ti ti-inbox-off fs-1 text-muted mb-3 d-block"></i>
                                    <p class="text-muted h6">مخاطبی با این معیارها یافت نشد.</p>
                                    <button class="btn btn-primary mt-3 rounded-3" wire:click="addContact">افزودن مخاطب جدید</button>
                                </div>
                            @endforelse
                        </div>
                    @else
                        {{-- List View (جدول مدرن) --}}
                        <div class="table-responsive">
                            <table class="table table-striped table-hover align-middle mb-0" style="min-width: 900px;">
                                <thead class="table-light">
                                <tr>
                                    <th style="width:40px">
                                        <input type="checkbox" wire:click="selectAllContacts">
                                    </th>
                                    <th>مخاطب</th>
                                    <th>شماره تماس</th>
                                    <th>فکس / ایمیل</th>
                                    <th>گروه</th>
                                    <th>تاریخ ایجاد</th>
                                    <th class="text-center" style="width:100px">عملیات</th>
                                </tr>
                                </thead>
                                <tbody>
                                @forelse($contacts->items() as $contact)
                                    <tr wire:key="l-{{ $contact->id }}"
                                        style="border-left: 3px solid {{ $contact->group?->color ?? '#eee' }};"
                                        class="@if(in_array($contact->id, $selectedContacts)) table-primary @endif">
                                        <td>
                                            <input type="checkbox" wire:model="selectedContacts" value="{{ $contact->id }}">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-3">
                                                <div class="rounded-circle d-flex align-items-center justify-content-center text-white fw-bold flex-shrink-0"
                                                     style="width:36px;height:36px;font-size:0.9rem;background-color:{{ $contact->avatar_color }};">
                                                    {{ $contact->initials }}
                                                </div>
                                                <div>
                                                    <span class="fw-medium text-dark d-block text-truncate">{{ $contact->display_name }}</span>
                                                    @if($contact->is_public)
                                                        <span class="badge bg-success-subtle text-success border border-success-subtle mt-1">عمومی</span>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <a href="{{ $contact->call_link }}" class="text-dark text-decoration-none d-block fw-medium">
                                                {{ $contact->phone_number }}
                                            </a>
                                            <small class="text-muted">{{ $contact->phone_type_label }}</small>
                                        </td>
                                        <td>
                                            @if($contact->email)
                                                <a href="mailto:{{ $contact->email }}" class="text-info text-decoration-none text-truncate d-block">
                                                    <small><i class="ti ti-mail me-1"></i> {{ $contact->email }}</small>
                                                </a>
                                            @endif
                                            @if($contact->fax_number)
                                                <div><small class="text-secondary"><i class="ti ti-printer me-1"></i> {{ $contact->fax_number }}</small></div>
                                            @endif
                                        </td>
                                        <td>
                                            @if($contact->group)
                                                <span class="badge rounded-pill border"
                                                      style="background-color: {{ $contact->group->color }}1A; color: {{ $contact->group->color }}; border-color: {{ $contact->group->color }}50;">
                                                    {{ $contact->group->name }}
                                                </span>
                                            @else
                                                <span class="text-muted">—</span>
                                            @endif
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $contact->jalali_created_at }}</small>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-sm btn-outline-secondary rounded-3 p-2 border-0" wire:click="openEditModal({{ $contact->id }})" title="ویرایش">
                                                    <i class="ti ti-edit"></i>
                                                </button>
                                                <button class="btn btn-sm btn-outline-danger rounded-3 p-2 border-0" wire:click="openDeleteModal({{ $contact->id }})" title="حذف">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-5 text-muted">
                                            <i class="ti ti-inbox-off fs-1 text-muted mb-3 d-block"></i>
                                            <p class="mb-2 h6">مخاطبی با فیلترهای فعلی یافت نشد.</p>
                                            <button class="btn btn-primary btn-sm rounded-3 mt-2" wire:click="addContact">افزودن مخاطب جدید</button>
                                        </td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    @endif


                    {{-- 📄 Pagination --}}
                    <div class="mt-4 d-flex justify-content-center">
                        {{ $contacts->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- 📄 Modals (بدون تغییر) --}}
    @include('livewire.admin.contact.modals.add-contact')
    @include('livewire.admin.contact.modals.edit-contact')
    @include('livewire.admin.contact.modals.delete-contact')
    @include('livewire.admin.contact.modals.add-group')
    @include('livewire.admin.contact.modals.edit-group')
    @include('livewire.admin.contact.modals.delete-group')
    @include('livewire.admin.contact.modals.export')
    @include('livewire.admin.contact.modals.import')

    {{-- 🎨 استایل‌ها --}}
    <style>

        /* فونت و پس‌زمینه اصلی */
        * { font-family: 'Vazir', 'Segoe UI', system-ui, sans-serif !important; }
        body { background-color: #f8fafc !important; }
        .card { border: 1px solid var(--border-color); background-color: var(--card-bg); border-radius: 0.75rem !important; }

        /* دکمه‌ها و افکت‌ها */
        .btn { transition: all 0.2s ease; font-weight: 500; }
        .btn-primary {
            background-color: var(--action-color) !important;
            border-color: var(--action-color) !important;
            color: white !important;
        }
        .btn-outline-primary {
            color: var(--action-color) !important;
            border-color: var(--action-color) !important;
        }
        .btn-outline-primary:hover {
            background-color: var(--action-color);
            color: white !important;
        }

        /* افکت‌های مینیمال */
        .hover-lift:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px -5px rgba(0,0,0,0.06) !important;
        }

        /* نوار کناری و گروه‌ها */
        .sticky-top {
            position: sticky;
            top: 20px; /* کمتر شد تا زیر نویگیشن نرود */
            z-index: 5;
        }

        /* لیست گروه‌ها برای بهبود UX */
        .custom-group-list .list-group-item {
            padding-left: 0.5rem !important;
            cursor: pointer;
            transition: background-color 0.2s, box-shadow 0.2s;
        }
        .active-group-shadow {
            box-shadow: 0 4px 10px -2px rgba(79, 70, 229, 0.1);
        }
        .active-group-btn:hover {
            background-color: #f3f4f6 !important;
        }
        .active-group-btn.bg-primary-subtle:hover {
            background-color: var(--action-color-light) !important;
        }
        .hover-icon-primary:hover { color: var(--action-color) !important; }
        .hover-icon-danger:hover { color: var(--danger-color) !important; }


        /* رنگ‌های سفارشی */
        .bg-success-subtle {
            background-color: rgba(16, 185, 129, 0.1) !important;
        }
        .bg-primary-subtle {
            background-color: var(--action-color-light) !important;
        }

        /* جداول */
        .table > :not(caption) > * > * { padding: 1rem 0.75rem; }
        .table-striped > tbody > tr:nth-of-type(odd) > * {
            --bs-table-bg-type: #f9fafb; /* رنگ روشن‌تر برای خطوط فرد */
        }
        .table-primary { --bs-table-bg: var(--action-color-light); }
        .table-hover > tbody > tr:hover > * {
            --bs-table-hover-bg: #f5f5f5;
        }

        /* نوار Bulk Action */
        .animated-bulk-bar {
            animation: fadeInDown 0.3s ease-out;
        }
        @keyframes fadeInDown {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

    </style>

    {{-- 📦 اسکریپت‌ها (بدون تغییر) --}}
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof flatpickr !== 'undefined') {
                flatpickr.localize(flatpickr.l10ns.fa);
            }
            var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'))
            var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
                return new bootstrap.Dropdown(dropdownToggleEl)
            });
        });
    </script>
</div>
