@if($showAddContactModal)
    {{-- 💡 از یک کلاس CSS برای پایداری و انیمیشن بهتر استفاده می‌کنیم --}}
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" x-data>
        <div class="modal-dialog modal-lg modal-dialog-centered"> {{-- ⬅️ استفاده از modal-lg برای فیلدهای بیشتر --}}
            <div class="modal-content rounded-3 border-0 shadow-lg">
                <div class="modal-header bg-primary text-white border-bottom-0 rounded-top-3 p-4">
                    <h5 class="modal-title fw-bolder d-flex align-items-center">
                        <i class="ti ti-user-plus me-2 fs-4"></i>
                        افزودن مخاطب جدید
                    </h5>
                    <button type="button" class="btn-close btn-close-white opacity-100" aria-label="بستن"
                            wire:click="closeAddContactModal"></button>
                </div>

                <form wire:submit.prevent="saveContact">
                    <div class="modal-body p-4">
                        <div class="row g-3"> {{-- ⬅️ استفاده از Grid برای چیدمان دو ستونی --}}

                            {{-- ستون چپ --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">نام کامل</label>
                                    <input type="text" wire:model.defer="newContactName" class="form-control rounded-3" placeholder="نام و نام خانوادگی">
                                    @error('newContactName') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold d-flex justify-content-between align-items-center">
                                        شماره تلفن <i class="ti ti-phone text-primary me-1"></i>
                                    </label>
                                    <input type="text" wire:model.live.debounce.300ms="newContactPhone" class="form-control rounded-3" placeholder="مثلاً: 0912xxxxxxx">
                                    @error('newContactPhone') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">نوع تماس</label>
                                    {{-- 💡 مدل اصلاح شد: newContactPhoneType --}}
                                    <select wire:model.defer="newContactPhoneType" class="form-select rounded-3">
                                        <option value="mobile">تلفن همراه</option>
                                        <option value="work">شماره کاری</option>
                                        <option value="home">تلفن منزل</option>
                                        <option value="internal">داخلی</option>
                                        <option value="fax">فکس</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">گروه</label>
                                    {{-- 💡 مدل اصلاح شد: newContactGroup --}}
                                    <select wire:model.defer="newContactGroup" class="form-select rounded-3">
                                        <option value="">— بدون گروه —</option>
                                        @foreach($contactGroups as $group)
                                            <option value="{{ $group->id }}">{{ $group->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            {{-- ستون راست --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">ایمیل (اختیاری)</label>
                                    <input type="email" wire:model.defer="newContactEmail" class="form-control rounded-3" placeholder="example@domain.com">
                                    @error('newContactEmail') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">فکس (اختیاری)</label>
                                    <input type="text" wire:model.defer="newContactFax" class="form-control rounded-3" placeholder="021-12345678">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label fw-bold">آدرس (اختیاری)</label>
                                    <textarea wire:model.defer="newContactAddress" class="form-control rounded-3" rows="3" placeholder="آدرس کامل..."></textarea>
                                </div>

                                @if($hasTagsColumn)
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">برچسب‌ها</label>
                                        {{-- 💡 از مدل Livewire برای کامپوننت tagsinput یا مشابه استفاده کنید --}}
                                        <input type="text" wire:model.defer="newContactTags" class="form-control rounded-3" placeholder="با کاما جدا کنید (مثلاً: مشتری، مهم)">
                                    </div>
                                @endif

                                <div class="mb-3 form-check form-switch pt-2">
                                    <input type="checkbox" wire:model.defer="newContactIsPublic" id="isPublic" class="form-check-input bg-primary border-primary">
                                    <label class="form-check-label fw-bold text-muted" for="isPublic">
                                        {{-- 💡 بهبود متن: مخاطب عمومی (همه می‌توانند ببینند) --}}
                                        این مخاطب را به صورت عمومی ثبت کن
                                    </label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeAddContactModal">انصراف</button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 fw-bold" wire:loading.attr="disabled">
                            <span wire:loading.remove>ذخیره مخاطب</span>
                            <span wire:loading>... در حال ذخیره</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endif
