@if($showAddGroupModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" x-data>
        <div class="modal-dialog modal-sm modal-dialog-centered"> {{-- ⬅️ استفاده از modal-sm برای تمرکز بر فیلدهای کم --}}
            <div class="modal-content rounded-3 border-0 shadow-lg">

                {{-- هدر با پدینگ و آیکون جذاب --}}
                <div class="modal-header bg-primary text-white border-bottom-0 rounded-top-3 p-4">
                    <h5 class="modal-title fw-bolder d-flex align-items-center">
                        <i class="ti ti-folder-plus me-2 fs-4"></i>
                        ایجاد گروه جدید
                    </h5>
                    <button type="button" class="btn-close btn-close-white opacity-100" aria-label="بستن"
                            wire:click="closeAddGroupModal"></button>
                </div>

                <form wire:submit.prevent="saveGroup">
                    <div class="modal-body p-4">

                        {{-- فیلد نام گروه --}}
                        <div class="mb-3">
                            <label class="form-label fw-bold">نام گروه</label>
                            <input type="text" wire:model.defer="newGroupName" class="form-control rounded-3"
                                   placeholder="مثلاً: دوستان، همکاران...">
                            @error('newGroupName') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        @if($hasColorColumn)
                            {{-- فیلد انتخاب رنگ (بهبود یافته) --}}
                            <div class="mb-3">
                                <label class="form-label fw-bold d-flex justify-content-between align-items-center">
                                    رنگ گروه (انتخابگر هگز)
                                    <span class="badge" style="background-color: {{ $newGroupColor }}; color: {{ $newGroupColor }}; border: 1px solid #ccc;">&nbsp;</span>
                                </label>

                                <div class="input-group">
                                    {{-- ⬅️ نمایش مقدار هگز در فیلد متنی --}}
                                    <span class="input-group-text rounded-start-3 text-muted">#</span>
                                    <input type="text" wire:model.defer="newGroupColor" class="form-control"
                                           placeholder="#4361EE" maxlength="7" style="direction: ltr; text-align: left;">

                                    {{-- ⬅️ انتخابگر رنگ کوچک‌تر و متمرکز --}}
                                    <input type="color" wire:model.live="newGroupColor"
                                           class="form-control form-control-color" style="width: 50px; min-width: 50px;"
                                           title="انتخاب رنگ">
                                </div>
                                @error('newGroupColor') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>
                        @endif

                    </div>

                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeAddGroupModal">انصراف</button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 fw-bold" wire:loading.attr="disabled">
                            <span wire:loading.remove>ایجاد گروه</span>
                            <span wire:loading>... در حال ایجاد</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endif
