<div class="modal fade" id="editGroupModal" tabindex="-1" aria-labelledby="editGroupModalLabel" aria-hidden="true" wire:ignore.self
     x-data="{ isModalOpen: @entangle('showEditGroupModal') }"
     x-init="$watch('isModalOpen', value => {
        if (value) { $('#editGroupModal').modal('show'); } else { $('#editGroupModal').modal('hide'); }
    })"
     @keydown.escape.window="isModalOpen = false"
>
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editGroupModalLabel">
                    <i class="ti ti-folder-edit me-2"></i> ویرایش گروه
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeEditGroupModal" aria-label="بستن"></button>
            </div>
            <form wire:submit.prevent="updateGroup">
                <div class="modal-body">

                    {{-- شناسه گروه --}}
                    <input type="hidden" wire:model="editGroupId">

                    {{-- نام گروه --}}
                    <div class="mb-3">
                        <label for="editGroupName" class="form-label fw-medium">نام گروه</label>
                        <input type="text" class="form-control @error('editGroupName') is-invalid @enderror" id="editGroupName" wire:model.defer="editGroupName" placeholder="مثال: همکاران، مشتریان">
                        @error('editGroupName') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    {{-- انتخاب رنگ (به شرط وجود ستون color) --}}
                    @if($hasColorColumn)
                        <div class="mb-3">
                            <label for="editGroupColor" class="form-label fw-medium d-block">رنگ گروه</label>
                            <div class="d-flex align-items-center gap-3">
                                <input type="color" class="form-control form-control-color border border-secondary rounded" id="editGroupColor" wire:model.defer="editGroupColor" title="انتخاب رنگ">
                                <span class="text-muted small">برای تمایز در فیلترها</span>
                            </div>
                            @error('editGroupColor') <small class="text-danger d-block mt-1">{{ $message }}</small> @enderror
                        </div>
                    @endif

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary" wire:click="closeEditGroupModal">انصراف</button>
                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                        <span wire:loading.remove>ذخیره تغییرات</span>
                        <span wire:loading><i class="ti ti-loader animate-spin"></i> در حال ذخیره...</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
