@if($showImportModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" x-data>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content rounded-3 border-0 shadow-lg">

                {{-- هدر مدرن --}}
                <div class="modal-header bg-primary text-white border-bottom-0 rounded-top-3 p-4">
                    <h5 class="modal-title fw-bolder d-flex align-items-center">
                        <i class="ti ti-upload me-2 fs-4"></i>
                        وارد کردن مخاطبین جدید
                    </h5>
                    <button type="button" class="btn-close btn-close-white opacity-100" aria-label="بستن"
                            wire:click="closeImportModal"></button>
                </div>

                <form wire:submit.prevent="importContacts">
                    <div class="modal-body p-4">

                        <h6 class="fw-bold mb-3">انتخاب فایل</h6>

                        {{-- فیلد آپلود فایل --}}
                        <div class="mb-3">
                            <label class="form-label fw-bold">فرمت‌های مجاز: CSV، JSON یا VCF (حداکثر ۲ مگابایت)</label>
                            <input type="file" wire:model="importFile" class="form-control rounded-3">

                            {{-- نمایش خطای اعتبارسنجی --}}
                            @error('importFile') <div class="text-danger small mt-1">{{ $message }}</div> @enderror

                            {{-- نمایش وضعیت بارگذاری فایل --}}
                            <div wire:loading wire:target="importFile" class="text-info small mt-2 d-flex align-items-center">
                                <i class="ti ti-loader ti-spin me-1"></i>
                                در حال بارگذاری فایل...
                            </div>
                        </div>

                        {{-- راهنمای فرمت‌ها --}}
                        <div class="alert alert-secondary border-start border-3 border-secondary p-3 small mt-4">
                            <p class="fw-bold text-dark mb-2">راهنمای فرمت‌های ورودی:</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="ti ti-check me-1 text-success"></i> **VCF/vCard:** بهترین گزینه، استاندارد جهانی تبادل مخاطبین است.</li>
                                <li><i class="ti ti-check me-1 text-success"></i> **CSV:** باید شامل ستون‌های سربرگ (مانند: `نام، شماره تلفن، ایمیل، گروه`) باشد.</li>
                                <li><i class="ti ti-check me-1 text-success"></i> **JSON:** باید یک آرایه از آبجکت‌ها باشد که شامل فیلد `phone_number` است.</li>
                            </ul>
                            <small class="text-muted d-block mt-2">توجه: در صورت وجود شماره تکراری، آن مخاطب نادیده گرفته می‌شود.</small>
                        </div>
                    </div>

                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeImportModal">انصراف</button>

                        {{-- دکمه Import با نمایش سه وضعیت مختلف --}}
                        <button type="submit" class="btn btn-primary rounded-pill px-4 fw-bold"
                                wire:loading.attr="disabled"
                                wire:target="importContacts, importFile">

                            <span wire:loading.remove wire:target="importContacts">
                                <i class="ti ti-file-import me-1"></i> شروع وارد کردن
                            </span>

                            <span wire:loading wire:target="importContacts">
                                <i class="ti ti-loader ti-spin me-1"></i> در حال پردازش و ذخیره...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endif
