<div>
    <div class="modal fade show d-block"
         tabindex="-1" role="dialog" aria-modal="true" aria-labelledby="membersModalTitle"
         wire:click.self="closeModals"
         wire:keydown.escape.window="closeModals"
         style="background-color: rgba(0,0,0,0.6); display:block;">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content rounded-4 shadow-lg modal-user-manager">
                <div class="modal-header bg-action-primary text-white rounded-top-4 p-4">
                    <h5 id="membersModalTitle" class="modal-title d-flex align-items-center">
                        <i class="ti ti-users me-2"></i>
                        مدیریت اعضای دپارتمان:
                        <span class="fw-bold ms-2 text-warning-contrast">{{ $department->name }}</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white"
                            wire:click="closeModals"
                            aria-label="بستن"></button>
                </div>

                <div class="modal-body p-5 bg-light-soft">
                    <div class="row g-4">

                        {{-- 🛑 پنل ۱: اعضای فعلی دپارتمان --}}
                        <div class="col-md-6">
                            <div class="panel-card-header bg-primary-light border-primary-light">
                                <label class="form-label fw-bold m-0 text-dark-primary">
                                    اعضای فعلی
                                    <span class="badge bg-soft-secondary text-secondary ms-2">{{ $currentUsers->total() }}</span>
                                </label>

                                {{-- Controls --}}
                                <div class="d-flex align-items-center gap-2">
                                    <div class="form-check m-0 small">
                                        <input class="form-check-input" type="checkbox"
                                               wire:click="toggleSelectAllCurrentPage"
                                            @checked(collect($currentUsers->getCollection()->pluck('id')->map(fn($i)=>(string)$i)->all())->every(fn($id)=> in_array($id, $selectedCurrent)))>
                                        <label class="form-check-label small">انتخاب</label>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-danger rounded-pill"
                                            wire:click="removeSelected" wire:loading.attr="disabled" title="حذف انتخابی">
                                        <span wire:loading.remove wire:target="removeSelected"><i class="ti ti-trash"></i> حذف ({{ count($selectedCurrent) }})</span>
                                        <span wire:loading wire:target="removeSelected"><i class="ti ti-loader animate-spin"></i></span>
                                    </button>
                                </div>
                            </div>

                            <div class="input-group mb-2 shadow-sm rounded-pill overflow-hidden">
                                <span class="input-group-text bg-white"><i class="ti ti-search text-muted"></i></span>
                                <input id="search-current" type="text" class="form-control border-0"
                                       placeholder="جستجو در اعضای دپارتمان..."
                                       wire:model.live.debounce.300ms="searchCurrent">
                            </div>

                            <div class="list-pane border rounded-3 bg-white shadow-inner user-list-container" style="max-height: 370px; overflow-y: auto;">

                                @forelse($currentUsers as $user)
                                    <div class="form-check user-row mb-2 py-2 px-2 border rounded-3 bg-white user-row-item" wire:key="current-{{ $user->id }}">
                                        <input class="form-check-input"
                                               type="checkbox"
                                               value="{{ $user->id }}"
                                               wire:model="selectedCurrent"
                                               id="curuser{{ $user->id }}"
                                               @if($department->manager_id == $user->id) disabled @endif>
                                        <label class="form-check-label d-flex align-items-center w-100 gap-2 py-1" for="curuser{{ $user->id }}">
                                            @if($user->image)
                                                <img src="{{ Storage::disk('public')->url($user->image) }}"
                                                     class="rounded-circle border avatar-ring"
                                                     width="32" height="32" style="object-fit: cover;" alt="{{ $user->name }}">
                                            @else
                                                <span class="rounded-circle bg-secondary text-white d-inline-flex align-items-center justify-content-center avatar-ring avatar-fallback"
                                                      style="width:32px;height:32px;">
                                                {{ strtoupper(mb_substr($user->name,0,1)) }}
                                            </span>
                                            @endif

                                            <span class="me-2 text-dark-primary">{{ $user->name }}</span>

                                            @if($department->manager_id == $user->id)
                                                <span class="manager-badge ms-auto">مدیر دپارتمان</span>
                                            @endif
                                        </label>
                                    </div>
                                @empty
                                    <div class="text-muted text-center py-4">عضوی در این دپارتمان ثبت نشده است.</div>
                                @endforelse
                            </div>

                            <div class="mt-2">{{ $currentUsers->links() }}</div>
                        </div>

                        {{-- 🛑 پنل ۲: کاربران موجود برای افزودن --}}
                        <div class="col-md-6">
                            <div class="panel-card-header bg-soft-success border-success">
                                <label class="form-label fw-bold m-0 text-dark-primary">
                                    کاربران موجود (همین شرکت)
                                    <span class="badge bg-soft-success text-success ms-2">{{ $availableUsers->total() }}</span>
                                </label>

                                {{-- Controls --}}
                                <div class="d-flex align-items-center gap-2">
                                    <div class="form-check m-0 small">
                                        <input class="form-check-input" type="checkbox"
                                               wire:click="toggleSelectAllAvailablePage"
                                            @checked(collect($availableUsers->getCollection()->pluck('id')->map(fn($i)=>(string)$i)->all())->every(fn($id)=> in_array($id, $selectedAvailable)))>
                                        <label class="form-check-label small">انتخاب</label>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-success rounded-pill"
                                            wire:click="addSelected" wire:loading.attr="disabled" title="افزودن انتخابی">
                                        <span wire:loading.remove wire:target="addSelected"><i class="ti ti-plus"></i> افزودن ({{ count($selectedAvailable) }})</span>
                                        <span wire:loading wire:target="addSelected"><i class="ti ti-loader animate-spin"></i></span>
                                    </button>
                                </div>
                            </div>

                            <div class="input-group mb-2 shadow-sm rounded-pill overflow-hidden">
                                <span class="input-group-text bg-white"><i class="ti ti-search text-muted"></i></span>
                                <input id="search-available" type="text" class="form-control border-0"
                                       placeholder="جستجو در کاربران خارج دپارتمان..."
                                       wire:model.live.debounce.300ms="searchAvailable">
                            </div>

                            <div class="list-pane border rounded-3 bg-white shadow-inner user-list-container" style="max-height: 370px; overflow-y: auto;">

                                @forelse($availableUsers as $user)
                                    <div class="form-check user-row mb-2 py-2 px-2 border rounded-3 bg-white user-row-item" wire:key="avail-{{ $user->id }}">
                                        <input class="form-check-input"
                                               type="checkbox"
                                               value="{{ $user->id }}"
                                               wire:model="selectedAvailable"
                                               id="availuser{{ $user->id }}">
                                        <label class="form-check-label d-flex align-items-center w-100 gap-2 py-1" for="availuser{{ $user->id }}">
                                            @if($user->image)
                                                <img src="{{ Storage::disk('public')->url($user->image) }}"
                                                     class="rounded-circle border border-light-subtle"
                                                     width="40" height="40" style="object-fit: cover;" alt="{{ $user->name }}">
                                            @else
                                                <span class="rounded-circle bg-secondary-subtle text-secondary d-inline-flex align-items-center justify-content-center"
                                                      style="width:40px;height:40px;font-size:0.875rem;font-weight:600;">
                                                        {{ strtoupper(mb_substr($user->name, 0, 1)) }}
                                                    </span>
                                            @endif



                                            <span class="me-2 text-dark-primary">{{ $user->name }}</span>

                                            @if($user->company_id !== $department->company_id)
                                                <small class="text-danger ms-auto">(خارج از شرکت)</small>
                                            @else
                                                <small class="text-muted ms-auto">({{ $user->department_id ? 'در دپارتمان دیگر' : 'بدون دپارتمان' }})</small>
                                            @endif
                                        </label>
                                    </div>
                                @empty
                                    <div class="text-muted text-center py-4">کاربری جهت افزودن در این شرکت وجود ندارد.</div>
                                @endforelse
                                @if ($availableUsers->hasPages())
                                    <div class="text-center mt-3">{{ $availableUsers->links('pagination::bootstrap') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0 pt-0 bg-white">
                    <button type="button" class="btn btn-secondary px-4 rounded-pill"
                            wire:click="closeModals">بستن</button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            // 💡 مدیریت فوکوس با میانبرهای کیبورد (از طرح قبلی)
            document.addEventListener('keydown', (e) => {
                const inField = e.target.matches('input,textarea');
                if (e.key === '/' && !inField) {
                    e.preventDefault();
                    document.getElementById('search-current')?.focus();
                }
                if ((e.ctrlKey || e.metaKey) && e.key.toLowerCase() === 'k') {
                    e.preventDefault();
                    document.getElementById('search-available')?.focus();
                }
            });
        </script>
    @endpush

    <style>
        /* --- General Variables --- */
        :root {
            --action-color: #4361EE;
            --success-color: #10B981;
            --danger-color: #EF4444;
            --primary-dark: #1A2538;
            --border-color: #E5E7EB;
            --primary-light: #EEF4FF; /* Soft background */
            --dark-primary: #1F2937;
            --secondary-light: #6B7280;
            --gray-light: #F1F5F9;
            --warning-contrast: #FDE88F;
        }

        /* --- Modal Base --- */
        .modal-user-manager { border-radius: 1rem; }
        .bg-action-primary { background-color: var(--action-color) !important; }
        .text-action-primary { color: var(--action-color) !important; }
        .text-dark-primary { color: var(--primary-dark) !important; }
        .bg-light-soft { background-color: var(--bg-light-soft) !important; }
        .text-secondary-light { color: var(--secondary-light) !important; }
        .btn-close-white { filter: invert(1); }

        /* --- Dual Pane Design --- */
        .panel-card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem;
            margin-bottom: 1rem;
            border-radius: 0.5rem;
            font-size: 1.1rem;
            font-weight: 600;
            border: 1px solid transparent;
        }
        .panel-card-header.bg-primary-light {
            background-color: var(--primary-light) !important;
            border-color: rgba(67, 97, 238, 0.2);
        }
        .panel-card-header.bg-soft-success {
            background-color: rgba(16, 185, 129, 0.1);
            border-color: rgba(16, 185, 129, 0.4);
        }

        /* --- User Row Item --- */
        .user-row-item {
            cursor: pointer;
            transition: .15s ease;
            border: 1px solid var(--border-color) !important;
            background-color: white !important;
            padding: 0.75rem 1rem !important;
            border-radius: 0.5rem !important;
        }
        .user-row-item:hover {
            box-shadow: 0 2px 10px rgba(0,0,0,.05);
            transform: translateY(-1px);
            background-color: var(--primary-light) !important;
        }

        /* Input Search */
        .input-group input:focus {
            border-color: var(--action-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
        }

        /* Checkbox Fix */
        .form-check-input {
            margin-top: .6rem;
        }

        /* Avatar & Badges */
        .avatar-ring::after{
            content:""; position:absolute; inset:-2px; border-radius:50%;
            border:2px solid rgba(13,110,253,.5);
        }
        .manager-badge {
            font-size:.72rem; padding:.15rem .5rem; border-radius: 999px;
            background: linear-gradient(90deg,#6366f1,#22d3ee); color:#fff;
            flex-shrink: 0;
        }

        /* Buttons */
        .btn-outline-success { color: var(--success-color); border-color: var(--success-color); }
        .btn-outline-success:hover { background-color: var(--success-color); color: white; }
        .btn-outline-danger { color: var(--danger-color); border-color: var(--danger-color); }
    </style>
</div>
