<div class="container-fluid px-4 py-4 department-management-page">

    @if(session()->has('success'))
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4 rounded-3 shadow-sm" role="alert">
            <i class="ti ti-check-circle me-2 text-success"></i>
            <strong>انجام شد!</strong> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @error('delete')
    <div class="alert alert-warning alert-dismissible fade show d-flex align-items-center mb-4 rounded-3 shadow-sm" role="alert">
        <i class="ti ti-exclamation-triangle me-2 text-warning"></i>
        <strong>هشدار!</strong> {{ $message }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @enderror

    <div class="row g-4">

        {{-- 🛑 ستون ۱: فرم ایجاد/ویرایش دپارتمان (Sticky Form) --}}
        <div class="col-lg-4">
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden sticky-lg-top" style="top: 15px;">
                <div class="card-header bg-primary-header text-white py-3 px-4">
                    <h5 class="mb-0 fw-bold d-flex align-items-center">
                        <i class="ti ti-building me-2"></i>
                        {{ $editMode ? 'ویرایش دپارتمان: ' . Str::limit($name, 15) : 'ایجاد دپارتمان جدید' }}
                    </h5>
                    @if($editMode)
                        <button type="button" class="btn btn-sm btn-outline-light rounded-pill ms-auto" wire:click="resetForm">
                            <i class="ti ti-x"></i> انصراف
                        </button>
                    @endif
                </div>
                <div class="card-body p-4">
                    <form wire:submit.prevent="save" class="row g-4">
                        <div class="col-12">
                            <label class="form-label fw-semibold">شرکت <span class="text-danger">*</span></label>
                            <select class="form-select form-select-lg rounded-pill @error('company_id') is-invalid @enderror"
                                    wire:model.live="company_id" @disabled($editMode)>
                                <option value="">انتخاب کنید...</option>
                                @foreach($companiesList as $comp)
                                    <option value="{{ $comp->id }}">{{ $comp->name }}</option>
                                @endforeach
                            </select>
                            @error('company_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-semibold">نام دپارتمان <span class="text-danger">*</span></label>
                            <input type="text"
                                   class="form-control form-control-lg rounded-pill @error('name') is-invalid @enderror"
                                   wire:model.defer="name"
                                   placeholder="مدیریت فنی">
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">کُد (اختیاری)</label>
                            <input type="text"
                                   class="form-control form-control-lg rounded-pill @error('code') is-invalid @enderror"
                                   wire:model.defer="code"
                                   placeholder="HR, FIN, TECH">
                            @error('code') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label fw-semibold">ترتیب نمایش</label>
                            <input type="number"
                                   class="form-control form-control-lg rounded-pill"
                                   wire:model.defer="sort_order"
                                   min="0">
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-semibold">والد (اختیاری)</label>
                            <select class="form-select form-select-lg rounded-pill @error('parent_id') is-invalid @enderror"
                                    wire:model.defer="parent_id" @disabled(!$company_id || $editMode && $parentsList->isEmpty())>
                                <option value="">— بدون والد —</option>
                                @foreach($parentsList as $p)
                                    <option value="{{ $p->id }}">{{ $p->name }}</option>
                                @endforeach
                            </select>
                            @error('parent_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-semibold">مدیر دپارتمان (اختیاری)</label>
                            <select class="form-select form-select-lg rounded-pill" wire:model.defer="manager_id">
                                <option value="">— انتخاب مدیر —</option>
                                @foreach($managersList as $m)
                                    <option value="{{ $m->id }}">{{ $m->name }} ({{ $m->email }})</option>
                                @endforeach
                            </select>
                            @error('manager_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                        </div>

                        {{-- وضعیت و رنگ --}}
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">وضعیت</label>
                            <select class="form-select form-select-lg rounded-pill" wire:model.defer="status">
                                <option value="active">فعال</option>
                                <option value="inactive">غیرفعال</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">رنگ (اختیاری)</label>
                            <input type="text"
                                   class="form-control form-control-lg rounded-pill @error('color') is-invalid @enderror"
                                   wire:model.defer="color"
                                   placeholder="#0ea5e9">
                        </div>

                        <div class="col-12">
                            <label class="form-label fw-semibold">توضیحات</label>
                            <textarea class="form-control rounded-3" rows="2"
                                      wire:model.defer="description"
                                      placeholder="شرح دپارتمان..."></textarea>
                        </div>

                        <div class="col-12 mt-4 d-flex justify-content-end gap-3 border-top pt-3">
                            @if($editMode)
                                <button type="submit"
                                        class="btn btn-warning px-4 py-2 rounded-pill shadow-btn-warning"
                                        wire:loading.attr="disabled">
                                    <span wire:loading.remove><i class="ti ti-device-floppy"></i> ذخیره تغییرات</span>
                                    <span wire:loading><i class="ti ti-loader animate-spin"></i> در حال ذخیره...</span>
                                </button>
                            @else
                                <button type="button"
                                        class="btn btn-outline-secondary px-4 py-2 rounded-pill"
                                        wire:click="resetForm">
                                    <i class="ti ti-refresh"></i> پاک کردن
                                </button>
                                <button type="submit"
                                        class="btn btn-action-primary px-4 py-2 rounded-pill shadow-btn-primary"
                                        wire:loading.attr="disabled">
                                    <span wire:loading.remove><i class="ti ti-plus-circle"></i> ایجاد دپارتمان</span>
                                    <span wire:loading><i class="ti ti-loader animate-spin"></i> در حال ایجاد...</span>
                                </button>
                            @endif
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- 🛑 ستون ۲: درخت ساختار و فیلترها --}}
        <div class="col-lg-8">

            <div class="card border-0 shadow-sm rounded-4 mb-4">
                <div class="card-body p-4">
                    <h6 class="fw-bold text-dark-primary mb-3"><i class="ti ti-filter me-2 text-primary"></i> فیلتر و جستجو</h6>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">فیلتر شرکت</label>
                            <select class="form-select rounded-pill" wire:model.live="filter_company_id">
                                <option value="">همه شرکت‌ها</option>
                                @foreach($companiesList as $comp)
                                    <option value="{{ $comp->id }}">{{ $comp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">جستجو</label>
                            <input type="text"
                                   class="form-control rounded-pill"
                                   placeholder="نام، کُد یا شرکت..."
                                   wire:model.live.debounce.500ms="search">
                        </div>
                    </div>
                </div>
            </div>

            <div class="accordion" id="departmentsAccordion">
                @forelse($treeByCompany as $item)
                    <div class="accordion-item mb-3 border-0 shadow-md rounded-3 overflow-hidden tree-accordion-item">
                        <h2 class="accordion-header" id="heading-{{ $item['company']->id }}">
                            <button class="accordion-button bg-light-soft text-dark fw-bold d-flex align-items-center"
                                    type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#collapse-{{ $item['company']->id }}"
                                    aria-expanded="true"
                                    aria-controls="collapse-{{ $item['company']->id }}">
                                <i class="ti ti-building me-2 text-action-primary"></i>
                                {{ $item['company']->name }}
                                <span class="badge bg-soft-primary text-action-primary ms-2 fw-medium">
                                    {{ $item['tree']->sum('users_count') }} عضو
                                </span>
                            </button>
                        </h2>
                        <div id="collapse-{{ $item['company']->id }}"
                             class="accordion-collapse collapse show"
                             data-bs-parent="#departmentsAccordion">
                            <div class="accordion-body p-3 bg-white">
                                {{-- 💡 رندر بازگشتی گره‌ها --}}
                                @include('livewire.admin.departments.tree-node', ['nodes' => $item['tree'], 'depth' => 0])
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="alert alert-light text-center py-5">
                        <i class="ti ti-building fa-2x opacity-50 mb-3"></i><br>
                        <strong>هیچ دپارتمانی یافت نشد.</strong>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    @if(isset($showMembersModal) && $showMembersModal)
        @teleport('body')
        @livewire('admin.departments.manage-members', ['departmentId' => $showMembersModal], key('manage-members-'.$showMembersModal))
        @endteleport
    @endif

        <style>
            /* --- General Variables --- */
            :root {
                --action-color: #4361EE;
                --action-dark-hover: #3A4FCD;
                --primary-dark-table: #1A2538;
                --bg-light-soft: #F4F7F9;
                --success-color: #10B981;
                --danger-color: #EF4444;
                --info-color: #3498DB;
                --warning-color: #F59E0B;
                --border-color: #E5E7EB;
                --primary-light: #EEF4FF;
                --dark-primary: #1F2937;
                --secondary-light: #6B7280;
            }

            /* --- Base Aesthetics --- */
            .text-dark-primary { color: var(--dark-primary) !important; }
            .text-action-primary { color: var(--action-color) !important; }
            .fw-bold { font-weight: 700; }
            .card { border-radius: 1rem; }
            .shadow-lg { box-shadow: 0 10px 25px rgba(0,0,0,0.15); }
            .hover-grow:hover { transform: translateY(-2px) scale(1.02); }

            /* --- Header & Form Card --- */
            .bg-primary-header { background: linear-gradient(90deg, #1A2538, #304159); color: white; }
            .shadow-btn-primary { box-shadow: 0 4px 12px rgba(67, 97, 238, 0.3); }
            .shadow-btn-warning { box-shadow: 0 4px 12px rgba(245, 158, 11, 0.4); }

            /* --- Input Customization --- */
            .form-control, .form-select { border-radius: 50rem !important; }
            .form-control:focus { box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15); }

            /* --- Tree View Styles (Accordion) --- */
            .bg-light-soft { background-color: var(--bg-light-soft) !important; }
            .accordion-button {
                padding: 1rem 1.25rem;
                border-bottom: 1px solid var(--border-color);
                background-color: #F4F7F9 !important;
                transition: all 0.2s ease;
            }
            .accordion-button:not(.collapsed) {
                color: var(--action-color);
                background-color: var(--primary-light) !important;
                font-weight: bold;
            }
            .tree-accordion-item:hover {
                box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            }
            /* 💡 Status Dots/Badges (for use in tree-node.blade.php) */
            .status-active { background-color: var(--success-color); color: white; }
            .status-inactive { background-color: var(--secondary-light); color: white; }
            .bg-soft-primary { background-color: var(--primary-light) !important; color: var(--action-color) !important; }

            /* Sticky Form */
            @media (min-width: 992px) {
                .sticky-lg-top {
                    position: sticky;
                    top: 15px;
                    align-self: flex-start;
                }
            }
        </style>
</div>
