<div class="letter-show-container rtl" dir="rtl"
     x-data="{
         // تعریف تابع به صورت فشرده برای جلوگیری از خطای Alpine Syntax
         showTooltip() {
             if (typeof bootstrap !== 'undefined') {
                 var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle=&quot;tooltip&quot;]'));
                 tooltipTriggerList.map(function (tooltipTriggerEl) {
                     return new bootstrap.Tooltip(tooltipTriggerEl)
                 })
             }
         }
     }"
     x-init="() => {
         showTooltip();
         Livewire.on('focus-comment-input', () => {
             document.getElementById('newCommentInput').focus();
         });
     }"
     style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
>
    {{-- 🌟 استایل‌های سفارشی مدرن و یکپارچه --}}
    <style>
        :root {
            --primary: #3B82F6; /* Blue 500 */
            --primary-700: #1F2937; /* Slate 800 - رنگ جدید و حرفه‌ای هدر */
            --primary-50: #EFF6FF; /* Blue 50 */
            --success: #059669;
            --warning: #D97706;
            --danger: #DC2626;
            --gray-100: #F3F4F6;
            --gray-300: #D1D5DB;
            --gray-900: #111827;
            --card-bg: #FFFFFF;
            --border-color: #E5E7EB;
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            --info: #0EA5E9;
            --text-light: #F3F4F6;
        }

        .letter-show-container { max-width: 1400px; margin: 0 auto; padding: 24px; }
        .card { background: var(--card-bg); border-radius: 18px; border: 1px solid var(--border-color); overflow: hidden; box-shadow: none; }
        .card-header-styled { padding: 16px 24px; font-weight: 700; font-size: 1.1rem; border-bottom: 1px solid var(--border-color); background: var(--gray-100); color: var(--gray-900); }
        .letter-content { font-size: 1.05rem; line-height: 1.8; color: var(--gray-900); padding: 24px; min-height: 200px; }

        /* ✨ هدر جدید: تم مشکی/آبی حرفه‌ای و تمیز */
        .letter-header {
            position: relative; padding: 20px 30px; border-radius: 16px;
            background: var(--primary-700);
            color: white; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.2); margin-bottom: 24px;
        }
        .header-title {
            font-size: 2rem;
            font-weight: 700;
            line-height: 1.2;
            color: white;
        }

        /* نوار اطلاعاتی زیر هدر */
        .header-info-bar {
            background: rgba(255, 255, 255, 0.1);
            padding: 10px 20px;
            border-radius: 10px;
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
            gap: 10px;
            flex-wrap: wrap;
        }
        .info-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.9rem;
            padding: 5px 0;
        }
        .info-item-icon { /* کنترل رنگ آیکون‌ها در نوار اطلاعات */
            background: rgba(255, 255, 255, 0.2);
            padding: 4px 6px;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 25px;
        }


        .referral-avatar { width: 48px; height: 48px; border-radius: 50%; object-fit: cover; }
        .comment-avatar { width: 36px; height: 36px; }
        .active-referral-list { padding: 16px 24px; display: flex; align-items: center; gap: 12px; flex-wrap: wrap; }
        .status-dot { position: absolute; top: -2px; right: -2px; width: 12px; height: 12px; border-radius: 50%; border: 3px solid white; z-index: 10; }
        .status-dot.completed { background-color: var(--success); }
        .status-dot.pending { background-color: var(--warning); }
        .status-dot.canceled { background-color: var(--danger); }
        .status-dot.viewed { background-color: var(--primary); }

        /* استایل‌های آکاردئون */
        .accordion-item { border: 1px solid var(--border-color); border-radius: 18px !important; margin-bottom: 15px; box-shadow: var(--shadow-xl); overflow: hidden; }
        .accordion-button:not(.collapsed) { color: var(--primary-700); background-color: var(--primary-50); box-shadow: none; border-bottom: 1px solid var(--border-color); }
        .accordion-button { padding: 16px 24px; font-weight: 700; font-size: 1.1rem; }
        .accordion-flush .accordion-item { border-left: none; border-right: none; border-bottom: none; }
        .accordion-flush .accordion-item:last-child { border-bottom: none; }
        .accordion-flush .accordion-item:first-child { border-top: none; }
    </style>

    {{-- 1. HEADER & GLOBAL ACTIONS (سازماندهی شده) --}}
    <div class="letter-header">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start gap-3">
            <div class="d-flex flex-column">
                {{-- عنوان با سایز مناسب و رنگ سفید --}}
                <h1 class="header-title">{{ $letter->title }}</h1>
                <p class="text-gray-300 mt-1 mb-0" style="font-size: 1rem;">
                    ایجاد شده توسط: {{ $letter->sender->name ?? '—' }}
                </p>
            </div>

            {{-- دکمه‌های اصلی --}}
            <div class="header-actions d-flex gap-3 flex-wrap justify-content-end align-items-center">

                <button wire:click="downloadPdf" class="btn btn-light d-flex align-items-center gap-1 fw-bold rounded-pill text-primary">
                    <i class="fas fa-file-pdf"></i> PDF
                </button>

                <button wire:click="openReferralTreeModal" class="btn btn-outline-light d-flex align-items-center gap-1 fw-bold rounded-pill">
                    <i class="fas fa-sitemap"></i> گردش کار
                </button>

                @if($this->canEdit)
                    <a href="{{ route('admin.edit.letter', ['letter' => $letter->id]) }}"
                       class="btn btn-outline-light d-flex align-items-center gap-1 fw-bold rounded-pill">
                        <i class="fas fa-edit"></i> ویرایش
                    </a>
                @endif
            </div>
        </div>

        {{-- نوار اطلاعاتی تمیز (Header Info Bar) --}}
        <div class="header-info-bar">

            {{-- کد نامه --}}
            <div class="info-item">
                <span class="info-item-icon"><i class="fas fa-hashtag"></i></span> <span class="fw-medium text-gray-200">کد:</span> <span class="fw-bold">{{ $letter->code ?? '—' }}</span>
            </div>

            {{-- تاریخ --}}
            <div class="info-item">
                <span class="info-item-icon"><i class="far fa-calendar-alt"></i></span> <span class="fw-medium text-gray-200">تاریخ:</span> <span>{{ $this->shamsiCreatedDate }}</span>
            </div>

            {{-- اولویت --}}
            @php
                $priorityColor = match($letter->priority) { 'urgent' => 'var(--danger)', 'high' => 'var(--warning)', default => 'var(--success)', };
            @endphp
            <div class="info-item">
                <span class="info-item-icon" style="background: {{ $priorityColor }};"><i class="fas fa-star"></i></span> <span class="fw-medium text-gray-200">اولویت:</span> <span>{{ $letter->priorityLabel() }}</span>
            </div>

            {{-- وضعیت نهایی --}}
            <div class="info-item">
                <span class="info-item-icon"><i class="fas fa-check-double"></i></span> <span class="fw-medium text-gray-200">وضعیت:</span>
                <span class="badge rounded-pill" style="background: var(--primary); font-weight: 500;">{{ $letter->statusLabel() }}</span>
            </div>
        </div>
    </div>

    <div class="row g-5">
        {{-- 2. MAIN CONTENT (Letter Text, Signature, Attachments) --}}
        <div class="col-lg-8">
            <div class="card mb-5" style="box-shadow: var(--shadow-xl);">
                <div class="card-header-styled"><i class="fas fa-file-alt text-primary me-2"></i> متن اصلی نامه</div>
                <div class="letter-content">
                    {!! $letter->content !!}
                </div>
            </div>

            {{-- Signature Block --}}
            @if(in_array($letter->status, ['approved', 'completed', 'signed']))
                <div class="card p-4 mb-5 border-success shadow-xl" style="border-radius: 18px; border-left: 6px solid var(--success);">
                    <div class="d-flex align-items-center gap-3">
                        <i class="fas fa-signature fs-2 text-success"></i>
                        <div>
                            <h5 class="mb-0 fw-bold text-success">امضای رسمی و تکمیل‌شده</h5>
                            <p class="text-muted small mb-0">این نامه با موفقیت توسط مرجع ذی‌صلاح تأیید نهایی شده است.</p>
                        </div>
                    </div>
                </div>
            @endif

            {{-- Attachments (قابل جمع شدن) --}}
            @if($letter->attachments->count())
                <div class="accordion accordion-flush" id="attachmentsAccordion">
                    <div class="accordion-item card" style="box-shadow: var(--shadow-xl);">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAttachments" aria-expanded="true" aria-controls="collapseAttachments" style="background: var(--gray-100);">
                                <i class="fas fa-paperclip text-primary me-2"></i> پیوست‌ها ({{ $letter->attachments->count() }})
                            </button>
                        </h2>
                        <div id="collapseAttachments" class="accordion-collapse collapse show" data-bs-parent="#attachmentsAccordion">
                            <div class="card-body p-0">
                                @foreach($letter->attachments as $att)
                                    <div class="d-flex align-items-center justify-content-between p-4 border-bottom">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="attachment-icon d-flex align-items-center justify-content-center text-primary" style="width: 48px; height: 48px; border-radius: 10px; background: var(--primary-50);">
                                                <i class="fas fa-file-alt fs-5"></i>
                                            </div>
                                            <div>
                                                <div class="fw-bold">{{ $att->file_name }}</div>
                                                <div class="text-muted small">
                                                    {{ number_format($att->file_size / 1024, 1) }} KB
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <a href="{{ Storage::url($att->file_path) }}" class="btn btn-primary btn-sm rounded-pill" download>
                                                <i class="fas fa-download me-1"></i> دانلود
                                            </a>
                                            @if(in_array(strtolower(pathinfo($att->file_name, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'pdf']))
                                                <a href="{{ Storage::url($att->file_path) }}" class="btn btn-outline-secondary btn-sm rounded-pill" target="_blank">
                                                    <i class="fas fa-eye me-1"></i> پیش‌نمایش
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        {{-- 3. SIDEBAR (Accordion Structure) --}}
        <div class="col-lg-4">

            {{-- Referral Status Alert (باکس وضعیت جداگانه) --}}
            @if($referral)
                <div class="card p-4 mb-4" style="box-shadow: var(--shadow-xl); border-left: 6px solid @if($referral->status === 'pending') var(--warning) @elseif($referral->status === 'viewed') var(--info) @elseif($referral->status === 'canceled') var(--danger) @else var(--success) @endif;">
                    <h5 class="fw-bold mb-1 d-flex align-items-center gap-2"
                        style="color: @if($referral->status === 'pending') var(--warning) @elseif($referral->status === 'viewed') var(--info) @elseif($referral->status === 'canceled') var(--danger) @else var(--success) @endif;">
                        <i class="fas fa-bullhorn"></i> وضعیت ارجاع شما:
                    </h5>
                    <p class="fw-bolder mb-0 fs-5">
                        {{ $this->referral->statusLabel() }}
                    </p>
                    <p class="text-muted small mt-2 mb-0">ارجاع توسط: {{ $referral->creator->name ?? 'سیستم' }} در {{ $this->shamsiReferralDate }}</p>
                    @if($referral->comment)
                        <div class="alert alert-light small p-2 mt-3 mb-0 border-primary rounded-3">
                            <i class="fas fa-comment me-1 text-primary"></i> **یادداشت ارجاع‌دهنده:** {{ $referral->comment }}
                        </div>
                    @endif
                </div>
            @endif

            {{-- آکاردئون اصلی برای سایدبار --}}
            <div class="accordion accordion-flush" id="sidebarAccordion">

                {{-- 1. Actions Block --}}
                @if($referral && $this->canAct)
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseActions" aria-expanded="false" aria-controls="collapseActions" style="background: var(--gray-100);">
                                <i class="fas fa-cogs text-primary me-2"></i> اقدامات مورد نیاز
                            </button>
                        </h2>
                        <div id="collapseActions" class="accordion-collapse collapse" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-4">
                                <div class="action-btn-group d-grid gap-3">
                                    <div class="d-flex gap-3">
                                        <button wire:click="openActionModal('approve')" class="btn btn-success flex-grow-1 rounded-pill">
                                            <i class="fas fa-check me-1"></i> تأیید نهایی / تکمیل
                                        </button>
                                        <button wire:click="openActionModal('correction')" class="btn btn-warning flex-grow-1 rounded-pill">
                                            <i class="fas fa-undo me-1"></i> بازگشت برای تصحیح
                                        </button>
                                    </div>
                                    <button wire:click="openActionModal('view')" class="btn btn-outline-primary btn-sm rounded-pill">
                                        <i class="fas fa-eye me-1"></i> صرفاً مشاهده شد
                                    </button>

                                    <hr class="my-2">

                                    <button wire:click="openHandoffModal" class="btn btn-outline-secondary rounded-pill">
                                        <i class="fas fa-exchange-alt me-1"></i> واگذاری/ارجاع به همکار
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- 2. Workflow/Active Referrals --}}
                @if($this->activeReferrals->isNotEmpty())
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseReferrals" aria-expanded="false" aria-controls="collapseReferrals" style="background: var(--gray-100);">
                                <i class="fas fa-users-cog text-primary me-2"></i> ارجاع‌گیرندگان فعال
                            </button>
                        </h2>
                        <div id="collapseReferrals" class="accordion-collapse collapse" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-0">
                                <div class="active-referral-list">
                                    @foreach($this->activeReferrals as $ref)
                                        <div class="active-referral-item"
                                             data-bs-toggle="tooltip"
                                             data-bs-placement="top"
                                             data-bs-html="true"
                                             title="<div class='text-start small fw-bold mb-1'>{{ $ref->name }}</div><div class='small'>{{ $ref->typeLabel }} | وضعیت: {{ $ref->statusLabel }}</div><div class='small text-muted'>داخلی: {{ $ref->internalNumber }}</div>">

                                            <img src="{{ $ref->photoUrl }}" class="referral-avatar" alt="{{ $ref->name }}">

                                            <span class="status-dot @if($ref->status === 'completed') completed @elseif($ref->status === 'pending') pending @elseif($ref->status === 'canceled') canceled @else viewed @endif"></span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- 3. Comments Block (تکمیل شده با کنترل مرتب‌سازی) --}}
                @if($referral || $letter->sender_id === Auth::id())
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseComments" aria-expanded="true" aria-controls="collapseComments" style="background: var(--gray-100);">
                                <i class="fas fa-comments text-primary me-2"></i> گفتگو و نظرات
                            </button>
                        </h2>
                        <div id="collapseComments" class="accordion-collapse collapse show" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-4">

                                {{-- ✨ کنترل مرتب‌سازی (افزودن دکمه‌های جدیدترین/قدیمی‌ترین) --}}
                                <div class="d-flex justify-content-end align-items-center mb-3">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button type="button"
                                                wire:click="$set('sortOrder', 'latest')"
                                                class="btn @if(isset($sortOrder) && $sortOrder === 'latest') btn-primary @else btn-outline-secondary @endif rounded-start-pill">
                                            <i class="fas fa-sort-amount-down-alt me-1"></i> جدیدترین
                                        </button>
                                        <button type="button"
                                                wire:click="$set('sortOrder', 'oldest')"
                                                class="btn @if(isset($sortOrder) && $sortOrder === 'oldest') btn-primary @else btn-outline-secondary @endif rounded-end-pill">
                                            <i class="fas fa-sort-amount-up-alt me-1"></i> قدیمی‌ترین
                                        </button>
                                    </div>
                                </div>

                                @error('newComment')
                                <div class="alert alert-danger small">{{ $message }}</div>
                                @enderror

                                {{-- Comment Input (فرم ارسال پیام) --}}
                                @if($referral || $letter->sender_id === Auth::id())
                                    <form wire:submit.prevent="postComment" class="mb-4 bg-light p-3 rounded-4 border">
                                        <h6 class="fw-bold small mb-2 text-primary">ارسال پیام:</h6>
                                        <textarea class="form-control rounded-3" wire:model="newComment" id="newCommentInput"
                                                  placeholder="{{ $replyParentId ? 'در حال پاسخ به یک نظر...' : 'نظر خود را بنویسید...' }}"
                                                  rows="3" required></textarea>
                                        <div class="d-flex justify-content-between align-items-center mt-3">
                                            <button type="submit" class="btn btn-primary btn-sm rounded-pill">
                                                <i class="fas fa-paper-plane me-1"></i> ارسال
                                            </button>
                                            @if($replyParentId)
                                                <button type="button" wire:click="$set('replyParentId', null)"
                                                        class="btn btn-outline-secondary btn-sm rounded-pill">
                                                    <i class="fas fa-times me-1"></i> لغو پاسخ
                                                </button>
                                            @endif
                                        </div>
                                    </form>
                                @endif

                                {{-- Comment List --}}
                                <div class="comment-list">
                                    @forelse($this->allComments as $comment)
                                        @include('livewire.admin.letter.partials.comment-styled', [
                                            'comment' => $comment,
                                            'replyParentId' => $replyParentId,
                                            'isReply' => false,
                                        ])
                                    @empty
                                        <div class="text-center py-5 text-muted">
                                            <i class="fas fa-comment-dots fs-3 mb-2"></i>
                                            <p>هنوز گفتگویی انجام نشده است.</p>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    {{-- MODALS (Action, Handoff, Tree) --}}
    @include('livewire.admin.letter.partials.modals-styled')
</div>
