<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="saveArchive">
        <div>
            <label for="letter_id">انتخاب نامه:</label>
            <select id="letter_id" wire:model="letter_id">
                <option value="">انتخاب نامه</option>
                @foreach($letters as $letter)
                    <option value="{{ $letter->id }}">{{ $letter->title }}</option>
                @endforeach
            </select>
            @error('letter_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="project_id">انتخاب پروژه:</label>
            <select id="project_id" wire:model="project_id">
                <option value="">انتخاب پروژه</option>
                @foreach($projects as $project)
                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                @endforeach
            </select>
            @error('project_id') <span class="error">{{ $message }}</span> @enderror
        </div>

        <button type="submit">بایگانی</button>
    </form>
</div>
