<div class="container-fluid" x-data="{ openToast: false, toastMessage: '', toastType: '' }">

    {{-- ✨ بخش Toast Notification - اصلاح شده برای زیبایی بیشتر --}}
    <div x-show="openToast"
         x-transition:enter="transition ease-out duration-300 transform"
         x-transition:leave="transition ease-in duration-300 transform"
         @toast-message.window="
             toastMessage = $event.detail.message;
             toastType = $event.detail.type || 'success';
             openToast = true;
             setTimeout(() => openToast = false, 4000);
         "
         class="position-fixed top-0 end-0 p-3" style="z-index: 1080;">
        <div :class="{
                'alert-success border-success': toastType === 'success',
                'alert-danger border-danger': toastType === 'error',
                'alert-info border-info': toastType === 'info'
             }"
             class="alert alert-dismissible fade show rounded-3 shadow-lg border-start border-5" role="alert" style="min-width: 300px;">
            {{-- آیکون‌های دینامیک --}}
            <i class="fas fa-check-circle me-2 text-success" x-show="toastType === 'success'"></i>
            <i class="fas fa-times-circle me-2 text-danger" x-show="toastType === 'error'"></i>
            <i class="fas fa-info-circle me-2 text-info" x-show="toastType === 'info'"></i>

            <span x-text="toastMessage" class="fw-medium"></span>
            <button type="button" class="btn-close" @click="openToast = false"></button>
        </div>
    </div>

    {{-- 🏷️ هدر صفحه و Breadcrumb --}}
    <div class="card shadow-sm border-0 rounded-3 mb-4" style="background-color: #f8f9fa;">
        <div class="card-body px-4 py-3">
            <div class="row align-items-center">
                <div class="col-12">
                    <h4 class="fw-bold mb-1" style="color: #1e3a8a;">
                        <i class="fas fa-tags me-2 text-primary"></i>
                        {{ __('ثبت دسته‌بندی نامه‌ها') }}
                    </h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a class="text-muted text-decoration-none small" href="#">{{ __('داشبورد') }}</a></li>
                            <li class="breadcrumb-item text-primary small" aria-current="page">{{ __('ثبت دسته‌بندی') }}</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    {{-- 📝 بخش اصلی فرم --}}
    <section class="mt-4">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">

                <div class="card shadow-lg border-primary rounded-3">
                    {{-- هدر فرم با رنگ جذاب‌تر --}}
                    <div class="card-header bg-primary text-white py-3 rounded-top-3">
                        <h5 class="mb-0 fw-bold d-flex align-items-center">
                            <i class="fas fa-edit me-2"></i>
                            {{ __('فرم ثبت دسته‌بندی جدید') }}
                        </h5>
                    </div>

                    <div class="card-body p-4 p-md-5">

                        <form wire:submit="SaveType" class="mt-3">
                            <div class="row">
                                <div class="col-12 mb-4">
                                    <label for="name" class="form-label fw-medium mb-2">{{ __('عنوان دسته‌بندی') }} <span class="text-danger">*</span></label>
                                    <input type="text"
                                           class="form-control form-control-lg rounded-3"
                                           wire:model="name"
                                           id="name"
                                           placeholder="{{ __('مثال: نامه‌های اداری، نامه‌های فنی') }}"
                                           required>

                                    @error('name')
                                    <span class="text-danger d-block mt-1 small fw-medium">{{ $message }}</span>
                                    @enderror
                                </div>


                                <div class="col-12 mt-3 d-flex justify-content-end border-top pt-4">
                                    <button type="submit" class="btn btn-primary font-medium rounded-pill px-5 py-2 shadow-lg d-flex align-items-center">
                                        <div wire:loading wire:target="SaveType" class="spinner-border spinner-border-sm me-2" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        <i class="fas fa-save me-2 fs-4" wire:loading.remove></i>
                                        {{ __('ثبت و ذخیره') }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>

    {{-- 🎨 استایل‌های سفارشی بهبود یافته --}}
    <style>
        .bg-primary {
            background-color: #3b82f6 !important; /* آبی روشن‌تر */
        }
        .text-primary {
            color: #3b82f6 !important;
        }
        .btn-primary {
            background-color: #3b82f6;
            border-color: #3b82f6;
            transition: all 0.2s ease;
        }
        .btn-primary:hover {
            background-color: #1e3a8a; /* تغییر رنگ در هاور */
            border-color: #1e3a8a;
        }
        .form-control:focus {
            border-color: #3b82f6 !important;
            box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
        }
        .card-header {
            border-bottom: 0 !important;
        }
    </style>
</div>
