<div class="container-fluid" x-data="{
    openToast: false, toastMessage: '', toastType: '',
    editModalInstance: null,

    init() {
        // ایجاد نمونه Bootstrap Modal
        this.editModalInstance = new bootstrap.Modal(document.getElementById('editClassificationModal'), {
            backdrop: 'static',
            keyboard: false
        });

        // گوش دادن به رویداد باز کردن Modal از Livewire
        Livewire.on('open-modal', (data) => {
             // در Livewire 3، رویدادها در یک شیء به نام 'data' منتقل می‌شوند.
             if(data.name === 'editClassificationModal') {
                 this.editModalInstance.show();
             }
        });

        // گوش دادن به رویداد بستن Modal از Livewire
        Livewire.on('close-modal', (data) => {
             if(data.name === 'editClassificationModal') {
                 this.editModalInstance.hide();
             }
        });

        // گوش دادن به رویداد Toast Notification
        Livewire.on('toast-message', (data) => {
             this.toastMessage = data.message;
             this.toastType = data.type || 'success';
             this.openToast = true;
             setTimeout(() => this.openToast = false, 4000);
        });
    }
}">

    <div x-show="openToast"
         x-transition:enter="transition ease-out duration-300 transform"
         x-transition:leave="transition ease-in duration-300 transform"
         class="position-fixed top-0 end-0 p-3" style="z-index: 1080;">
        <div :class="{
                'alert-success border-success': toastType === 'success',
                'alert-danger border-danger': toastType === 'error',
                'alert-info border-info': toastType === 'info'
             }"
             class="alert alert-dismissible fade show rounded-3 shadow-lg border-start border-5" role="alert" style="min-width: 300px;">
            <i class="fas fa-check-circle me-2 text-success" x-show="toastType === 'success'"></i>
            <i class="fas fa-times-circle me-2 text-danger" x-show="toastType === 'error'"></i>
            <span x-text="toastMessage" class="fw-medium"></span>
            <button type="button" class="btn-close" @click="openToast = false"></button>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-3" style="background-color: #f8f9fa;">
        <div class="card-body px-4 py-3">
            <div class="row align-items-center">
                <div class="col-12 d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-1" style="color: #1e3a8a;">
                            <i class="fas fa-list-alt me-2 text-primary"></i>
                            {{ __('لیست دسته‌بندی نامه‌ها') }}
                        </h4>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a class="text-muted text-decoration-none small" href="#">{{ __('داشبورد') }}</a></li>
                                <li class="breadcrumb-item text-primary small" aria-current="page">{{ __('دسته‌بندی‌ها') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="widget-content searchable-container list mt-4">

        <div class="card card-body shadow-sm border-0 rounded-3">
            <div class="row align-items-center g-3">
                <div class="col-md-4 col-lg-3">
                    <div class="position-relative">
                        <i class="fas fa-search position-absolute top-50 start-0 translate-middle-y fs-6 text-muted ms-3"></i>
                        <input type="text"
                               class="form-control ps-5 rounded-pill shadow-sm"
                               wire:model.live.debounce.300ms="search"
                               placeholder="{{ __('جستجو بر اساس نام...') }}" />
                    </div>
                </div>

                <div class="col-md-8 col-lg-9 text-end d-flex justify-content-end align-items-center gap-3 mt-3 mt-md-0">
                    <span class="text-muted small d-none d-sm-inline">{{ __('تعداد در صفحه:') }}</span>
                    <select class="form-select form-select-sm rounded-pill shadow-sm" style="width: 120px;" wire:model.live="perPage">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                    </select>

                    <a href="{{ route('admin.create.letter.classification') }}" class="btn btn-success d-flex align-items-center rounded-pill px-4 shadow-sm">
                        <i class="fas fa-plus me-1 fs-5"></i> {{ __('افزودن جدید') }}
                    </a>
                </div>
            </div>
        </div>

        <div class="card card-body p-0 mt-4 shadow-lg border-0 rounded-3 overflow-hidden">
            <div class="table-responsive">
                <table class="table search-table align-middle text-nowrap table-hover mb-0">
                    <thead class="bg-primary text-white" style="background-color: #1e3a8a !important;">
                    <tr>
                        <th style="width: 5%;">#</th>

                        <th wire:click="sortBy('name')" role="button" class="cursor-pointer">
                            {{ __('نام دسته‌بندی') }}
                            @if ($sortField === 'name')
                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1 small"></i>
                            @endif
                        </th>

                        <th wire:click="sortBy('created_at')" role="button" style="width: 20%;" class="cursor-pointer text-center">
                            {{ __('تاریخ ثبت') }}
                            @if ($sortField === 'created_at')
                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1 small"></i>
                            @endif
                        </th>

                        <th style="width: 15%;" class="text-center">{{ __('عملیات') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($classifications as $index => $classification)
                        <tr class="search-items" wire:key="classification-{{ $classification->id }}">
                            <td>
                                {{ $classifications->firstItem() + $index }}
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-tag me-2 text-info"></i>
                                    <h6 class="user-name mb-0 fw-medium">{{ $classification->name }}</h6>
                                </div>
                            </td>

                            <td class="text-center text-muted small">
                                {{ jdate($classification->created_at)->format('Y/m/d H:i') }}
                            </td>

                            <td>
                                <div class="action-btn d-flex justify-content-center gap-2">

                                    <button class="btn btn-sm btn-outline-info rounded-circle shadow-sm"
                                            {{-- این سینتکس Livewire 3 صحیح است --}}
                                            wire:click="showEditModal({{ $classification->id }})"
                                            title="{{ __('ویرایش') }}">
                                        <i class="ti ti-edit fs-5"></i>
                                    </button>

                                    <button class="btn btn-sm btn-outline-danger rounded-circle shadow-sm"
                                            wire:click="deleteClassification({{ $classification->id }})"
                                            onclick="confirm('{{ __('آیا از حذف این دسته‌بندی مطمئن هستید؟') }}') || event.stopImmediatePropagation()"
                                            title="{{ __('حذف') }}"
                                            wire:loading.attr="disabled">
                                        <i class="ti ti-trash fs-5"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center py-5 text-muted">
                                <i class="fas fa-inbox fa-3x mb-3 text-light-gray"></i>
                                <p class="mb-0 fw-medium">{{ __('هیچ دسته‌بندی برای نمایش یافت نشد.') }}</p>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            <div class="card-footer bg-light border-top d-flex justify-content-center p-3">
                {{ $classifications->links() }}
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" id="editClassificationModal" tabindex="-1" aria-labelledby="editClassificationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content rounded-3 shadow-lg">
                <div class="modal-header d-flex align-items-center text-white" style="background-color: #3b82f6;">
                    <h5 class="modal-title" id="editClassificationModalLabel"><i class="fas fa-pencil-alt me-2"></i> {{ __('ویرایش دسته‌بندی') }}</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" wire:click="reset(['name', 'classificationId'])"></button>
                </div>
                <form wire:submit="updateClassification">
                    <div class="modal-body p-4">
                        <div class="form-floating mb-3">
                            <input type="text"
                                   class="form-control"
                                   wire:model.live="name"
                                   id="edit-name"
                                   placeholder="{{ __('عنوان دسته‌بندی') }}"
                                   required>
                            <label for="edit-name">{{ __('عنوان دسته‌بندی') }}</label>
                            @error('name')
                            <span class="text-danger d-block mt-1 small fw-medium">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal" wire:click="reset(['name', 'classificationId'])"> {{ __('انصراف') }} </button>
                        <button type="submit" class="btn btn-success rounded-pill px-4 d-flex align-items-center">
                            <div wire:loading wire:target="updateClassification" class="spinner-border spinner-border-sm me-2" role="status"></div>
                            <i class="fas fa-save me-2 fs-4" wire:loading.remove></i>
                            {{ __('ذخیره تغییرات') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <style>
        .btn-primary {
            background-color: #1e3a8a !important;
            border-color: #1e3a8a !important;
        }
        .bg-primary {
            background-color: #3b82f6 !important; /* رنگ جذاب‌تر برای سرتیتر */
        }
        .text-primary {
            color: #3b82f6 !important;
        }
        .cursor-pointer {
            cursor: pointer;
        }
        .text-light-gray {
            color: #d1d5db !important;
        }
    </style>
</div>

