<div class="container-fluid">

    {{-- 🏷️ هدر صفحه و Breadcrumb - تمیز و هماهنگ با سایدبار --}}
    <div class="p-3 mb-4 rounded-3 border-bottom border-primary-light border-3" style="background-color: #f7f9fc;">
        <div class="row align-items-center">
            <div class="col-12">
                <h3 class="fw-bolder mb-1 text-primary-dark">
                    <i class="fas fa-layer-group me-2 text-primary-light"></i>
                    {{ __('مدیریت دسته‌بندی نامه‌ها') }}
                </h3>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a class="text-muted text-decoration-none small" href="#"><i class="fas fa-home me-1"></i> {{ __('داشبورد') }}</a></li>
                        <li class="breadcrumb-item text-primary-dark small" aria-current="page">{{ __('دسته‌بندی‌ها') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    {{-- ساختار اصلی: زیر هم (Stacked View) --}}
    <div class="row g-4">

        {{-- ➕ بخش افزودن دسته‌بندی (تمام عرض: col-12) --}}
        <div class="col-12">
            <div class="card shadow-md border-0 rounded-4 overflow-hidden">
                <div class="card-header bg-gradient-primary text-white py-3 border-0 rounded-top-4">
                    <h5 class="mb-0 fw-bold"><i class="fas fa-plus-circle me-2"></i> {{ __('فرم افزودن دسته‌بندی جدید') }}</h5>
                </div>
                <div class="card-body p-4">
                    {{-- کامپوننت افزودن --}}
                    <livewire:admin.letter.classification.add-classification/>
                </div>
            </div>
        </div>

        {{-- 📋 بخش لیست دسته‌بندی‌ها (تمام عرض: col-12) --}}
        <div class="col-12">
            <div class="card shadow-md border-0 rounded-4 overflow-hidden">
                <div class="card-header bg-gradient-secondary text-white py-3 border-0 rounded-top-4">
                    <h5 class="mb-0 fw-bold"><i class="fas fa-list-alt me-2"></i> {{ __('لیست و مدیریت دسته‌بندی‌ها') }}</h5>
                </div>
                <div class="card-body p-0">
                    {{-- کامپوننت لیست --}}
                    <livewire:admin.letter.classification.classification-list/>
                </div>
            </div>
        </div>

    </div>

    {{-- 🎨 استایل‌های سفارشی برای طرح مدرن هماهنگ با تم --}}
    <style>
        /* پالت رنگی هماهنگ با تم */
        .text-primary-dark {
            color: #1e3a8a !important; /* آبی تیره */
        }
        .text-primary-light {
            color: #3b82f6 !important; /* آبی متوسط */
        }
        .text-secondary-dark {
            color: #059669 !important; /* سبز تیره */
        }

        /* گرادیانت اصلی (برای Add - آبی) */
        .bg-gradient-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #1e3a8a 100%) !important;
        }
        /* گرادیانت ثانویه (برای List - سبز) */
        .bg-gradient-secondary {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
        }

        /* تنظیمات کارت */
        .card {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05) !important;
            border: none !important;
            border-radius: 12px; /* کمی گردتر */
            transition: box-shadow 0.3s ease;
        }
        .card:hover {
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1) !important;
            transform: none; /* حذف انیمیشن برای پایداری بیشتر */
        }

        /* هماهنگی با کامپوننت‌های داخلی لیست */
        .card-body.p-0 > div:first-child {
            padding: 0;
            border-top: none;
        }
    </style>
</div>
