<div>
    <!-- هدر -->
    <div>{!! $template->header !!}</div>

    <!-- انتخاب نوع نامه -->
    <div>
        <label for="is_external">نامه برون‌سازمانی</label>
        <input type="checkbox" id="is_external" wire:model="is_external">
    </div>

    <!-- فیلد موضوع -->
    <div>
        <label for="title">موضوع نامه</label>
        <input type="text" id="title" wire:model="title">
        @error('title') <span class="error">{{ $message }}</span> @enderror
    </div>

    <!-- فیلد فرستنده -->
    <div>
        <label for="sender_id">فرستنده</label>
        <select id="sender_id" wire:model="sender_id">
            <option value="">انتخاب فرستنده</option>
            @foreach($users as $user)
                <option value="{{ $user->id }}">{{ $user->name }}</option>
            @endforeach
        </select>
        @error('sender_id') <span class="error">{{ $message }}</span> @enderror
    </div>

    <!-- فیلد گیرنده (درون‌سازمانی) -->
    @if(!$is_external)
        <div>
            <label for="receiver_id">گیرنده</label>
            <select id="receiver_id" wire:model="receiver_id">
                <option value="">انتخاب گیرنده</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            @error('receiver_id') <span class="error">{{ $message }}</span> @enderror
        </div>
    @endif

    <!-- فیلد گیرنده (برون‌سازمانی) -->
    @if($is_external)
        <div>
            <label for="receiver_name">نام گیرنده</label>
            <input type="text" id="receiver_name" wire:model="receiver_name">
            @error('receiver_name') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="receiver_organization">سازمان گیرنده</label>
            <input type="text" id="receiver_organization" wire:model="receiver_organization">
            @error('receiver_organization') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="receiver_address">آدرس گیرنده</label>
            <input type="text" id="receiver_address" wire:model="receiver_address">
            @error('receiver_address') <span class="error">{{ $message }}</span> @enderror
        </div>
    @endif

    <!-- فیلد متن نامه -->
    <div>
        <label for="content">متن نامه</label>
        <textarea id="content" wire:model="content"></textarea>
        @error('content') <span class="error">{{ $message }}</span> @enderror
    </div>

    <!-- دکمه ذخیره -->
    <button wire:click="saveLetter">ذخیره نامه</button>
</div>
