<div x-data="{
    // 💡 متد جدید برای مدیریت فایل‌های Drop شده
    handleFileDrop(e) {
        e.preventDefault();
        const files = [...e.dataTransfer.files];
        if (files.length > 0) {
            // فراخوانی متد جدید در کامپوننت Livewire
            @this.addFiles(files);
        }
    },
    // 💡 متد جدید برای مدیریت فایل‌های انتخاب شده
    handleFileSelect(e) {
        const files = [...e.target.files];
        if (files.length > 0) {
            @this.addFiles(files);
            e.target.value = null; // ریست کردن input type file
        }
    }
}" x-cloak>
    <style>
        /* 💡 بهبود استایل‌ها و رنگ‌بندی مدرن‌تر */
        :root {
            --primary: #4f46e5; /* Indigo */
            --primary-light: #eef2ff;
            --danger: #ef4444;
            --border: #e5e7eb;
            --light: #f9fafb;
            --shadow: 0 4px 18px rgba(0,0,0,0.06);
        }
        /* ... (بقیه استایل‌های CSS موجود را نگه دارید) ... */
        .form-section {
            background: white;
            border-radius: 16px;
            padding: 1.75rem;
            margin-bottom: 1.75rem;
            border: 1px solid var(--border);
            box-shadow: var(--shadow);
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        }
        .form-control, .form-select {
            border-radius: 10px;
            padding: 0.75rem 1rem;
        }
        .priority-badge {
            font-size: 0.75rem;
            padding: 0.2em 0.5em;
            border-radius: 4px;
            font-weight: 600;
            margin-right: 5px;
        }
        .confidential-toggle {
            display: flex;
            align-items: center;
            gap: 12px;
            padding-top: 10px; /* برای هم‌ترازی با select */
        }
        .confidential-toggle i.fa-lock {
            color: #9ca3af;
            transition: color 0.2s;
        }
        .confidential-toggle input:checked + i.fa-lock {
            color: var(--danger);
        }
        .cc-list-item {
            background: var(--light);
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 10px 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }
        .cc-remove-btn {
            color: var(--danger);
            cursor: pointer;
            font-size: 1.2rem;
        }
    </style>

    <form wire:submit.prevent="saveLetter" class="p-4">

        <h3 class="text-xl font-bold mb-4 border-bottom pb-2">ثبت نامه جدید</h3>

        <div class="form-section">
            <div class="field-group">
                <div>
                    <label class="form-label required">پروژه</label>
                    <select class="form-select" wire:model="project_id" {{ $project_id ? 'disabled' : '' }}>
                        <option value="">پروژه‌ای را انتخاب کنید</option>
                        {{-- 💡 فرض می‌کنیم auth()->user()->accessibleProjects() تعریف شده است --}}
                        @foreach(auth()->user()->accessibleProjects() ?? [] as $project)
                            <option value="{{ $project->id }}">{{ $project->name }} ({{ $project->code }})</option>
                        @endforeach
                    </select>
                    @error('project_id') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>
                <div style="grid-column: span 2 / span 2;">
                    <label class="form-label required">عنوان نامه</label>
                    <input type="text" class="form-control" wire:model="title" placeholder="درخواست تأیید بودجه">
                    @error('title') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>
                <div style="grid-column: span 3 / span 3;">
                    <label class="form-label">موضوع (اختیاری)</label>
                    <input type="text" class="form-control" wire:model="subject" placeholder="مثال: بودجه فاز ۲ پروژه X">
                    @error('subject') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>
            </div>
        </div>

        <div class="form-section">
            <h5 class="form-label mb-3">تنظیمات فرستنده و گیرنده</h5>
            <div class="field-group">
                <div>
                    <label class="form-label">از طرف (نام فرستنده)</label>
                    <input type="text" class="form-control" wire:model="from_who" placeholder="نام فرستنده">
                    @error('from_who') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>
                <div>
                    <label class="form-label">به: (نام گیرنده)</label>
                    <input type="text" class="form-control" wire:model="to_who" placeholder="نام گیرنده/سازمان مقصد">
                    @error('to_who') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="form-label required">اولویت</label>
                    <select class="form-select" wire:model="priority">
                        <option value="low">کم</option>
                        <option value="normal">عادی</option>
                        <option value="high">بالا</option>
                        <option value="urgent">فوری</option>
                    </select>
                </div>

                <div>
                    <label class="form-label">تاریخ سررسید</label>
                    <input type="date" class="form-control" wire:model="due_date">
                </div>

                <div>
                    <label class="form-label">محرمانه</label>
                    <div class="confidential-toggle">
                        <input class="form-check-input" type="checkbox" wire:model="confidential" id="confidential" style="width:20px;height:20px;">
                        <i class="fas fa-lock" :style="$wire.confidential ? 'color: var(--danger);' : 'color: #9ca3af;'"></i>
                        <label for="confidential">این نامه محرمانه است</label>
                    </div>
                    @error('confidential') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="form-label">موقعیت امضا</label>
                    <select class="form-select" wire:model="signature_position">
                        <option value="">(انتخاب موقعیت امضا)</option>
                        @foreach($positions as $position)
                            <option value="{{ $position }}">{{ $position }}</option>
                        @endforeach
                    </select>
                    @error('signature_position') <div class="text-danger mt-2">{{ $message }}</div> @enderror
                </div>
            </div>
        </div>

        <div class="form-section">
            <h5 class="form-label mb-3">رونوشت (CC)</h5>
            <div class="row g-3">
                <div class="col-md-5">
                    <input type="text" class="form-control" wire:model.defer="cc_name" placeholder="نام شخص / سازمان رونوشت">
                </div>
                <div class="col-md-5">
                    <select class="form-select" wire:model.defer="cc_position">
                        <option value="">(جایگاه اختیاری)</option>
                        @foreach($positions as $position)
                            <option value="{{ $position }}">{{ $position }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-outline-secondary w-100" wire:click="addCc">
                        <i class="fas fa-plus"></i> افزودن
                    </button>
                </div>
            </div>

            <div class="mt-4">
                @foreach($ccs as $index => $cc)
                    <div class="cc-list-item">
                        <span class="fw-bold">{{ $cc['name'] }}</span>
                        <span class="text-muted small">{{ $cc['position'] ?? 'بدون جایگاه' }}</span>
                        <i class="fas fa-times cc-remove-btn" wire:click="removeCc({{ $index }})"></i>
                    </div>
                @endforeach
            </div>
        </div>

        <div class="form-section">
            <label class="form-label required">متن نامه</label>
            <div class="tinymce-container" wire:ignore>
                <textarea id="letter-content">{{ $content }}</textarea>
            </div>
            @error('content') <div class="text-danger mt-2">{{ $message }}</div> @enderror
        </div>

        <div class="form-section">
            <label class="form-label">ضمیمه‌ها (اختیاری)</label>
            <div class="drop-zone"
                 @dragover.prevent="event.target.classList.add('dragover')"
                 @dragleave.prevent="event.target.classList.remove('dragover')"
                 @drop.prevent="handleFileDrop(event)">
                <i class="fas fa-cloud-upload-alt"></i>
                <p class="mb-0">فایل‌ها را اینجا رها کنید یا <label for="attachment-uploader" class="text-primary cursor-pointer fw-bold">انتخاب کنید</label></p>
                <input type="file" id="attachment-uploader" class="form-control" multiple wire:model="attachments" @change="handleFileSelect($event)" style="display:none;">
            </div>
            @error('attachments.*') <div class="text-danger mt-2">{{ $message }}</div> @enderror

            @if($attachments)
                <div class="mt-3">
                    @foreach($attachments as $index => $file)
                        {{-- 💡 استفاده از getClientOriginalName() برای نمایش نام فایل --}}
                        <span class="attachment-item">
                            <i class="fas fa-paperclip"></i>
                            {{ method_exists($file, 'getClientOriginalName') ? $file->getClientOriginalName() : 'فایل جدید' }}
                            <span class="remove-btn" wire:click="removeAttachment({{ $index }})">×</span>
                        </span>
                    @endforeach
                </div>
            @endif
        </div>

        <div class="d-flex justify-content-end align-items-center pt-4 mt-4 border-top">
            <div class="d-flex gap-3">
                <button type="button" class="btn btn-outline-secondary" wire:click="previewLetter">
                    <i class="fas fa-eye me-2"></i> پیش‌نمایش
                </button>
                <button type="button" class="btn btn-outline-secondary" wire:click="$dispatch('close-modal')">
                    <i class="fas fa-times me-2"></i> انصراف
                </button>
                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                    <span wire:loading.remove>
                        <i class="fas fa-save me-2"></i> ذخیره پیش‌نویس
                    </span>
                    <span wire:loading>
                        <span class="spinner-border spinner-border-sm me-2" role="status"></span> در حال ذخیره...
                    </span>
                </button>
            </div>
        </div>
    </form>

    @push('scripts')
        <script src="{{ url('panel/plugin/tinymce/tinymce.min.js') }}"></script>
        <script>
            document.addEventListener('livewire:init', () => {
                let tinyEditor = null;

                function initTinyMCE() {
                    const container = document.querySelector('.tinymce-container');
                    if (!container) return; // 💡 اگر در Modal باز شده و هنوز المنت نیست، کاری نکنیم
                    if (tinyEditor) {
                        // اگر قبلا مقداردهی شده، از نو سازی جلوگیری شود
                        return;
                    }

                    const placeholder = document.createElement('div');
                    placeholder.className = 'editor-placeholder';
                    placeholder.textContent = 'متن نامه را اینجا بنویسید...';
                    container.appendChild(placeholder);

                    tinyEditor = tinymce.init({
                        selector: '#letter-content',
                        license_key: 'gpl',
                        language: 'fa',
                        directionality: 'rtl',
                        height: 500,
                        menubar: 'file edit view insert format tools table help',
                        plugins: 'preview importcss searchreplace autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons code',
                        toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent | numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen preview print | ltr rtl | table | image | link | code',
                        toolbar_mode: 'sliding',
                        quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                        fontsize_formats: '8pt 10pt 12pt 14pt 16pt 18pt 20pt 24pt 36pt',

                        // 💡 پشتیبانی از چندین فونت مدرن فارسی
                        font_family_formats: 'IRANSans=IRANSans, sans-serif; Vazir=Vazir, sans-serif; Peyda=PeydaWebNoEn, sans-serif; Dana=dana, sans-serif; Tahoma=Tahoma, Geneva, sans-serif; Arial=Arial, Helvetica, sans-serif; Times New Roman=Times New Roman, serif;',

                        content_style: `
                            /* 💡 مطمئن شوید آدرس‌دهی فونت‌ها صحیح است */
                            @font-face { font-family: 'IRANSans'; src: url('/panel/dist/fonts/IRANSans/IRANSansWeb(FaNum).woff') format('woff'); }
                            @font-face { font-family: 'Peyda'; src: url('/panel/dist/fonts/PeydaWeb/Woff2/PeydaWeb-Regular.woff2') format('woff2'); }
                            @font-face { font-family: 'Vazir'; src: url('/panel/dist/fonts/vazir/Vazir.woff2') format('woff2'); }
                            @font-face { font-family: 'dana'; src: url('/panel/dist/fonts/dana/dana-regular.woff') format('woff'); }

                            body {
                                font-family: IRANSans, Vazir, Peyda, Dana, Tahoma, Arial, sans-serif;
                                font-size: 14pt;
                                direction: rtl;
                                text-align: right;
                                line-height: 1.8;
                                color: #1f2937;
                                padding: 1.2rem;
                            }
                            /* دیگر استایل‌های مهم برای محیط RTL */
                            p { margin: 0 0 1em 0; }
                            blockquote { border-right: 4px solid #ccc; padding-right: 15px; margin-right: 20px; }
                        `,
                        branding: false,
                        promotion: false,
                        relative_urls: false,
                        remove_script_host: false,
                        convert_urls: true,
                        images_upload_handler: function (blobInfo, success, failure) {
                            // 💡 تابع آپلود تصویر به سرور (بدون تغییر)
                            const formData = new FormData();
                            formData.append('image', blobInfo.blob());
                            formData.append('_token', '{{ csrf_token() }}');

                            fetch('{{ route("upload.tinymce.image") }}', {
                                method: 'POST',
                                body: formData,
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest'
                                }
                            })
                                .then(response => {
                                    if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
                                    return response.json();
                                })
                                .then(data => {
                                    if (data.location) {
                                        success(data.location);
                                    } else {
                                        failure(data.error?.message || data.message || 'آپلود تصویر با خطا مواجه شد.');
                                    }
                                })
                                .catch(error => {
                                    failure('خطا در ارتباط با سرور: ' + error.message);
                                });
                        },
                        setup: editor => {
                            editor.on('init', () => {
                                editor.setContent(@js($content) || '');
                                const hasContent = editor.getContent({ format: 'text' }).trim();
                                placeholder.style.display = hasContent ? 'none' : 'block';
                            });

                            editor.on('change keyup undo redo', () => {
                                const content = editor.getContent();
                                @this.set('content', content);
                                const hasContent = editor.getContent({ format: 'text' }).trim();
                                placeholder.style.display = hasContent ? 'none' : 'block';
                            });
                        }
                    });
                }

                initTinyMCE();

                // 💡 ایونت جدید برای ریست کردن کامل ادیتور پس از ذخیره
                Livewire.on('resetTinyMCE', () => {
                    if (tinyEditor) {
                        tinyEditor.setContent('');
                        @this.set('content', '');
                        const placeholder = document.querySelector('.editor-placeholder');
                        if (placeholder) placeholder.style.display = 'block';
                    }
                });

                // 💡 رندر مجدد (برای مواقعی که کامپوننت از بین می‌رود و بازسازی می‌شود - مثلاً در مدال)
                Livewire.hook('message.processed', ({ component, response }) => {
                    if (component.name === 'admin.letter.create.create-letter') {
                        // اگر tinyEditor وجود دارد و نیاز به مقداردهی اولیه است
                        if (!tinyEditor) {
                            setTimeout(initTinyMCE, 100);
                        } else {
                            // فقط مطمئن شویم محتوای Livewire در ادیتور بروز است
                            if (tinyEditor.getContent() !== component.content) {
                                tinyEditor.setContent(component.content || '');
                            }
                        }
                    }
                });
            });
        </script>
    @endpush
</div>
