<div class="container-fluid py-4 rtl" style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;">
    <style>
        :root {
            --primary: #4338CA; /* Indigo */
            --primary-light: #EDE9FE;
            --success: #10B981;
            --danger: #EF4444;
            --warning: #FF9F1C;
            --gray-50: #F9FAFB;
            --gray-100: #F3F4F6;
            --gray-200: #E5E7EB;
            --gray-900: #111827;
            --card: #FFFFFF;
            --border: #E5E7EB;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            --shadow-hover: 0 10px 20px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease-in-out;
        }

        .header-section { border-bottom: 2px solid var(--gray-200); }
        .card { border-radius: 20px; transition: var(--transition); border: 1px solid var(--gray-200); }
        .card.hover-shadow:hover { box-shadow: var(--shadow-hover); transform: translateY(-4px); }

        /* 🖼️ Preview Box (List) */
        .preview-box {
            background: var(--card); border: 1px solid var(--gray-200); border-radius: 14px; min-height: 180px; height: 200px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
            display: flex; align-items: center; justify-content: center; padding: 10px;
        }
        .preview-box img {
            max-height: 100%; max-width: 100%; object-fit: contain; border-radius: 6px;
        }

        /* ✨ Display Name (تمیزتر) */
        .form-name-display {
            font-weight: 800; font-size: 1.2rem; color: var(--gray-900);
            margin-bottom: 1rem;
            padding-bottom: 5px;
        }

        /* ⚙️ Action Buttons Group - Compact */
        .action-group .btn {
            border-radius: 10px;
            padding: 6px 12px; /* فشرده‌تر */
            font-size: 0.85rem;
            margin: 0 2px;
        }

        /* Modal Styles */
        .modal-content { border-radius: 20px !important; }
        .upload-placeholder {
            border: 2px dashed var(--primary); background: var(--primary-light); color: var(--primary); padding: 1.5rem; border-radius: 16px; cursor: pointer;
        }
        .uploaded-preview { max-height: 150px; border-radius: 10px; border: 1px solid var(--primary-light); width: 100%; object-fit: contain; }
        .file-info-box { background: var(--gray-50); border: 1px solid var(--gray-200); border-radius: 12px; }
        .form-control, .form-select { border-radius: 12px; padding: 10px 15px; }
    </style>

    {{-- Livewire 3 Listener for Modal Closing/Opening --}}
    <div x-data="{}"
         x-init="
            Livewire.on('close-modal', (event) => {
                $('#' + event.modal).modal('hide');
            });
            Livewire.on('open-modal', (event) => {
                $('#' + event.modal).modal('show');
            });
        ">

        @if(session()->has('message'))
            <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm" role="alert">
                <i class="ti ti-check-circle me-1"></i> {{ session('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @if(session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show rounded-3 shadow-sm" role="alert">
                <i class="ti ti-alert-circle me-1"></i> {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="header-section pb-3 mb-4 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <h1 class="mb-0 fs-3 fw-bolder text-dark">
                <i class="ti ti-border-style text-primary me-2"></i> مدیریت قالب‌های سربرگ
            </h1>
            {{-- 🟢 اصلاح: دکمه افزودن، فقط برای کاربرانی که Gate دسترسی 'manage-structure' را دارند، نمایش داده می‌شود. --}}
            @if(Gate::allows('manage-structure'))
                <button wire:click="resetFields" data-bs-toggle="modal" data-bs-target="#formModal" class="btn btn-primary px-4 py-2 rounded-pill shadow">
                    <i class="ti ti-plus me-1"></i> سربرگ جدید
                </button>
            @endif
        </div>

        <div class="row mb-4 g-3 align-items-center">
            <div class="col-md-5">
                <input type="text" wire:model.live="search" class="form-control rounded-pill" placeholder="جستجوی نام سربرگ...">
            </div>
            <div class="col text-end text-muted small d-none d-md-inline">
                تعداد کل: <b>{{ $letterForms->count() }}</b> مورد
            </div>
        </div>

        <div class="row g-4 min-vh-30">
            @forelse($letterForms as $letterForm)
                <div class="col-sm-6 col-lg-4">
                    <div class="card border-0 hover-shadow shadow-sm h-100">
                        <div class="card-body text-center">

                            <div class="form-name-display">{{ $letterForm->name }}</div>

                            <div class="preview-box mb-3">
                                <img src="{{ $this->getBackgroundUrl($letterForm->background) }}"
                                     alt="{{ $letterForm->name }}"
                                     class="img-fluid">
                            </div>

                            {{-- ✨ وضعیت دسترسی --}}
                            @if($letterForm->is_global)
                                <span class="badge bg-success-subtle text-success mb-3">قالب عمومی</span>
                            @else
                                <span class="badge bg-primary-subtle text-primary mb-3">قالب اختصاصی</span>
                            @endif

                            {{-- 🟢 اصلاح: دکمه‌های عملیاتی، فقط برای کاربرانی که Gate دسترسی دارند. --}}
                            @if(Gate::allows('manage-structure'))
                                <div class="btn-group action-group">
                                    <button wire:click="previewLetterForm({{ $letterForm->id }})" class="btn btn-sm btn-outline-info">
                                        <i class="ti ti-eye"></i>
                                    </button>
                                    <button wire:click="editLetterForm({{ $letterForm->id }})" class="btn btn-sm btn-outline-warning">
                                        <i class="ti ti-edit"></i>
                                    </button>
                                    <button wire:click="deleteLetterForm({{ $letterForm->id }})" class="btn btn-sm btn-outline-danger"
                                            onclick="return confirm('آیا مطمئن هستید؟ حذف این سربرگ می‌تواند نامه‌های وابسته را مختل کند.')">
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12 pt-5 text-secondary text-center fs-5">
                    <i class="ti ti-file-off fs-1 mb-3"></i><br>
                    هیچ سربرگی ثبت نشده است.
                </div>
            @endforelse
        </div>

        {{-- 🟢 اصلاح: مدال افزودن/ویرایش، فقط برای کاربرانی که Gate دسترسی دارند. --}}
        @if(Gate::allows('manage-structure'))
            <div class="modal fade" id="formModal" tabindex="-1" wire:ignore.self>
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content rounded-4 shadow-lg">
                        <div class="modal-header py-3 border-bottom-0">
                            <h5 class="modal-title fw-bold text-primary">{{ $editFormId ? 'ویرایش سربرگ' : 'افزودن سربرگ جدید' }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body pt-4">
                            <form wire:submit.prevent="{{ $editFormId ? 'updateLetterForm' : 'saveLetterForm' }}">
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label fw-bold">عنوان:</label>
                                        <input type="text" wire:model.defer="name" class="form-control" placeholder="نام فرم">
                                        @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label fw-bold">سربرگ تصویر (JPEG, PNG, SVG):</label>

                                        <label for="bg-file-upload" class="upload-placeholder text-center">
                                            <i class="ti ti-cloud-upload fs-3 mb-2"></i>
                                            <p class="mb-1 fw-bold">انتخاب فایل</p>
                                            <span class="file-info">حداکثر ۲ مگابایت</span>
                                        </label>
                                        <input type="file" id="bg-file-upload" wire:model="background" style="display:none;">

                                        @error('background') <span class="text-danger small">{{ $message }}</span> @enderror

                                        @if ($background || $currentBackgroundPath)
                                            <div class="mt-3 p-3 file-info-box d-flex flex-column align-items-center">
                                                <p class="file-info mb-2 text-dark">{{ $background ? $background->getClientOriginalName() : 'فایل فعلی' }}</p>

                                                @if ($background)
                                                    <img src="{{ $background->temporaryUrl() }}" class="uploaded-preview">
                                                @elseif($currentBackgroundPath)
                                                    <img src="{{ $currentBackgroundPath }}" class="uploaded-preview">
                                                @endif

                                                <button type="button" wire:click="resetBackground" class="btn btn-sm btn-outline-danger mt-2">
                                                    <i class="ti ti-trash"></i> حذف فایل
                                                </button>
                                            </div>
                                        @endif
                                    </div>

                                    {{-- ✨ کنترل دسترسی سازمانی --}}
                                    <div class="col-12 mt-4">
                                        <h6 class="fw-bold text-primary mb-3">تنظیمات دسترسی</h6>

                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" role="switch" id="isGlobalSwitch" wire:model.live="is_global">
                                            <label class="form-check-label fw-bold" for="isGlobalSwitch">قابل استفاده برای همه شرکت‌ها (عمومی)</label>
                                        </div>

                                        {{-- ✨ انتخاب شرکت‌ها: فقط اگر عمومی نباشد --}}
                                        <div class="access-control-box" x-show="!$wire.is_global">
                                            <label class="form-label fw-bold text-gray-600">اختصاص به شرکت‌های زیر:</label>
                                            <select wire:model.defer="selectedCompanies" class="form-select" multiple style="min-height: 150px;">
                                                @foreach($companies as $company)
                                                    <option value="{{ $company->id }}">{{ $company->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('selectedCompanies') <span class="text-danger small mt-1 d-block">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="d-grid mt-4">
                                    <button type="submit" class="btn btn-primary rounded-3 py-2 fw-bold" style="background-color: var(--primary);">
                                        <i class="ti ti-check"></i> {{ $editFormId ? 'ذخیره تغییرات' : 'ذخیره سربرگ' }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="modal fade" id="previewModal" tabindex="-1" wire:ignore.self>
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0 rounded-4 shadow-lg">
                    <div class="modal-header py-3">
                        <h5 class="modal-title fw-bold">{{ $previewForm->name ?? 'پیش‌نمایش' }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body d-flex justify-content-center p-5 bg-light">
                        @if($previewForm)
                            <div class="border rounded-3 bg-white shadow-md overflow-hidden"
                                 style="width:210mm; height: 297mm; border: 1px solid var(--gray-200);">
                                <img src="{{ $this->getBackgroundUrl($previewForm->background) }}"
                                     class="img-fluid w-100 h-100" style="object-fit:contain;">
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
