<div>
    @if(session()->has('message'))
        <div class="alert alert-success">{{ session('message') }}</div>
    @endif

    <form wire:submit.prevent="saveLetter">
        <div>
            <label for="subject">موضوع:</label>
            <input type="text" id="subject" wire:model="subject" placeholder="موضوع">
            @error('subject') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="template">انتخاب قالب:</label>
            <select id="template" wire:model="selectedTemplate">
                <option value="">انتخاب قالب</option>
                @foreach($templates as $template)
                    <option value="{{ $template->id }}">{{ $template->name }}</option>
                @endforeach
            </select>
            @error('selectedTemplate') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="body">متن:</label>
            <textarea id="body" wire:model="body" placeholder="متن"></textarea>
            @error('body') <span class="error">{{ $message }}</span> @enderror
        </div>

        <div>
            <label for="selectedUsers">انتخاب تاییدکنندگان:</label>
            <select id="selectedUsers" wire:model="selectedUsers" multiple>
                @foreach($users as $user)
                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                @endforeach
            </select>
            @error('selectedUsers') <span class="error">{{ $message }}</span> @enderror
        </div>

        <button type="submit">ارسال</button>
    </form>

    <h3>نامه‌ها:</h3>
    @foreach($letters as $letter)
        <div>
            <h4>{{ $letter->subject }}</h4>
            <p>{{ $letter->body }}</p>
            <p>کاربر: {{ $letter->user->name }}</p>
            <h5>تاییدیه‌ها:</h5>
            <ul>
                @foreach($letter->approvals as $approval)
                    <li>{{ $approval->user->name }}: {{ $approval->is_approved ? 'تایید شده' : 'در انتظار تایید' }}</li>
                @endforeach
            </ul>
        </div>
    @endforeach
</div>
