<div class="incoming-list-container" dir="rtl">
    <style>
        /* Modern & Glassmorphism Styles */
        :root {
            --primary: #4361ee;
            --primary-dark: #3a0ca3;
            --info: #4cc9f0;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --glass-bg: rgba(255, 255, 255, 0.2); /* سبک شیشه‌ای */
            --card-bg: #ffffff;
            --border: #e5e7eb;
            --text: #1e293b;
            --text-muted: #64748b;
        }

        .page-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-radius: 20px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(58, 12, 163, 0.4);
            backdrop-filter: blur(10px); /* اعمال جلوه شیشه‌ای */
        }
        .page-header::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.1);
            pointer-events: none;
            z-index: 0;
        }
        .page-header > * {
            position: relative;
            z-index: 1;
        }

        .search-input {
            background: var(--glass-bg);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 0.6rem 1.2rem 0.6rem 2.5rem;
            border-radius: 50px;
            transition: all 0.2s;
        }
        .search-input:focus {
            background: rgba(255,255,255,0.4);
            box-shadow: 0 0 0 3px rgba(255,255,255,0.4);
        }
        .search-input::placeholder { color: rgba(255,255,255,0.8); }
        .search-icon {
            position: absolute;
            right: 1.2rem;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255,255,255,0.9);
            z-index: 2;
        }

        .table-card {
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
            border: none;
            background: var(--card-bg);
        }
        .table thead th {
            background: #f8fafc;
            color: var(--text);
            font-weight: 700;
            font-size: 0.9rem;
        }
        .table tbody tr {
            transition: background-color 0.2s;
            cursor: pointer;
        }
        .table tbody tr:hover {
            background: #f7f9fd;
        }
        .status-badge {
            padding: 0.4rem 1rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
        }

        /* File Preview Modal Styles (Modernized) */
        .file-preview-modal {
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1055;
            transition: opacity 0.3s ease;
        }
        .modal-content {
            max-width: 1100px;
            height: 90vh;
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0,0,0,0.4);
        }
        .file-viewer {
            flex: 1;
            display: flex;
            overflow: hidden;
        }
        .file-info-sidebar {
            width: 250px;
            background: #f8fafc;
            border-left: 1px solid var(--border);
            padding: 1rem;
            overflow-y: auto;
        }
        .file-main {
            flex: 1;
            overflow: hidden;
        }
        .file-preview-container, .file-text-preview {
            height: 100%;
            width: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
        }
        .pdf-viewer {
            width: 100%;
            height: 100%;
            border-radius: 12px;
        }
        .file-text-preview pre {
            max-height: 100%;
            white-space: pre-wrap;
            word-wrap: break-word;
            font-size: 0.9rem;
            direction: ltr; /* برای نمایش بهتر کد و متن‌های انگلیسی */
        }
        .nav-btn {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            transition: all 0.2s;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.15);
        }

        .list-group-item-action:hover {
            background-color: #eef2ff;
        }
    </style>

    <div class="page-header">
        <div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
            <div class="d-flex align-items-center mb-2 mb-md-0">
                <div class="p-3 rounded-4 bg-white bg-opacity-30 me-3">
                    <i class="fas fa-file-import text-white fs-3"></i>
                </div>
                <div>
                    <h2 class="text-white fw-bolder mb-0">مدیریت نامه‌های وارده</h2>
                    <p class="text-white-75 mb-0 small opacity-75">نمایش، جستجو و پیگیری نامه‌های دریافتی سازمان</p>
                </div>
            </div>
            <a href="{{ route('admin.register.incoming') }}" class="btn btn-light btn-sm rounded-pill px-4 fw-bold shadow-sm">
                <i class="fas fa-plus me-2"></i> ثبت نامه جدید
            </a>
        </div>

        <div class="d-flex flex-wrap gap-3 align-items-center">
            <div class="position-relative flex-grow-1" style="min-width: 200px;">
                <i class="fas fa-search search-icon"></i>
                <input type="text" wire:model.live.debounce.400ms="search"
                       class="form-control search-input"
                       placeholder="جستجوی موضوع یا فرستنده..." aria-label="جستجوی موضوع">
            </div>

            <div class="position-relative" style="width: 130px;">
                <i class="fas fa-hashtag search-icon"></i>
                <input type="text" wire:model.live.debounce.400ms="searchCode"
                       class="form-control search-input"
                       placeholder="شماره/کد" aria-label="جستجوی کد">
            </div>

            <select class="form-select form-select-sm rounded-pill"
                    style="width: 150px; background: rgba(255,255,255,0.25); color: white; border: none; font-size: 0.85rem;"
                    wire:model.live="filterStatus" aria-label="فیلتر وضعیت">
                <option value="all" class="text-dark">همه وضعیت‌ها</option>
                @foreach($this->statuses as $key => $status)
                    <option value="{{ $key }}" class="text-dark">{{ $status['label'] }}</option>
                @endforeach
            </select>

            <button wire:click="resetFilters" class="btn btn-outline-light btn-sm rounded-pill px-3 fw-bold shadow-sm" title="پاک کردن فیلترها">
                <i class="fas fa-sync-alt me-1"></i> بازنشانی
            </button>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="card shadow-sm chart-card">
                <div class="card-header bg-white border-bottom p-3">
                    <h6 class="mb-0 fw-bold text-dark fs-6"><i class="fas fa-chart-bar me-2 text-primary"></i> توزیع وضعیت نامه‌ها</h6>
                </div>
                <div class="card-body p-3">
                    <div id="statusChart" style="height: 250px; direction: ltr;"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-header bg-white border-bottom p-3">
                    <h6 class="mb-0 fw-bold text-dark fs-6"><i class="fas fa-clipboard-list me-2 text-info"></i> آمار کلی</h6>
                </div>
                <div class="card-body p-3">
                    <div class="d-flex flex-column gap-3">
                        @foreach($this->statuses as $key => $status)
                            @php
                                $countVar = "{$key}Count";
                                $count = $this->$countVar ?? 0;
                            @endphp
                            <div class="d-flex justify-content-between align-items-center border-bottom pb-2">
                                <span class="text-muted small">{{ $status['label'] }}</span>
                                <span class="fw-bolder fs-5 text-{{ $status['color'] }}">{{ $count }}</span>
                            </div>
                        @endforeach
                        <div class="d-flex justify-content-between align-items-center pt-2 border-top">
                            <span class="fw-bold">کل نامه‌ها</span>
                            <span class="fw-bolder fs-4 text-primary">{{ $totalCount }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="table-card mb-4">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                <tr>
                    <th style="width: 10%;">شماره خارجی</th>
                    <th style="width: 30%;">موضوع</th>
                    <th style="width: 20%;">فرستنده</th>
                    <th style="width: 15%;">تاریخ نامه</th>
                    <th style="width: 15%;" class="text-center">وضعیت</th>
                    <th style="width: 10%;" class="text-end">عملیات</th>
                </tr>
                </thead>
                <tbody>
                @forelse($this->letters as $letter)
                    <tr wire:click="showPreview({{ $letter->id }})">
                        <td><span class="fw-medium text-dark">{{ $letter->external_number ?? '—' }}</span></td>
                        <td>
                            <div class="fw-bold text-primary">{{ Str::limit($letter->title, 50) }}</div>
                            @if($letter->project)
                                <div class="small text-muted mt-1 d-flex align-items-center">
                                    <i class="fas fa-project-diagram me-1"></i> {{ Str::limit($letter->project->name, 25) }}
                                </div>
                            @endif
                        </td>
                        <td>{{ Str::limit($letter->from_who, 30) }}</td>
                        <td>
                            <i class="far fa-calendar-alt me-1 text-muted"></i>
                            {{ $letter->external_date ? jdate($letter->external_date)->format('Y/m/d') : '—' }}
                        </td>
                        <td class="text-center">
                            @php
                                $status = $this->statuses[$letter->status] ?? ['label' => 'نامشخص', 'color' => 'secondary'];
                                $bgColorClass = match($status['color']) {
                                    'warning' => 'bg-warning-subtle',
                                    'success' => 'bg-success-subtle',
                                    'danger' => 'bg-danger-subtle',
                                    default => 'bg-secondary-subtle'
                                };
                            @endphp
                            <span class="status-badge {{ $bgColorClass }} text-{{ $status['color'] }}" style="border: 1px solid rgba(var(--{{ $status['color'] }}-rgb), 0.2);">
                                <i class="fas fa-circle me-1" style="font-size: 0.5rem;"></i>
                                {{ $status['label'] }}
                            </span>
                        </td>
{{--                        <td class="text-center">--}}
{{--                            @php--}}
{{--                                $status = $this->statuses[$letter->status] ?? ['label' => 'نامشخص', 'color' => 'secondary'];--}}
{{--                            @endphp--}}
{{--                            <span class="status-badge bg-{{ $status['color'] }} bg-opacity-60 text-{{ $status['color'] }}">--}}
{{--                                <i class="fas fa-circle me-1" style="font-size: 0.5rem;"></i>--}}
{{--                                {{ $status['label'] }}--}}
{{--                            </span>--}}
{{--                        </td>--}}
                        <td class="text-end">
                            <button wire:click.stop="showPreview({{ $letter->id }})"
                                    class="btn btn-sm btn-outline-primary rounded-circle p-2"
                                    title="مشاهده جزئیات">
                                <i class="fas fa-eye"></i>
                            </button>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">
                            <i class="fas fa-inbox fa-3x mb-3"></i>
                            <div class="fw-bold">هیچ نامه‌ای یافت نشد.</div>
                            <p class="small">فیلترهای اعمال شده را بررسی کنید.</p>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        @if($this->letters->hasPages())
            <div class="px-3 py-2 border-top bg-light">
                {{ $this->letters->links() }}
            </div>
        @endif
    </div>

    @if ($showPreviewModal && $previewLetter)
        <div x-cloak wire:ignore.self class="file-preview-modal" style="display: flex;">
            <div class="modal-content" style="max-width: 900px; height: auto; max-height: 90vh;">
                <div class="modal-header p-4 border-bottom d-flex justify-content-between align-items-center bg-light">
                    <h5 class="modal-title fw-bolder text-dark">
                        <i class="fas fa-file-invoice me-2 text-primary"></i>
                        جزئیات نامه وارده (کد: {{ $previewLetter->code }})
                    </h5>
                    <button type="button" class="btn-close" wire:click="closePreview"></button>
                </div>
                <div class="modal-body p-4 overflow-auto">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">شماره/کد خارجی</p>
                            <p class="fw-bold fs-6">{{ $previewLetter->external_number ?? '—' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">فرستنده</p>
                            <p class="fw-bold fs-6">{{ $previewLetter->from_who ?? '—' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">تاریخ نامه (خارجی)</p>
                            <p class="fw-bold fs-6">
                                {{ $previewLetter->external_date ? jdate($previewLetter->external_date)->format('Y/m/d') : '—' }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">تاریخ ثبت سیستمی</p>
                            <p class="fw-bold fs-6">
                                {{ jdate($previewLetter->created_at)->format('Y/m/d H:i') }}
                            </p>
                        </div>
                        <div class="col-12">
                            <p class="text-muted mb-1 small">موضوع</p>
                            <p class="fw-bold fs-6 alert alert-primary-subtle p-2">{{ $previewLetter->title }}</p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">طبقه‌بندی</p>
                            <span class="badge bg-info text-dark p-2">{{ $previewLetter->classification->name ?? '—' }}</span>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted mb-1 small">پروژه مرتبط</p>
                            <span class="badge bg-secondary p-2">{{ $previewLetter->project->name ?? '—' }}</span>
                        </div>
                    </div>

                    <div class="pt-4 mt-4 border-top">
                        <h6 class="fw-bold text-primary mb-3 small">
                            <i class="fas fa-paperclip me-2"></i> پیوست‌ها ({{ $previewLetter->attachments->count() }})
                        </h6>
                        @if($previewLetter->attachments->count())
                            <div class="list-group list-group-flush border rounded-3 overflow-hidden">
                                @foreach($previewLetter->attachments as $index => $att)
                                    <div class="list-group-item d-flex justify-content-between align-items-center p-3">
                                        <span class="fw-medium small text-dark d-flex align-items-center">
                                            <i class="fas fa-file me-2 text-info"></i>
                                            {{ Str::limit($att->original_name, 50) }}
                                        </span>
                                        <div class="btn-group btn-group-sm gap-2">
                                            <button wire:click.stop="showAttachmentPreview({{ $previewLetter->id }}, {{ $index }})"
                                                    class="btn btn-outline-info rounded-pill px-3" title="مشاهده فایل">
                                                <i class="fas fa-eye"></i> مشاهده
                                            </button>
                                            <a href="{{ Storage::url($att->file_path) }}" download
                                               class="btn btn-success rounded-pill px-3" title="دانلود فایل">
                                                <i class="fas fa-download"></i> دانلود
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-muted small alert alert-light m-0 text-center">پیوستی برای این نامه ثبت نشده است.</p>
                        @endif
                    </div>
                </div>
                <div class="modal-footer p-3 border-top bg-light d-flex justify-content-end">
                    <button class="btn btn-secondary rounded-pill px-4" wire:click="closePreview">
                        <i class="fas fa-times me-1"></i> بستن جزئیات
                    </button>
                </div>
            </div>
        </div>
    @endif

    @if($showAttachmentModal && !empty($attachmentFiles))
        <div x-cloak wire:ignore.self class="file-preview-modal" style="display: flex;">
            <div class="modal-content">
                <div class="d-flex align-items-center justify-content-between px-4 py-3 border-bottom bg-white">
                    <div class="d-flex align-items-center gap-2">
                        <h6 class="mb-0 fw-bold text-dark"><i class="fas fa-paperclip me-2 text-primary"></i> پیش‌نمایش فایل</h6>
                        <span class="badge bg-primary rounded-pill px-3 py-1 fw-bold">
                            {{ $currentAttachmentIndex + 1 }} / {{ count($attachmentFiles) }}
                        </span>
                    </div>
                    <div class="d-flex gap-2">
                        @php $current = $attachmentFiles[$currentAttachmentIndex] ?? []; @endphp
                        <a href="{{ $current['url'] ?? '#' }}" target="_blank" class="btn btn-sm btn-outline-secondary rounded-pill" title="باز کردن در تب جدید">
                            <i class="fas fa-external-link-alt"></i>
                        </a>
                        <a href="{{ $current['url'] ?? '#' }}" download class="btn btn-sm btn-success rounded-pill" title="دانلود">
                            <i class="fas fa-download"></i>
                        </a>
                        <button wire:click="closeAttachmentPreview" class="btn btn-sm btn-danger rounded-pill" title="بستن">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <div class="file-viewer">
                    @if(count($attachmentFiles) > 1)
                        <div class="file-info-sidebar">
                            <h6 class="fw-bold mb-3 small text-muted border-bottom pb-2">فایل‌های پیوست</h6>
                            <div class="list-group">
                                @foreach($attachmentFiles as $idx => $file)
                                    <button
                                        wire:click="setCurrentAttachmentIndex({{ $idx }})"
                                        class="list-group-item list-group-item-action rounded-3 mb-2 p-2 {{ $idx === $currentAttachmentIndex ? 'border-primary bg-primary bg-opacity-10 text-primary fw-bold' : 'text-dark' }}"
                                    >
                                        <div class="d-flex align-items-center small">
                                            <i class="fas fa-file me-2 {{ $idx === $currentAttachmentIndex ? 'text-primary' : 'text-info' }}"></i>
                                            <span class="text-truncate" style="flex: 1;">{{ Str::limit($file['name'], 25) }}</span>
                                            @if($idx === $currentAttachmentIndex)
                                                <i class="fas fa-angle-left ms-2"></i>
                                            @endif
                                        </div>
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <div class="file-main position-relative">
                        @if(!empty($attachmentFiles))
                            @php
                                $current = $attachmentFiles[$currentAttachmentIndex] ?? null;
                                $mime = $current['mime'] ?? '';
                            @endphp

                            @if($current)
                                <div class="px-4 py-2 border-bottom bg-white d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-0 small fw-bold">{{ $current['name'] }}</h6>
                                        <div class="file-meta">
                                            <div><i class="fas fa-tag"></i> {{ pathinfo($current['name'], PATHINFO_EXTENSION) ?: '—' }}</div>
                                            <div><i class="fas fa-weight-hanging"></i> {{ $current['size'] ?? 'نامشخص' }}</div>
                                            <div><i class="fas fa-clock"></i> {{ $current['created_at'] ?? 'نامشخص' }}</div>
                                        </div>
                                    </div>
                                    <span class="badge bg-light text-muted small">{{ $mime }}</span>
                                </div>

                                @if(count($attachmentFiles) > 1)
                                    <div class="position-absolute top-50 start-0 translate-middle-y ms-2" style="z-index: 10;">
                                        <button wire:click="prevAttachment" @disabled($currentAttachmentIndex <= 0) class="btn nav-btn {{ $currentAttachmentIndex <= 0 ? 'opacity-50' : 'btn-light' }}" title="فایل قبلی">
                                            <i class="fas fa-chevron-right"></i>
                                        </button>
                                    </div>
                                    <div class="position-absolute top-50 end-0 translate-middle-y me-2" style="z-index: 10;">
                                        <button wire:click="nextAttachment" @disabled($currentAttachmentIndex >= count($attachmentFiles) - 1) class="btn nav-btn {{ $currentAttachmentIndex >= count($attachmentFiles) - 1 ? 'opacity-50' : 'btn-light' }}" title="فایل بعدی">
                                            <i class="fas fa-chevron-left"></i>
                                        </button>
                                    </div>
                                @endif

                                @if(str_starts_with($mime, 'image/'))
                                    <div class="file-preview-container bg-light">
                                        <img src="{{ $current['url'] }}" alt="پیش‌نمایش تصویر" class="img-fluid rounded shadow-sm">
                                    </div>
                                @elseif(str_starts_with($mime, 'application/pdf'))
                                    <div class="file-preview-container p-0">
                                        <iframe src="{{ $current['url'] }}#toolbar=0&navpanes=0&scrollbar=0" class="pdf-viewer rounded-bottom" sandbox="allow-scripts allow-same-origin allow-popups allow-forms" allow="autoplay"></iframe>
                                    </div>
                                @elseif(str_starts_with($mime, 'text/'))
                                    <div class="file-text-preview bg-light overflow-auto">
                                        <pre class="p-3 border rounded text-dark bg-white shadow-sm">{{ $attachmentPreviewText }}</pre>
                                    </div>
                                @elseif($attachmentPreviewText)
                                    <div class="file-preview-container bg-light">
                                        <div class="text-center p-4 alert alert-warning m-0">
                                            <i class="fas fa-exclamation-triangle fa-2x mb-3 text-warning"></i>
                                            <p class="fw-bold">{{ $attachmentPreviewText }}</p>
                                            <a href="{{ $current['url'] }}" download class="btn btn-warning btn-sm rounded-pill px-3 mt-2">
                                                <i class="fas fa-download me-1"></i> دانلود برای مشاهده
                                            </a>
                                        </div>
                                    </div>
                                @else
                                    <div class="file-preview-container d-flex flex-column align-items-center justify-content-center bg-light">
                                        <i class="fas fa-file-excel fa-3x text-muted mb-3"></i>
                                        <p class="text-muted text-center mb-3 fw-bold">پیش‌نمایش این نوع فایل ممکن نیست.</p>
                                        <a href="{{ $current['url'] }}" download class="btn btn-primary rounded-pill px-4">
                                            <i class="fas fa-download me-1"></i> دانلود فایل
                                        </a>
                                    </div>
                                @endif
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif


    @push('scripts')
{{--        <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>--}}
        <script>
            let statusChartInstance = null;

            // تابع رندر نمودار
            function renderStatusChart(pending, approved, rejected) {
                const chartData = [pending, approved, rejected];
                const chartOptions = {
                    chart: {
                        type: 'bar',
                        height: '250',
                        fontFamily: 'Vazir, Tahoma, sans-serif',
                        toolbar: { show: false }
                    },
                    series: [{
                        name: 'تعداد نامه‌ها',
                        data: chartData
                    }],
                    colors: ['#f59e0b', '#10b981', '#ef4444'], // warning, success, danger
                    plotOptions: {
                        bar: {
                            borderRadius: 8,
                            horizontal: false,
                            columnWidth: '50%',
                        }
                    },
                    dataLabels: {
                        enabled: true,
                        formatter: function(val) { return val; },
                        style: { colors: ['#fff'], fontSize: '11px', fontWeight: 600 }
                    },
                    xaxis: {
                        categories: ['در انتظار', 'بایگانی شده', 'رد شده'],
                        labels: { style: { fontSize: '12px', colors: ['#64748b'] } }
                    },
                    yaxis: {
                        labels: { style: { fontSize: '12px', colors: ['#64748b'] } }
                    },
                    grid: {
                        borderColor: '#f1f1f1',
                        strokeDashArray: 3
                    },
                    tooltip: {
                        y: { formatter: function(val) { return val + ' نامه'; } },
                        style: { fontFamily: 'Vazir, Tahoma, sans-serif' }
                    }
                };

                const chartElement = document.querySelector("#statusChart");

                if (statusChartInstance) {
                    statusChartInstance.updateSeries([{ data: chartData }]);
                } else if (chartElement) {
                    statusChartInstance = new ApexCharts(chartElement, chartOptions);
                    statusChartInstance.render();
                }
            }

            // اجرای اولیه و گوش دادن به تغییرات Livewire
            document.addEventListener('livewire:initialized', () => {
                // اجرای اولیه
                renderStatusChart(
                    @js($pendingCount),
                    @js($approvedCount),
                    @js($rejectedCount)
                );
            });

            // به‌روزرسانی نمودار پس از هر بار رندر
            Livewire.hook('morph.finished', ({ component }) => {
                if (component.name === 'admin.letter.incoming-letters-list') {
                    renderStatusChart(
                        @js($pendingCount),
                        @js($approvedCount),
                        @js($rejectedCount)
                    );
                }
            });

        </script>
    @endpush
</div>
